/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.cache.CacheKey;
import com.griefcraft.cache.LRUCache;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.BlockMap;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.History;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.limits.LimitsModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.sql.Column;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.Table;
import com.griefcraft.util.Statistics;
import com.griefcraft.util.UUIDRegistry;
import com.griefcraft.util.config.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PhysDB
extends Database {
    private final JSONParser jsonParser = new JSONParser();
    private int databaseVersion = 0;
    private int entityLockingDatabaseVersion = 0;
    private int protectionCount = 0;

    public PhysDB() {
    }

    public PhysDB(Database.Type currentType) {
        super(currentType);
    }

    public void decrementProtectionCount() {
        --this.protectionCount;
    }

    public boolean hasAllProtectionsCached() {
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        return cache.size() >= this.protectionCount;
    }

    private Object fetch(String sql, String column, Object ... toBind) throws SQLException {
        PreparedStatement statement = this.prepare(sql);
        int index = 1;
        for (Object bind : toBind) {
            statement.setObject(index, bind);
            ++index;
        }
        ResultSet set = statement.executeQuery();
        Object object = null;
        if (set.next()) {
            object = set.getObject(column);
        }
        set.close();
        return object;
    }

    public int getProtectionCount() {
        return this.runAndThrowModuleExceptionIfFailing(() -> Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "protections", "count", new Object[0]).toString()));
    }

    public int getProtectionCount(Protection.Type type) {
        return this.runAndThrowModuleExceptionIfFailing(() -> Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "protections WHERE type = " + type.ordinal(), "count", new Object[0]).toString()));
    }

    public int getHistoryCount() {
        return this.runAndThrowModuleExceptionIfFailing(() -> Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "history", "count", new Object[0]).toString()));
    }

    public int getProtectionCount(String player) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            int count = 0;
            PreparedStatement statement = this.prepare("SELECT COUNT(*) as count FROM " + this.prefix + "protections WHERE owner = ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                count = set.getInt("count");
            }
            set.close();
            return count;
        });
    }

    public int getHistoryCount(String player) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            int count = 0;
            PreparedStatement statement = this.prepare("SELECT COUNT(*) AS count FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?)");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                count = set.getInt("count");
            }
            set.close();
            return count;
        });
    }

    public int getProtectionCount(String player, Material block) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            int count = 0;
            PreparedStatement statement = this.prepare("SELECT COUNT(*) AS count FROM " + this.prefix + "protections WHERE owner = ? AND blockId = ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            statement.setInt(2, BlockMap.instance().getId(block));
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                count = set.getInt("count");
            }
            set.close();
            return count;
        });
    }

    @Override
    public void load() {
        if (this.loaded) {
            return;
        }
        this.databaseVersion = 0;
        this.loadDatabaseVersion();
        this.entityLockingDatabaseVersion = 0;
        this.loadEntityLockingDatabaseVersion();
        if (this.entityLockingDatabaseVersion < 1) {
            this.doUpdate301();
            this.doUpdate302();
            this.doUpdate330();
            this.doUpdate400_4();
            this.doUpdate400_5();
            this.doUpdate400_6();
            this.doUpdate5_0_12();
            boolean resetDatabaseVersion = this.doUpdateModernLWC();
            Table protections = new Table(this, "protections");
            Column column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            protections.add(column);
            column = new Column("owner");
            column.setType("VARCHAR(36)");
            protections.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("x");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("y");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("z");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("entityid");
            column.setType("VARCHAR(36)");
            protections.add(column);
            column = new Column("data");
            column.setType("TEXT");
            protections.add(column);
            column = new Column("blockId");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("world");
            column.setType("VARCHAR(50)");
            protections.add(column);
            column = new Column("password");
            column.setType("VARCHAR(255)");
            protections.add(column);
            column = new Column("date");
            column.setType("VARCHAR(50)");
            protections.add(column);
            column = new Column("last_accessed");
            column.setType("INTEGER");
            protections.add(column);
            Table history = new Table(this, "history");
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            history.add(column);
            column = new Column("protectionId");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("player");
            column.setType("VARCHAR(36)");
            history.add(column);
            column = new Column("x");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("y");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("z");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("status");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("metadata");
            column.setType("VARCHAR(255)");
            history.add(column);
            column = new Column("timestamp");
            column.setType("long");
            history.add(column);
            Table internal = new Table(this, "internal");
            column = new Column("name");
            column.setType("VARCHAR(40)");
            column.setPrimary(true);
            column.setAutoIncrement(false);
            internal.add(column);
            column = new Column("value");
            column.setType("VARCHAR(40)");
            internal.add(column);
            Table blockMappings = new Table(this, "blocks");
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            column.setAutoIncrement(false);
            blockMappings.add(column);
            column = new Column("name");
            column.setType("VARCHAR(40)");
            blockMappings.add(column);
            this.runAndThrowModuleExceptionIfFailing(() -> {
                protections.execute();
                history.execute();
                internal.execute();
                blockMappings.execute();
            });
            this.databaseVersion = 0;
            this.entityLockingDatabaseVersion = 0;
            if (!resetDatabaseVersion) {
                this.loadDatabaseVersion();
                this.loadEntityLockingDatabaseVersion();
                if (this.databaseVersion < 0) {
                    this.databaseVersion = 0;
                }
                if (this.entityLockingDatabaseVersion < 0) {
                    this.entityLockingDatabaseVersion = 0;
                }
            }
        }
        this.performDatabaseUpdates();
        this.protectionCount = this.getProtectionCount();
        this.loaded = true;
    }

    public void performDatabaseUpdates() {
        LWC lwc = LWC.getInstance();
        if (this.entityLockingDatabaseVersion == 0) {
            this.databaseVersion = 0;
        }
        if (this.databaseVersion == 0) {
            this.dropIndex("protections", "in1");
            this.dropIndex("protections", "in6");
            this.dropIndex("protections", "in7");
            this.dropIndex("history", "in8");
            this.dropIndex("history", "in9");
            this.dropIndex("protections", "in10");
            this.dropIndex("history", "in12");
            this.dropIndex("history", "in13");
            this.dropIndex("history", "in14");
            this.doUpdatesDatabaseVersion7();
            this.createIndex("protections", "protections_main", "x, y, z, world");
            this.createIndex("protections", "protections_entity", "entityid");
            this.createIndex("protections", "protections_utility", "owner");
            this.createIndex("history", "history_main", "protectionId");
            this.createIndex("history", "history_utility", "player");
            this.createIndex("history", "history_utility2", "x, y, z");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 1) {
            this.createIndex("internal", "internal_main", "name");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 2) {
            this.doUpdate400_2();
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 3) {
            this.createIndex("protections", "protections_type", "type");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 4) {
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 5) {
            boolean foundTrappedChest = false;
            for (String key : lwc.getConfiguration().getNode("protections.blocks").getKeys(null)) {
                if (!key.equalsIgnoreCase("trapped_chest")) continue;
                foundTrappedChest = true;
                break;
            }
            if (!foundTrappedChest) {
                lwc.getConfiguration().setProperty("protections.blocks.trapped_chest.enabled", true);
                lwc.getConfiguration().setProperty("protections.blocks.trapped_chest.autoRegister", "private");
                lwc.getConfiguration().save();
                Configuration.reload();
                lwc.log("Added Trapped Chests to core.yml as default protectable (ENABLED & AUTO REGISTERED)");
                lwc.log("Trapped chests are nearly the same as reg chests but can light up! They can also be double chests.");
                lwc.log("If you DO NOT want this as protected, simply remove it from core.yml! (search/look for trapped_chests under protections -> blocks");
            }
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 6) {
            this.doUpdatesDatabaseVersion7();
            this.createIndex("protections", "protections_main", "x, y, z, world");
            this.createIndex("protections", "protections_utility", "owner");
            this.createIndex("history", "history_utility", "player");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 7) {
            this.doUpdatesDatabaseVersion7();
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 8) {
            this.doUpdatesDatabaseVersion8();
            this.incrementDatabaseVersion();
        }
        if (this.entityLockingDatabaseVersion == 0) {
            this.incrementEntityLockingDatabaseVersion();
        }
    }

    public void incrementDatabaseVersion() {
        this.setDatabaseVersion(++this.databaseVersion);
    }

    public void incrementEntityLockingDatabaseVersion() {
        this.setEntityLockingDatabaseVersion(++this.entityLockingDatabaseVersion);
    }

    public void setDatabaseVersion(int databaseVersion) {
        this.databaseVersion = databaseVersion;
        this.runAndLogException(() -> {
            PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "internal SET value = ? WHERE name = ?");
            statement.setInt(1, databaseVersion);
            statement.setString(2, "version");
            statement.executeUpdate();
        });
    }

    public void setEntityLockingDatabaseVersion(int databaseVersion) {
        this.entityLockingDatabaseVersion = databaseVersion;
        this.runAndLogException(() -> {
            PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "internal SET value = ? WHERE name = ?");
            statement.setInt(1, this.entityLockingDatabaseVersion);
            statement.setString(2, "entityversion");
            statement.executeUpdate();
        });
    }

    public String getInternal(String key) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            String value = null;
            PreparedStatement statement = this.prepare("SELECT value FROM " + this.prefix + "internal WHERE name = ?");
            statement.setString(1, key);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                value = set.getString("value");
            }
            set.close();
            return value;
        });
    }

    public void setInternal(String key, String value) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            try {
                PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "internal (name, value) VALUES (?, ?)");
                statement.setString(1, key);
                statement.setString(2, value);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "internal SET value = ? WHERE name = ?");
                statement.setString(1, value);
                statement.setString(2, key);
                statement.executeUpdate();
            }
        });
    }

    private boolean hasInternalTable() throws SQLException {
        PreparedStatement statement = null;
        if (this.getType() == Database.Type.SQLite) {
            statement = this.prepare("SELECT name FROM sqlite_master WHERE name = ?");
        } else if (this.getType() == Database.Type.MySQL) {
            statement = this.prepare("SHOW TABLES LIKE ?");
        } else {
            return false;
        }
        statement.setString(1, this.prefix + "internal");
        ResultSet set = statement.executeQuery();
        boolean hasTable = set.next();
        set.close();
        return hasTable;
    }

    public void loadDatabaseVersion() {
        this.databaseVersion = this.runAndLogException(() -> {
            int databaseVersion = -1;
            if (!this.hasInternalTable()) {
                return -1;
            }
            PreparedStatement statement = this.prepare("SELECT value FROM " + this.prefix + "internal WHERE name = ?");
            statement.setString(1, "version");
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                databaseVersion = Integer.parseInt(set.getString("value"));
            } else {
                statement = this.prepare("INSERT INTO " + this.prefix + "internal (name, value) VALUES(?, ?)");
                statement.setString(1, "version");
                statement.setInt(2, databaseVersion);
                statement.executeUpdate();
            }
            set.close();
            return databaseVersion;
        });
    }

    public void loadEntityLockingDatabaseVersion() {
        this.entityLockingDatabaseVersion = this.runAndLogException(() -> {
            int entityLockingDatabaseVersion = -1;
            if (!this.hasInternalTable()) {
                return -1;
            }
            PreparedStatement statement = this.prepare("SELECT value FROM " + this.prefix + "internal WHERE name = ?");
            statement.setString(1, "entityversion");
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                entityLockingDatabaseVersion = Integer.parseInt(set.getString("value"));
            } else {
                statement = this.prepare("INSERT INTO " + this.prefix + "internal (name, value) VALUES(?, ?)");
                statement.setString(1, "entityversion");
                statement.setInt(2, entityLockingDatabaseVersion);
                statement.executeUpdate();
            }
            set.close();
            return entityLockingDatabaseVersion;
        });
    }

    public Protection loadProtection(int id) {
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        Protection cached = cache.getProtectionById(id);
        if (cached != null) {
            return cached;
        }
        Protection protection = this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE id = ?");
            statement.setInt(1, id);
            return this.resolveProtection(statement);
        });
        if (protection != null) {
            cache.addProtection(protection);
        }
        return protection;
    }

    public List<Protection> loadProtectionsUsingType(Protection.Type type) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE type = ?");
            statement.setInt(1, type.ordinal());
            return this.resolveProtections(statement);
        });
    }

    private Protection resolveProtection(ResultSet set) throws SQLException {
        JSONObject map;
        JSONArray array;
        Protection protection = new Protection();
        int protectionId = set.getInt("id");
        int x = set.getInt("x");
        int y = set.getInt("y");
        int z = set.getInt("z");
        String entityidString = set.getString("entityid");
        UUID entityid = entityidString == null ? null : UUID.fromString(entityidString);
        int blockId = set.getInt("blockId");
        int type = set.getInt("type");
        String world = set.getString("world");
        String owner = set.getString("owner");
        String password = set.getString("password");
        String date = set.getString("date");
        long lastAccessed = set.getLong("last_accessed");
        protection.setId(protectionId);
        protection.setX(x);
        protection.setY(y);
        protection.setZ(z);
        if (blockId == 5000) {
            protection.setIsEntity(true);
        } else {
            protection.setBlockMaterial(BlockMap.instance().getMaterial(blockId));
        }
        protection.setEntityId(entityid);
        protection.setType(Protection.Type.values()[type]);
        protection.setWorld(world);
        protection.setOwner(owner);
        protection.setPassword(password);
        protection.setCreation(date);
        protection.setLastAccessed(lastAccessed);
        String data = set.getString("data");
        if (data == null || data.isBlank()) {
            return protection;
        }
        Object object = null;
        try {
            object = this.jsonParser.parse(data);
        }
        catch (ParseException e) {
            return protection;
        }
        if (!(object instanceof JSONObject)) {
            return protection;
        }
        JSONObject root = (JSONObject)object;
        Object object2 = root.get((Object)"rights");
        if (object2 instanceof JSONArray) {
            array = (JSONArray)object2;
            object2 = array.iterator();
            while (object2.hasNext()) {
                Permission permission;
                Object node = object2.next();
                if (!(node instanceof JSONObject) || (permission = Permission.decodeJSON(map = (JSONObject)node)) == null) continue;
                protection.addPermission(permission);
            }
        }
        if ((object2 = root.get((Object)"flags")) instanceof JSONArray) {
            array = (JSONArray)object2;
            for (Object node : array) {
                Flag flag;
                if (!(node instanceof JSONObject) || (flag = Flag.decodeJSON(map = (JSONObject)node)) == null) continue;
                protection.addFlag(flag);
            }
        }
        return protection;
    }

    private List<Protection> resolveProtections(ResultSet set) throws SQLException {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        while (set.next()) {
            protections.add(this.resolveProtection(set));
        }
        return protections;
    }

    private List<Protection> resolveProtections(PreparedStatement statement) throws SQLException {
        return this.resolveProtections(statement.executeQuery());
    }

    private Protection resolveProtection(PreparedStatement statement) throws SQLException {
        List<Protection> protections = this.resolveProtections(statement);
        return protections.size() == 0 ? null : protections.get(0);
    }

    public void precache() {
        LWC lwc = LWC.getInstance();
        ProtectionCache cache = lwc.getProtectionCache();
        cache.clear();
        int precacheSize = lwc.getConfiguration().getInt("core.precache", -1);
        if (precacheSize == -1) {
            precacheSize = lwc.getConfiguration().getInt("core.cacheSize", 10000);
        }
        int finalPrecacheSize = precacheSize;
        List protections = this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections ORDER BY id DESC LIMIT ?");
            statement.setInt(1, finalPrecacheSize);
            statement.setFetchSize(10);
            return this.resolveProtections(statement);
        });
        for (Protection protection : protections) {
            cache.addProtection(protection);
        }
    }

    public Protection loadProtection(String worldName, int x, int y, int z) {
        return this.loadProtection(worldName, x, y, z, false);
    }

    private Protection loadProtection(String worldName, int x, int y, int z, boolean ignoreProtectionCount) {
        CacheKey cacheKey = ProtectionCache.cacheKey(worldName, x, y, z);
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        Protection cached = cache.getProtection(cacheKey);
        if (cached != null) {
            if (x == y && x == z) {
                Statistics.addEntityCacheHit();
            } else {
                Statistics.addBlockCacheHit();
            }
            return cached;
        }
        if (cache.isDirectKnownNull(cacheKey) || cache.isKnownNull(cacheKey)) {
            if (x == y && x == z) {
                Statistics.addEntityCacheHitNull();
            } else {
                Statistics.addBlockCacheHitNull();
            }
            return null;
        }
        if (!ignoreProtectionCount && this.hasAllProtectionsCached()) {
            return null;
        }
        Protection protection = this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE x = ? AND y = ? AND z = ? AND world = ? AND entityid IS NULL");
            statement.setInt(1, x);
            statement.setInt(2, y);
            statement.setInt(3, z);
            statement.setString(4, worldName);
            return this.resolveProtection(statement);
        });
        if (protection != null) {
            cache.addProtection(protection);
            if (x == y && x == z) {
                Statistics.addEntityCacheMiss();
            } else {
                Statistics.addBlockCacheMiss();
            }
        } else {
            if (x == y && x == z) {
                Statistics.addEntityCacheMissNull();
            } else {
                Statistics.addBlockCacheMissNull();
            }
            cache.addDirectKnownNull(cacheKey);
        }
        return protection;
    }

    public Protection loadProtection(Entity entity, boolean ignoreProtectionCount) {
        return this.loadProtection(entity.getUniqueId(), ignoreProtectionCount);
    }

    public Protection loadProtection(UUID entityId, boolean ignoreProtectionCount) {
        if (!ignoreProtectionCount && this.hasAllProtectionsCached()) {
            return null;
        }
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        if (cache.isKnownNull(entityId)) {
            return null;
        }
        Protection protection = this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE entityid = ?");
            statement.setString(1, entityId.toString());
            return this.resolveProtection(statement);
        });
        if (protection != null) {
            cache.addProtection(protection);
            Statistics.addEntityCacheMiss();
        } else {
            cache.addKnownNull(entityId);
            Statistics.addEntityCacheMissNull();
        }
        return protection;
    }

    public List<Protection> loadProtections() {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections");
            return this.resolveProtections(statement);
        });
    }

    public List<Protection> loadProtectionsOrderedByChunk() {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed, x>>4 AS xshift4, z>>4 AS zshift4 FROM " + this.prefix + "protections ORDER BY xshift4, zshift4");
            return this.resolveProtections(statement);
        });
    }

    public int removeProtectionsByPlayer(String player) {
        int removed = 0;
        for (Protection protection : this.loadProtectionsByPlayer(player)) {
            protection.remove();
            ++removed;
        }
        return removed;
    }

    public List<Protection> loadProtections(String world, int x1, int x2, int y1, int y2, int z1, int z2) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE world = ? AND x >= ? AND x <= ? AND y >= ? AND y <= ? AND z >= ? AND z <= ? AND entityid IS NULL");
            statement.setString(1, world);
            statement.setInt(2, x1);
            statement.setInt(3, x2);
            statement.setInt(4, y1);
            statement.setInt(5, y2);
            statement.setInt(6, z1);
            statement.setInt(7, z2);
            return this.resolveProtections(statement);
        });
    }

    public List<Protection> loadProtectionsByPlayerAlsoIfNotOwner(String player) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE owner = ? OR data LIKE ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            String playerString = uuid != null ? uuid.toString() : player;
            statement.setString(1, playerString);
            statement.setString(2, "%\"" + playerString + "\"%");
            return this.resolveProtections(statement);
        });
    }

    public List<Protection> loadProtectionsByPlayer(String player) {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE owner = ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            return this.resolveProtections(statement);
        });
    }

    public List<Protection> loadProtectionsByPlayer(String player, int start, int count) {
        UUID uuid = UUIDRegistry.getUUID(player);
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE owner = ? ORDER BY id DESC limit ?,?");
            statement.setString(1, uuid != null ? uuid.toString() : player);
            statement.setInt(2, start);
            statement.setInt(3, count);
            return this.resolveProtections(statement);
        });
    }

    public Protection registerEntityProtection(Entity entity, Protection.Type type, String world, String player, String data, int x, int y, int z) {
        return this.registerProtection(5000, type, world, player, data, x, y, z, entity.getUniqueId());
    }

    public Protection registerProtection(Material block, Protection.Type type, String world, String player, String data, int x, int y, int z) {
        int blockId = BlockMap.instance().registerOrGetId(block);
        return this.registerProtection(blockId, type, world, player, data, x, y, z, null);
    }

    private Protection registerProtection(int blockId, Protection.Type type, String world, String player, String data, int x, int y, int z, UUID entityId) {
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "protections (blockId, type, world, owner, password, x, y, z, entityid, date, last_accessed) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, blockId);
            statement.setInt(2, type.ordinal());
            statement.setString(3, world);
            statement.setString(4, player);
            statement.setString(5, data);
            statement.setInt(6, x);
            statement.setInt(7, y);
            statement.setInt(8, z);
            statement.setString(9, entityId != null ? entityId.toString() : null);
            statement.setString(10, new Timestamp(new Date().getTime()).toString());
            statement.setLong(11, System.currentTimeMillis() / 1000L);
            statement.executeUpdate();
        });
        if (entityId == null) {
            cache.remove(ProtectionCache.cacheKey(world, x, y, z));
        } else {
            cache.remove(entityId);
        }
        Protection protection = entityId != null ? this.loadProtection(entityId, true) : this.loadProtection(world, x, y, z, true);
        protection.removeCache();
        if (LWC.getInstance().isHistoryEnabled()) {
            History transaction = protection.createHistoryObject();
            transaction.setPlayer(player);
            transaction.setType(History.Type.TRANSACTION);
            transaction.setStatus(History.Status.ACTIVE);
            transaction.addMetaData("creator=" + player);
            transaction.saveNow();
        }
        cache.addProtection(protection);
        ++this.protectionCount;
        return protection;
    }

    public void saveHistory(History history) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement;
            if (history.doesExist()) {
                statement = this.prepare("UPDATE " + this.prefix + "history SET protectionId = ?, player = ?, x = ?, y = ?, z = ?, type = ?, status = ?, metadata = ?, timestamp = ? WHERE id = ?");
            } else {
                statement = this.prepare("INSERT INTO " + this.prefix + "history (protectionId, player, x, y, z, type, status, metadata, timestamp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", true);
                history.setTimestamp(System.currentTimeMillis() / 1000L);
            }
            statement.setInt(1, history.getProtectionId());
            statement.setString(2, history.getPlayer());
            statement.setInt(3, history.getX());
            statement.setInt(4, history.getY());
            statement.setInt(5, history.getZ());
            statement.setInt(6, history.getType().ordinal());
            statement.setInt(7, history.getStatus().ordinal());
            statement.setString(8, history.getSafeMetaData());
            statement.setLong(9, history.getTimestamp());
            if (history.doesExist()) {
                statement.setInt(10, history.getId());
            }
            int affectedRows = statement.executeUpdate();
            if (!history.doesExist() && affectedRows > 0) {
                ResultSet generatedKeys = statement.getGeneratedKeys();
                if (generatedKeys.next()) {
                    history.setId(generatedKeys.getInt(1));
                }
                generatedKeys.close();
            }
        });
    }

    public void invalidateHistory(String player) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "history SET status = ? WHERE player = ?");
            statement.setInt(1, History.Status.INACTIVE.ordinal());
            statement.setString(2, player);
            statement.executeUpdate();
        });
    }

    private History resolveHistory(History history, ResultSet set) throws SQLException {
        if (history == null) {
            return null;
        }
        int historyId = set.getInt("id");
        int protectionId = set.getInt("protectionId");
        int x = set.getInt("x");
        int y = set.getInt("y");
        int z = set.getInt("z");
        String player = set.getString("player");
        int type_ord = set.getInt("type");
        int status_ord = set.getInt("status");
        String[] metadata = set.getString("metadata").split(",");
        long timestamp = set.getLong("timestamp");
        History.Type type = History.Type.values()[type_ord];
        History.Status status = History.Status.values()[status_ord];
        history.setId(historyId);
        history.setProtectionId(protectionId);
        history.setType(type);
        history.setPlayer(player);
        history.setX(x);
        history.setY(y);
        history.setZ(z);
        history.setStatus(status);
        history.setMetaData(metadata);
        history.setTimestamp(timestamp);
        return history;
    }

    public List<History> loadHistory(Protection protection) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE protectionId = ? ORDER BY id DESC");
            statement.setInt(1, protection.getId());
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(protection.createHistoryObject(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public List<History> loadHistory(Player player) {
        return this.loadHistory(player.getName());
    }

    public List<History> loadHistory(String player) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?) ORDER BY id DESC");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public History loadHistory(int historyId) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return null;
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE id = ?");
            statement.setInt(1, historyId);
            ResultSet set = statement.executeQuery();
            History history = null;
            if (set.next()) {
                history = this.resolveHistory(new History(), set);
            }
            set.close();
            return history;
        });
    }

    public List<History> loadHistory(Player player, int start, int count) {
        return this.loadHistory(player.getName(), start, count);
    }

    public List<History> loadHistory(String player, int start, int count) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?) ORDER BY id DESC LIMIT ?,?");
            statement.setString(1, player);
            statement.setInt(2, start);
            statement.setInt(3, count);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public List<History> loadHistory() {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history ORDER BY id DESC");
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public List<History> loadHistory(History.Status status) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE status = ? ORDER BY id DESC");
            statement.setInt(1, status.ordinal());
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public List<History> loadHistory(int x, int y, int z) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE x = ? AND y = ? AND z = ?");
            statement.setInt(1, x);
            statement.setInt(2, y);
            statement.setInt(3, z);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public List<History> loadHistory(String player, int x, int y, int z) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?) AND x = ? AND y = ? AND z = ?");
            statement.setString(1, player);
            statement.setInt(2, x);
            statement.setInt(3, y);
            statement.setInt(4, z);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public List<History> loadHistory(int start, int count) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return Collections.emptyList();
        }
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            ArrayList<History> temp = new ArrayList<History>();
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history ORDER BY id DESC LIMIT ?,?");
            statement.setInt(1, start);
            statement.setInt(2, count);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
            return temp;
        });
    }

    public void saveProtection(Protection protection) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("REPLACE INTO " + this.prefix + "protections (id, type, blockId, world, data, owner, password, x, y, z, entityid, date, last_accessed) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, protection.getId());
            statement.setInt(2, protection.getType().ordinal());
            statement.setInt(3, protection.getBlockId());
            statement.setString(4, protection.getWorld());
            JSONObject data = protection.getData();
            statement.setString(5, data == null ? null : data.toJSONString());
            statement.setString(6, protection.getOwner());
            statement.setString(7, protection.getPassword());
            statement.setInt(8, protection.getX());
            statement.setInt(9, protection.getY());
            statement.setInt(10, protection.getZ());
            statement.setString(11, protection.getEntityId() != null ? protection.getEntityId().toString() : null);
            statement.setString(12, protection.getCreation());
            statement.setLong(13, protection.getLastAccessed());
            statement.executeUpdate();
        });
    }

    public void saveProtectionLastAccessed(Protection protection) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "protections SET last_accessed = ? WHERE id = ?");
            statement.setLong(1, protection.getLastAccessed());
            statement.setInt(2, protection.getId());
            statement.executeUpdate();
        });
    }

    public void removeProtection(int protectionId) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "protections WHERE id = ?");
            statement.setInt(1, protectionId);
            int affected = statement.executeUpdate();
            if (affected >= 1) {
                this.protectionCount -= affected;
            }
        });
    }

    public void removeProtectionHistory(int protectionId) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "history WHERE protectionId = ?");
            statement.setInt(1, protectionId);
            statement.executeUpdate();
        });
    }

    public void removeHistory(int historyId) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "history WHERE id = ?");
            statement.setInt(1, historyId);
            statement.executeUpdate();
        });
    }

    public void removeAllProtections() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM " + this.prefix + "protections");
            this.protectionCount = 0;
            statement.close();
        });
    }

    private void createIndex(String table, String indexName, String columns) {
        this.runAndIgnoreException(() -> {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("CREATE INDEX" + (this.currentType == Database.Type.SQLite ? " IF NOT EXISTS" : "") + " " + indexName + " ON " + this.prefix + table + " (" + columns + ")");
            statement.close();
        });
    }

    private void dropIndex(String table, String indexName) {
        this.runAndIgnoreException(() -> {
            Statement statement = this.connection.createStatement();
            if (this.currentType == Database.Type.SQLite) {
                statement.executeUpdate("DROP INDEX IF EXISTS " + indexName);
            } else {
                statement.executeUpdate("DROP INDEX " + indexName + " ON " + this.prefix + table);
            }
            statement.close();
        });
    }

    private void doUpdate301() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            try {
                Statement statement = this.connection.createStatement();
                statement.executeQuery("SELECT * FROM limits LIMIT 1");
                statement.close();
            }
            catch (SQLException e) {
                return;
            }
            LWC lwc = LWC.getInstance();
            Module rawModule = lwc.getModuleLoader().getModule(LimitsModule.class);
            if (rawModule == null) {
                this.log("Failed to load the Limits module. Something is wrong!");
                return;
            }
            LimitsModule limits = (LimitsModule)rawModule;
            PreparedStatement statement = this.prepare("SELECT * FROM limits");
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                int type = result.getInt("type");
                int amount = result.getInt("amount");
                String entity = result.getString("entity");
                switch (type) {
                    case 2: {
                        limits.set("master.type", "default");
                        limits.set("master.limit", amount);
                        break;
                    }
                    case 0: {
                        limits.set("groups." + entity + ".type", "default");
                        limits.set("groups." + entity + ".limit", amount);
                        break;
                    }
                    case 1: {
                        limits.set("players." + entity + ".type", "default");
                        limits.set("players." + entity + ".limit", amount);
                    }
                }
            }
            limits.save();
            this.dropTable("limits");
        });
    }

    private void doUpdate302() {
        if (this.prefix == null || this.prefix.length() == 0) {
            return;
        }
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                statement.execute("SELECT id FROM " + this.prefix + "protections limit 1");
            }
            catch (SQLException e) {
                this.renameTable("protections", this.prefix + "protections");
                this.renameTable("rights", this.prefix + "rights");
                this.renameTable("menu_styles", this.prefix + "menu_styles");
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    private void doUpdate330() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                statement.execute("SELECT last_accessed FROM " + this.prefix + "protections LIMIT 1");
            }
            catch (SQLException e) {
                this.addColumn(this.prefix + "protections", "last_accessed", "INTEGER");
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    private void doUpdate400_2() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                statement.execute("SELECT id FROM " + this.prefix + "rights LIMIT 1");
                this.log("Migrating LWC3 rights to LWC4 format");
                Statement stmt = this.connection.createStatement();
                ResultSet set = stmt.executeQuery("SELECT * FROM " + this.prefix + "rights");
                LRUCache<Integer, Protection> cache = new LRUCache<Integer, Protection>(100000);
                while (set.next()) {
                    int protectionId = set.getInt("chest");
                    String entity = set.getString("entity");
                    int access = set.getInt("rights");
                    int type = set.getInt("type");
                    Protection protection = null;
                    if (cache.containsKey(protectionId)) {
                        protection = (Protection)cache.get(protectionId);
                    } else {
                        protection = this.loadProtection(protectionId);
                        if (protection == null) continue;
                        cache.put(protectionId, protection);
                    }
                    if (protection == null) continue;
                    Permission permission = new Permission(entity, Permission.Type.values()[type], Permission.Access.values()[access]);
                    protection.addPermission(permission);
                }
                for (Protection protection : cache.values()) {
                    protection.saveNow();
                }
                set.close();
                stmt.close();
                this.dropTable(this.prefix + "rights");
                this.precache();
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    private void doUpdate400_4() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                statement.execute("SELECT data FROM " + this.prefix + "protections LIMIT 1");
            }
            catch (SQLException e) {
                this.dropColumn(this.prefix + "protections", "rights");
                this.addColumn(this.prefix + "protections", "data", "TEXT");
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    private void doUpdate400_5() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                Flag flag;
                statement = this.connection.createStatement();
                statement.executeQuery("SELECT flags FROM " + this.prefix + "protections LIMIT 1");
                PreparedStatement pStatement = this.prepare("SELECT * FROM " + this.prefix + "protections WHERE flags = 8");
                for (Protection protection : this.resolveProtections(pStatement)) {
                    flag = new Flag(Flag.Type.EXEMPTION);
                    protection.addFlag(flag);
                    protection.save();
                }
                pStatement = this.prepare("SELECT * FROM " + this.prefix + "protections WHERE flags = 3");
                for (Protection protection : this.resolveProtections(pStatement)) {
                    flag = new Flag(Flag.Type.MAGNET);
                    protection.addFlag(flag);
                    protection.save();
                }
                pStatement = this.prepare("SELECT * FROM " + this.prefix + "protections WHERE flags = 2");
                for (Protection protection : this.resolveProtections(pStatement)) {
                    flag = new Flag(Flag.Type.REDSTONE);
                    protection.addFlag(flag);
                    protection.save();
                }
                this.dropColumn(this.prefix + "protections", "flags");
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    private void doUpdate400_6() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                ResultSet rs = statement.executeQuery("SELECT x FROM " + this.prefix + "history LIMIT 1");
                rs.close();
            }
            catch (SQLException e) {
                this.addColumn(this.prefix + "history", "x", "INTEGER");
                this.addColumn(this.prefix + "history", "y", "INTEGER");
                this.addColumn(this.prefix + "history", "z", "INTEGER");
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    private void doUpdate5_0_12() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                ResultSet rs;
                statement = this.connection.createStatement();
                try {
                    rs = statement.executeQuery("SELECT blockId FROM " + this.prefix + "protections LIMIT 1");
                    rs.close();
                }
                catch (SQLException e) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                rs = statement.executeQuery("SELECT id FROM " + this.prefix + "blocks LIMIT 1");
                rs.close();
            }
            catch (SQLException e) {
                LWC.getInstance().getPlugin().getLogger().info("Creating block mappings table");
                Table blockMappings = new Table(this, "blocks");
                Column column = new Column("id");
                column.setType("INTEGER");
                column.setPrimary(true);
                column.setAutoIncrement(false);
                blockMappings.add(column);
                column = new Column("name");
                column.setType("VARCHAR(40)");
                blockMappings.add(column);
                blockMappings.execute();
                statement.executeUpdate("UPDATE " + this.prefix + "protections SET blockId = -1 WHERE blockId IS NULL");
                ResultSet rs = statement.executeQuery("SELECT DISTINCT blockId FROM " + this.prefix + "protections");
                PreparedStatement insertSmt = this.prepare("INSERT INTO " + this.prefix + "blocks (`id`,`name`) VALUES (?, ?)");
                while (rs.next()) {
                    int id = rs.getInt("blockId");
                    if (id < 0 || id == 5000) continue;
                    Material mat = Material.matchMaterial((String)Integer.toString(id));
                    if (mat != null) {
                        insertSmt.setInt(1, id);
                        insertSmt.setString(2, mat.name());
                        insertSmt.executeUpdate();
                        continue;
                    }
                    this.mergeBlockMapping(id, -1);
                }
                rs.close();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    private boolean doUpdateModernLWC() {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                ResultSet rs = statement.executeQuery("SELECT DISTINCT blockName FROM " + this.prefix + "protections");
                LWC.getInstance().getPlugin().getLogger().info("Upgrading from ModernLWC");
                try {
                    PreparedStatement updateSmt = this.prepare("UPDATE " + this.prefix + "protections SET blockId = ? WHERE blockName = ?");
                    HashSet<String> typeMap = new HashSet<String>();
                    typeMap.add("Entity");
                    for (EntityType e : EntityType.values()) {
                        typeMap.add(e.name());
                    }
                    while (rs.next()) {
                        String blockName = rs.getString(1);
                        if (!typeMap.contains(blockName)) continue;
                        updateSmt.setInt(1, 5000);
                        updateSmt.setString(2, blockName);
                        updateSmt.executeUpdate();
                    }
                    rs.close();
                    statement.executeUpdate("ALTER TABLE " + this.prefix + "protections DROP COLUMN blockName");
                    statement.executeUpdate("UPDATE " + this.prefix + "protections SET blockId = -1 WHERE blockId IS NULL");
                }
                catch (SQLException e) {
                    this.printException(e);
                }
            }
            catch (SQLException e) {
                Boolean bl = false;
                return bl;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return true;
        });
    }

    private void doUpdatesDatabaseVersion7() {
        this.runAndIgnoreException(() -> {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "protections` CHANGE `owner` `owner` VARCHAR(36)");
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "protections` CHANGE `world` `world` VARCHAR(50)");
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "protections` CHANGE `date` `date` VARCHAR(50)");
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "history` CHANGE `owner` `owner` VARCHAR(36)");
            statement.close();
        });
        this.runAndIgnoreException(() -> this.dropColumn(this.prefix + "protections", "rights"));
    }

    private void doUpdatesDatabaseVersion8() {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = null;
            try {
                statement = this.connection.createStatement();
                statement.execute("SELECT entityid FROM " + this.prefix + "protections LIMIT 1");
            }
            catch (SQLException e) {
                this.addColumn(this.prefix + "protections", "entityid", this.currentType == Database.Type.SQLite ? "VARCHAR(36)" : "VARCHAR(36) AFTER `z`");
                this.createIndex("protections", "protections_entity", "entityid");
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    public HashMap<Integer, String> loadBlockMappings() {
        return this.runAndThrowModuleExceptionIfFailing(() -> {
            HashMap<Integer, String> rv = new HashMap<Integer, String>();
            Statement statement = this.connection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT `id`,`name` FROM " + this.prefix + "blocks");
            while (rs.next()) {
                rv.put(rs.getInt(1), rs.getString(2));
            }
            statement.close();
            return rv;
        });
    }

    public void addBlockMapping(int id, String name) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement insertSmt = this.prepare("INSERT INTO " + this.prefix + "blocks (`id`,`name`) VALUES (?, ?)");
            insertSmt.setInt(1, id);
            insertSmt.setString(2, name);
            insertSmt.executeUpdate();
        });
    }

    public void updateBlockMappingName(int id, String name) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement insertSmt = this.prepare("UPDATE " + this.prefix + "blocks SET name = ? WHERE id = ?");
            insertSmt.setString(1, name);
            insertSmt.setInt(2, id);
            insertSmt.executeUpdate();
        });
    }

    public void mergeBlockMapping(int oldid, int newid) {
        this.runAndThrowModuleExceptionIfFailing(() -> {
            PreparedStatement updateSmt = this.prepare("UPDATE " + this.prefix + "protections SET blockId = ? WHERE blockId = ?");
            updateSmt.setInt(1, newid);
            updateSmt.setInt(2, oldid);
            int updated = updateSmt.executeUpdate();
            LWC.getInstance().getPlugin().getLogger().info("Updated " + updated + " protections!");
            PreparedStatement insertSmt = this.prepare("DELETE FROM " + this.prefix + "blocks WHERE id = ?");
            insertSmt.setInt(1, oldid);
            insertSmt.executeUpdate();
        });
    }

    public List<Protection> streamDeleteProtections(String where, CommandSender sender) {
        int totalProtections = this.getProtectionCount();
        ArrayList resultList = this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement resultStatement = this.connection.createStatement(1003, 1007);
            if (this.getType() == Database.Type.MySQL) {
                resultStatement.setFetchSize(Integer.MIN_VALUE);
            }
            ResultSet result = resultStatement.executeQuery("SELECT id, owner, type, x, y, z, entityid, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections" + where);
            List<Integer> exemptedBlocks = LWC.getInstance().getConfiguration().getIntList("optional.exemptBlocks", new ArrayList<Integer>());
            int count = 0;
            ArrayList<Protection> toRemove = new ArrayList<Protection>();
            ArrayList<Integer> toRemoveIds = new ArrayList<Integer>();
            while (result.next()) {
                Protection protection = this.resolveProtection(result);
                World world = protection.getBukkitWorld();
                if (protection.hasFlag(Flag.Type.EXEMPTION) || exemptedBlocks.contains(protection.getBlockId())) continue;
                if (++count % 100000 == 0 || count == totalProtections || count == 1) {
                    sender.sendMessage("\u00a74" + count + " / " + totalProtections);
                }
                if (world == null) continue;
                toRemove.add(protection);
                toRemoveIds.add(protection.getId());
            }
            result.close();
            resultStatement.close();
            StringBuilder deleteProtectionsQuery = new StringBuilder();
            StringBuilder deleteHistoryQuery = new StringBuilder();
            int total = toRemove.size();
            count = 0;
            Iterator iter = toRemoveIds.iterator();
            Statement statement = this.connection.createStatement();
            while (iter.hasNext()) {
                int protectionId = (Integer)iter.next();
                if (count % 10000 == 0) {
                    deleteProtectionsQuery.append("DELETE FROM ").append(this.prefix).append("protections WHERE id IN (").append(protectionId);
                    deleteHistoryQuery.append("UPDATE ").append(this.prefix).append("history SET status = " + History.Status.INACTIVE.ordinal() + " WHERE protectionId IN(").append(protectionId);
                } else {
                    deleteProtectionsQuery.append(",").append(protectionId);
                    deleteHistoryQuery.append(",").append(protectionId);
                }
                if (count % 10000 == 9999 || count == total - 1) {
                    deleteProtectionsQuery.append(")");
                    deleteHistoryQuery.append(")");
                    statement.executeUpdate(deleteProtectionsQuery.toString());
                    statement.executeUpdate(deleteHistoryQuery.toString());
                    deleteProtectionsQuery.setLength(0);
                    deleteHistoryQuery.setLength(0);
                    sender.sendMessage("\u00a72REMOVED " + (count + 1) + " / " + total);
                }
                ++count;
            }
            statement.close();
            return toRemove;
        });
        this.protectionCount -= resultList.size();
        return resultList;
    }

    public void batchDeleteProtections(ArrayDeque<Integer> protectionsToRemove) {
        if (protectionsToRemove.isEmpty()) {
            return;
        }
        this.runAndThrowModuleExceptionIfFailing(() -> {
            Statement statement = this.connection.createStatement();
            StringBuilder builder = new StringBuilder();
            int count = 0;
            while (!protectionsToRemove.isEmpty()) {
                int protectionId = (Integer)protectionsToRemove.removeFirst();
                if (count == 0) {
                    builder.append("DELETE FROM ").append(this.prefix).append("protections WHERE id IN (").append(protectionId);
                } else {
                    builder.append(",").append(protectionId);
                }
                ++count;
            }
            builder.append(")");
            statement.executeUpdate(builder.toString());
            statement.close();
        });
    }
}

