/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.velocity.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import de.iani.cubesideutils.velocity.plugin.CubesideUtilsVelocity;
import de.iani.cubesideutils.velocity.plugin.PlayerDataImplVelocity;
import de.iani.cubesideutils.velocity.plugin.api.GlobalDataHelperVelocity;
import java.io.DataInputStream;
import java.io.IOException;

public class UtilsGlobalDataHelperVelocity
extends GlobalDataHelperVelocity<UtilsGlobalDataHelper.MessageType>
implements UtilsGlobalDataHelper {
    public UtilsGlobalDataHelperVelocity(CubesideUtilsVelocity plugin) {
        super(UtilsGlobalDataHelper.MessageType.class, "UtilsPlugin", plugin);
    }

    @Override
    protected void handleMessage(UtilsGlobalDataHelper.MessageType messageType, GlobalServer source, DataInputStream data) throws IOException {
        switch (messageType) {
            case RANK_INFORMATION_CHANGED: {
                CubesideUtilsVelocity.getInstance().updateRankInformation();
                break;
            }
            case GENERAL_DATA_CHANGED: {
                CubesideUtilsVelocity.getInstance().getGeneralDataCache().invalidate(data.readUTF());
                break;
            }
            case PLAYER_DATA_CHANGED: {
                CubesideUtilsVelocity.getInstance().getPlayerDataCache().invalidate(this.readUUID(data));
                break;
            }
            case CUSTOM_PLAYER_DATA_CHANGED: {
                PlayerDataImplVelocity pData = CubesideUtilsVelocity.getInstance().getPlayerDataCache().get(this.readUUID(data), false, false);
                if (pData == null) break;
                pData.customDataChanged();
                break;
            }
            case SEND_MESSAGE: {
                break;
            }
        }
    }
}

