/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import de.iani.cubesideutils.velocity.commands.CommandRouter;
import de.iani.cubesideutils.velocity.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.velocity.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.velocity.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.velocity.commands.exceptions.NoPermissionForPathException;
import de.iani.cubesideutils.velocity.commands.exceptions.RequiresPlayerException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public interface CommandExceptionHandler {
    public static final CommandExceptionHandler DEFAULT_HANDLER = new CommandExceptionHandler(){};

    default public boolean handleRequiresPlayer(RequiresPlayerException thrown) {
        CommandSource sender = thrown.getSender();
        sender.sendMessage((Component)Component.text(thrown.getMessage(), (TextColor)this.getErrorMessagePrefix()));
        return true;
    }

    default public boolean handleNoPermission(NoPermissionException thrown) {
        CommandSource sender = thrown.getSender();
        sender.sendMessage((Component)Component.text(thrown.getMessage(), (TextColor)this.getErrorMessagePrefix()));
        return true;
    }

    default public boolean handleNoPermissionForPath(NoPermissionForPathException thrown) {
        CommandSource sender = thrown.getSender();
        sender.sendMessage((Component)Component.text(thrown.getMessage(), (TextColor)this.getErrorMessagePrefix()));
        return true;
    }

    default public boolean handleIllegalSyntax(IllegalSyntaxException thrown) {
        CommandRouter router = thrown.getRouter();
        CommandSource sender = thrown.getSender();
        String alias = thrown.getAlias();
        String[] args = thrown.getArgs();
        router.showHelp(sender, alias, args);
        return true;
    }

    default public boolean handleInternalException(InternalCommandException thrown) {
        Throwable cause;
        if (thrown.getMessage() != null) {
            CommandSource sender = thrown.getSender();
            sender.sendMessage((Component)Component.text(thrown.getMessage(), (TextColor)this.getErrorMessagePrefix()));
        }
        if ((cause = thrown.getCause()) instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }

    default public NamedTextColor getErrorMessagePrefix() {
        return NamedTextColor.RED;
    }

    default public Component getHelpMessagePrefix() {
        return Component.empty();
    }
}

