/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.TagType;
import java.util.Arrays;

public class IntArrayTag
implements BaseTag<IntArrayTag> {
    public static final int[] EMPTY_ARRAY = new int[0];
    private int[] data = EMPTY_ARRAY;

    public IntArrayTag() {
    }

    public IntArrayTag(int[] data) {
        this.setData(data);
    }

    public int[] getData() {
        return this.data;
    }

    public void setData(int[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this.data = data;
    }

    @Override
    public TagType getType() {
        return TagType.INT_ARRAY;
    }

    public String toString() {
        return "[" + this.data.length + " ints]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof IntArrayTag)) return false;
        IntArrayTag other = (IntArrayTag)obj;
        if (!Arrays.equals(this.data, other.data)) return false;
        return true;
    }

    @Override
    public IntArrayTag clone() {
        try {
            IntArrayTag clone = (IntArrayTag)super.clone();
            clone.data = (int[])this.data.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone should be supported");
        }
    }
}

