/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.ChatUtil;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;

public class HtmlUtil {
    public static final String COLOR_BLACK_HEX = "#000000";

    public static String colorToHex(int rgb) {
        String color = Integer.toHexString(rgb & 0xFFFFFF);
        return COLOR_BLACK_HEX.substring(0, 7 - color.length()) + color;
    }

    public static String escapeHtml(String text) {
        StringBuilder sb = new StringBuilder();
        HtmlUtil.escapeHtml(sb, text);
        return sb.toString();
    }

    public static void escapeHtml(StringBuilder out, String text) {
        int len = text.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public static String toHTML(String message) {
        return HtmlUtil.toHTML(TextComponent.fromLegacyText((String)message));
    }

    public static String toHTML(BaseComponent ... message) {
        StringBuilder stringBuilder = new StringBuilder();
        HtmlUtil.toHTML(stringBuilder, false, false, Arrays.asList(message));
        return stringBuilder.toString();
    }

    private static void toHTML(StringBuilder stringBuilder, boolean parentStrikethrough, boolean parentUnderlined, List<BaseComponent> message) {
        for (BaseComponent component : message) {
            if (component instanceof TextComponent) {
                boolean anyFormat;
                ChatColor color = component.getColorRaw();
                Integer colorRGB = color == null ? null : ChatUtil.toRGB(color);
                Boolean bold = component.isBoldRaw();
                Boolean italic = component.isItalicRaw();
                Boolean strikethrough = component.isStrikethroughRaw();
                Boolean underlined = component.isUnderlinedRaw();
                boolean bl = anyFormat = colorRGB != null || bold != null || italic != null || strikethrough != null || underlined != null;
                if (anyFormat) {
                    stringBuilder.append("<span style='");
                    if (colorRGB != null) {
                        stringBuilder.append("color:").append(HtmlUtil.colorToHex(colorRGB)).append(";");
                    }
                    if (bold != null) {
                        stringBuilder.append("font-weight:").append(bold != false ? "bold" : "normal").append(";");
                    }
                    if (italic != null) {
                        stringBuilder.append("font-style:").append(italic != false ? "italic" : "normal").append(";");
                    }
                    if (strikethrough != null || underlined != null) {
                        if (strikethrough == null) {
                            strikethrough = parentStrikethrough;
                        }
                        if (underlined == null) {
                            underlined = parentUnderlined;
                        }
                        stringBuilder.append("text-decoration:");
                        if (strikethrough.booleanValue()) {
                            stringBuilder.append("line-through");
                        }
                        if (underlined.booleanValue()) {
                            if (strikethrough.booleanValue()) {
                                stringBuilder.append(" ");
                            }
                            stringBuilder.append("underline");
                        } else if (!strikethrough.booleanValue()) {
                            stringBuilder.append("none");
                        }
                        stringBuilder.append(";");
                    }
                    stringBuilder.append("'>");
                }
                HtmlUtil.escapeHtml(stringBuilder, ((TextComponent)component).getText());
                if (component.getExtra() != null && !component.getExtra().isEmpty()) {
                    HtmlUtil.toHTML(stringBuilder, strikethrough != null ? strikethrough : parentStrikethrough, underlined != null ? underlined : parentUnderlined, component.getExtra());
                }
                if (!anyFormat) continue;
                stringBuilder.append("</span>");
                continue;
            }
            HtmlUtil.toHTML(stringBuilder, parentStrikethrough, parentUnderlined, Arrays.asList(TextComponent.fromLegacyText((String)component.toLegacyText())));
        }
    }
}

