/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.TagType;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;

public class ListTag<T extends BaseTag<T>>
extends ArrayList<T>
implements BaseTag<ListTag<T>> {
    private static final long serialVersionUID = 2161704096949298689L;
    private TagType elementType = TagType.BYTE;

    public TagType getElementType() {
        return this.elementType;
    }

    public void setElementType(TagType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType");
        }
        if (!this.isEmpty() && elementType != this.elementType) {
            throw new IllegalStateException("list must be empty to change the element type");
        }
        this.elementType = elementType;
    }

    @Override
    public boolean add(T element) {
        if (this.isEmpty()) {
            this.elementType = element.getType();
        } else if (this.elementType != element.getType()) {
            throw new IllegalArgumentException("invalid type added. expected: " + String.valueOf((Object)this.elementType) + " got: " + String.valueOf((Object)element.getType()));
        }
        return super.add(element);
    }

    @Override
    public void add(int index, T element) {
        if (this.isEmpty()) {
            this.elementType = element.getType();
        } else if (this.elementType != element.getType()) {
            throw new IllegalArgumentException("invalid type added. expected: " + String.valueOf((Object)this.elementType) + " got: " + String.valueOf((Object)element.getType()));
        }
        super.add(index, element);
    }

    @Override
    public T set(int index, T element) {
        if (this.size() == 1) {
            this.elementType = element.getType();
        } else if (this.elementType != element.getType()) {
            throw new IllegalArgumentException("invalid type added. expected: " + String.valueOf((Object)this.elementType) + " got: " + String.valueOf((Object)element.getType()));
        }
        return (T)((BaseTag)super.set(index, element));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (!c.isEmpty()) {
            TagType requiredType = this.isEmpty() ? null : this.elementType;
            for (BaseTag element : c) {
                if (requiredType == null) {
                    requiredType = element.getType();
                    continue;
                }
                if (requiredType == element.getType()) continue;
                throw new IllegalArgumentException("invalid type added. expected: " + String.valueOf((Object)requiredType) + " got: " + String.valueOf((Object)element.getType()));
            }
            this.elementType = requiredType;
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (!c.isEmpty()) {
            TagType requiredType = this.isEmpty() ? null : this.elementType;
            for (BaseTag element : c) {
                if (requiredType == null) {
                    requiredType = element.getType();
                    continue;
                }
                if (requiredType == element.getType()) continue;
                throw new IllegalArgumentException("invalid type added. expected: " + String.valueOf((Object)requiredType) + " got: " + String.valueOf((Object)element.getType()));
            }
            this.elementType = requiredType;
        }
        return super.addAll(index, c);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException("this implementations does not allow replaceAll");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("this implementations does not allow subList");
    }

    @Override
    public TagType getType() {
        return TagType.LIST;
    }

    @Override
    public String toString() {
        return this.size() + " entries of type " + String.valueOf((Object)this.elementType);
    }

    @Override
    public void print(String name, String prefix, PrintStream out) {
        BaseTag.super.print(name, (String)prefix, out);
        out.println((String)prefix + "{");
        String orgPrefix = prefix;
        prefix = (String)prefix + "   ";
        for (int i = 0; i < this.size(); ++i) {
            ((BaseTag)this.get(i)).print(null, (String)prefix, out);
        }
        out.println(orgPrefix + "}");
    }

    @Override
    public ListTag<T> clone() {
        ListTag clone = (ListTag)super.clone();
        ListIterator it = clone.listIterator();
        while (it.hasNext()) {
            it.set(((BaseTag)it.next()).clone());
        }
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ListTag && super.equals(obj);
    }
}

