/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import de.iani.cubesideutils.bukkit.items.Enchantments;
import de.iani.cubesideutils.bukkit.items.ItemGroups;
import de.iani.cubesideutils.bukkit.items.ItemStackAndAmount;
import de.iani.cubesideutils.bukkit.items.ItemStackPrepareForSerializationEvent;
import de.iani.cubesideutils.bukkit.items.ItemStackRestoreAfterDeserializationEvent;
import io.papermc.paper.datacomponent.DataComponentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ItemStacks {
    private static final NamespacedKey attackSpeedKey = NamespacedKey.fromString((String)"cubesideutils:attackspeed");
    private static final NamespacedKey attackDamageKey = NamespacedKey.fromString((String)"cubesideutils:attackdamage");

    private ItemStacks() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static ItemStack unbreakable(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setUnbreakable(true);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack hideProperties(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_UNBREAKABLE});
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack enchant(ItemStack itemStack, Enchantment enchantment, int level) {
        ItemMeta meta = itemStack.getItemMeta();
        Enchantments.addEnchant(meta, enchantment, level, true);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack lore(ItemStack itemStack, String ... lore) {
        ItemMeta meta = itemStack.getItemMeta();
        if (lore == null || lore.length == 0) {
            meta.lore(null);
        } else {
            meta.lore(List.of(lore).stream().map(s -> LegacyComponentSerializer.legacySection().deserialize(s)).toList());
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack lore(ItemStack itemStack, Component ... lore) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.lore(lore == null || lore.length == 0 ? null : List.of(lore));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack rename(ItemStack itemStack, String name) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.displayName((Component)LegacyComponentSerializer.legacySection().deserialize(name));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack rename(ItemStack itemStack, Component name) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.displayName(name);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack amount(ItemStack itemStack, int amount) {
        itemStack.setAmount(amount);
        return itemStack;
    }

    public static ItemStack colorize(ItemStack itemStack, Color color) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)meta).setColor(color);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack potion(ItemStack itemStack, PotionType potion) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setBasePotionType(potion);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack fastPvP(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        Material type = itemStack.getType();
        double addDamage = Double.NaN;
        if (type == Material.WOODEN_SWORD) {
            addDamage = 3.0;
        } else if (type == Material.GOLDEN_SWORD) {
            addDamage = 3.0;
        } else if (type == Material.STONE_SWORD) {
            addDamage = 4.0;
        } else if (type == Material.IRON_SWORD) {
            addDamage = 5.0;
        } else if (type == Material.DIAMOND_SWORD) {
            addDamage = 6.0;
        } else if (type == Material.NETHERITE_SWORD) {
            addDamage = 7.0;
        }
        if (!Double.isNaN(addDamage)) {
            meta.removeAttributeModifier(Attribute.ATTACK_SPEED);
            meta.addAttributeModifier(Attribute.ATTACK_SPEED, new AttributeModifier(attackSpeedKey, 1.5, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.MAINHAND));
            meta.removeAttributeModifier(Attribute.ATTACK_DAMAGE);
            meta.addAttributeModifier(Attribute.ATTACK_DAMAGE, new AttributeModifier(attackDamageKey, addDamage, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.MAINHAND));
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack[] deepCopy(ItemStack[] of) {
        ItemStack[] result = new ItemStack[of.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = of[i] == null ? null : of[i].clone();
        }
        return result;
    }

    public static boolean removeFromInventoryIfContainsAll(Inventory inventory, ItemStackAndAmount ... items) {
        ItemStack[] contents = ItemStacks.deepCopy(inventory.getStorageContents());
        for (ItemStackAndAmount item : items) {
            if (item == null || item.stack() == null || ItemGroups.isAir(item.stack().getType())) continue;
            int remaining = item.amount();
            int firstSimilar = -1;
            while (remaining > 0) {
                firstSimilar = ItemStacks.getFirstSimilar(item.stack(), contents, firstSimilar + 1);
                if (firstSimilar < 0) {
                    return false;
                }
                ItemStack content = contents[firstSimilar];
                int here = content.getAmount();
                if (here > remaining) {
                    content.setAmount(here - remaining);
                    remaining = 0;
                    continue;
                }
                contents[firstSimilar] = null;
                remaining -= here;
            }
        }
        inventory.setStorageContents(contents);
        return true;
    }

    public static boolean addToInventoryIfFits(Inventory inventory, ItemStackAndAmount ... items) {
        ItemStack[] contents = ItemStacks.deepCopy(inventory.getStorageContents());
        for (ItemStackAndAmount item : items) {
            int remaining;
            int add;
            if (item == null || item.stack() == null || ItemGroups.isAir(item.stack().getType())) continue;
            int firstPartial = -1;
            for (remaining = item.amount(); remaining > 0 && (firstPartial = ItemStacks.getFirstPartial(item.stack(), contents, firstPartial + 1)) >= 0; remaining -= add) {
                ItemStack content = contents[firstPartial];
                add = Math.min(content.getMaxStackSize() - content.getAmount(), remaining);
                content.setAmount(content.getAmount() + add);
            }
            int firstFree = -1;
            while (remaining > 0) {
                ItemStack content;
                if ((firstFree = ItemStacks.getFirstFree(contents, firstFree + 1)) < 0) {
                    return false;
                }
                contents[firstFree] = content = new ItemStack(item.stack());
                int add2 = Math.min(Math.max(content.getMaxStackSize(), 1), remaining);
                content.setAmount(add2);
                remaining -= add2;
            }
        }
        inventory.setStorageContents(contents);
        return true;
    }

    public static boolean addToInventoryIfFits(Inventory inventory, ItemStack ... items) {
        ItemStack[] contents = ItemStacks.deepCopy(inventory.getStorageContents());
        for (ItemStack item : items) {
            int remaining;
            int add;
            if (item == null || ItemGroups.isAir(item.getType())) continue;
            int firstPartial = -1;
            for (remaining = item.getAmount(); remaining > 0 && (firstPartial = ItemStacks.getFirstPartial(item, contents, firstPartial + 1)) >= 0; remaining -= add) {
                ItemStack content = contents[firstPartial];
                add = Math.min(content.getMaxStackSize() - content.getAmount(), remaining);
                content.setAmount(content.getAmount() + add);
            }
            int firstFree = -1;
            while (remaining > 0) {
                ItemStack content;
                if ((firstFree = ItemStacks.getFirstFree(contents, firstFree + 1)) < 0) {
                    return false;
                }
                contents[firstFree] = content = new ItemStack(item);
                int add2 = Math.min(Math.max(content.getMaxStackSize(), 1), remaining);
                content.setAmount(add2);
                remaining -= add2;
            }
        }
        inventory.setStorageContents(contents);
        return true;
    }

    private static int getFirstSimilar(ItemStack item, ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content == null || !content.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstPartial(ItemStack item, ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content == null || !content.isSimilar(item) || content.getAmount() >= content.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstFree(ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content != null && content.getAmount() != 0 && !ItemGroups.isAir(content.getType())) continue;
            return i;
        }
        return -1;
    }

    public static Map<ItemStack, Integer> countItems(ItemStack[] items) {
        LinkedHashMap<ItemStack, Integer> counts = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            if (item == null || item.getAmount() == 0 || item.getType() == Material.AIR) continue;
            ItemStack key = item.clone();
            key.setAmount(1);
            counts.merge(key, item.getAmount(), (old, add) -> old + add);
        }
        return counts;
    }

    public static int countStacks(Map<ItemStack, Integer> itemCounts) {
        return itemCounts.entrySet().stream().mapToInt(entry -> (int)Math.ceil((double)((Integer)entry.getValue()).intValue() / (double)((ItemStack)entry.getKey()).getMaxStackSize())).sum();
    }

    public static ItemStack[] fromAmounts(Map<ItemStack, Integer> amounts) {
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> entry : amounts.entrySet()) {
            ItemStack item = entry.getKey();
            for (int count = entry.getValue().intValue(); count > 0; count -= Math.min(count, Math.max(1, item.getMaxStackSize()))) {
                item = item.clone();
                item.setAmount(Math.min(count, Math.max(1, item.getMaxStackSize())));
                resultList.add(item);
            }
        }
        return resultList.toArray(new ItemStack[resultList.size()]);
    }

    public static ItemStack[] shrink(ItemStack[] items) {
        return ItemStacks.fromAmounts(ItemStacks.countItems(items));
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0;
    }

    public static boolean isEmpty(ItemStack[] items) {
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0 || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public static boolean isSimilar(ItemStack i1, ItemStack i2) {
        if (i1 == null) {
            return i2 == null;
        }
        return i1.isSimilar(i2);
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes) {
        return ItemStacks.doesHave(player, items, removeIfYes, true);
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes, boolean includeNonStorage) {
        return ItemStacks.doesHave(player, items, removeIfYes, includeNonStorage, null);
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes, boolean includeNonStorage, DataComponentType[] ignoredComponents) {
        items = ItemStacks.deepCopy(items);
        ItemStack[] oldContents = includeNonStorage ? player.getInventory().getContents() : player.getInventory().getStorageContents();
        ItemStack[] contents = ItemStacks.deepCopy(oldContents);
        ItemStack[] filteredItems = null;
        ItemStack[] filteredContents = null;
        boolean anyRealFilteredComponents = false;
        if (ignoredComponents != null && ignoredComponents.length > 0) {
            boolean cloned;
            ItemStack stack;
            int j;
            filteredItems = new ItemStack[items.length];
            for (j = 0; j < items.length; ++j) {
                stack = items[j];
                if (stack == null) continue;
                cloned = false;
                for (DataComponentType ignored : ignoredComponents) {
                    if (!stack.isDataOverridden(ignored)) continue;
                    if (!cloned) {
                        stack = stack.clone();
                        cloned = true;
                    }
                    stack.resetData(ignored);
                    anyRealFilteredComponents = true;
                }
                filteredItems[j] = stack;
            }
            filteredContents = new ItemStack[contents.length];
            for (j = 0; j < contents.length; ++j) {
                stack = contents[j];
                if (stack == null) continue;
                cloned = false;
                for (DataComponentType ignored : ignoredComponents) {
                    if (!stack.isDataOverridden(ignored)) continue;
                    if (!cloned) {
                        stack = stack.clone();
                        cloned = true;
                    }
                    stack.resetData(ignored);
                    anyRealFilteredComponents = true;
                }
                filteredContents[j] = stack;
            }
        }
        boolean has = true;
        block4: for (int j = 0; j < items.length; ++j) {
            ItemStack toStack = items[j];
            ItemStack toStackCheck = anyRealFilteredComponents ? filteredItems[j] : toStack;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack hisStackCheck;
                ItemStack hisStack = contents[i];
                ItemStack itemStack = hisStackCheck = anyRealFilteredComponents ? filteredContents[i] : hisStack;
                if (hisStack == null || hisStack.getAmount() <= 0 || !ItemStacks.isSimilar(hisStackCheck, toStackCheck)) continue;
                if (toStack.getAmount() > hisStack.getAmount()) {
                    toStack.setAmount(toStack.getAmount() - hisStack.getAmount());
                    contents[i] = null;
                    if (!anyRealFilteredComponents) continue;
                    toStackCheck.setAmount(toStack.getAmount());
                    filteredContents[i] = null;
                    continue;
                }
                if (toStack.getAmount() < hisStack.getAmount()) {
                    hisStack.setAmount(hisStack.getAmount() - toStack.getAmount());
                    toStack.setAmount(0);
                    if (!anyRealFilteredComponents) continue block4;
                    hisStackCheck.setAmount(hisStack.getAmount());
                    toStackCheck.setAmount(0);
                    continue block4;
                }
                contents[i] = null;
                toStack.setAmount(0);
                if (!anyRealFilteredComponents) continue block4;
                filteredContents[i] = null;
                toStackCheck.setAmount(0);
                continue block4;
            }
            has = false;
        }
        if (!has) {
            ItemStack[] missing = ItemStacks.shrink(items);
            if (missing.length == 0) {
                throw new AssertionError();
            }
            return missing;
        }
        if (removeIfYes) {
            if (includeNonStorage) {
                player.getInventory().setContents(contents);
            } else {
                player.getInventory().setStorageContents(contents);
            }
            player.updateInventory();
        }
        return new ItemStack[0];
    }

    public static boolean equals(ItemStack[] i1, ItemStack[] i2) {
        return ItemStacks.countItems(i1).equals(ItemStacks.countItems(i2));
    }

    public static ItemStack prepareForSerialization(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStackPrepareForSerializationEvent event = new ItemStackPrepareForSerializationEvent(stack);
        event.callEvent();
        stack = event.getStack();
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof BlockStateMeta) {
            BlockState blockState;
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            if (blockStateMeta.hasBlockState() && (blockState = blockStateMeta.getBlockState()) != null && blockState instanceof Container) {
                Container container = (Container)blockState;
                Inventory inv = container.getSnapshotInventory();
                ItemStack[] contents = inv.getContents();
                boolean modified = false;
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack newContent;
                    ItemStack oldContent = contents[i];
                    if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.prepareForSerialization(oldContent))) continue;
                    contents[i] = newContent;
                    modified = true;
                }
                if (modified) {
                    inv.setContents(contents);
                    blockStateMeta.setBlockState(blockState);
                    stack = stack.clone();
                    stack.setItemMeta((ItemMeta)blockStateMeta);
                }
            }
        } else if (meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            ItemStack[] contents = (ItemStack[])bundleMeta.getItems().toArray(ItemStack[]::new);
            boolean modified = false;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack newContent;
                ItemStack oldContent = contents[i];
                if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.prepareForSerialization(oldContent))) continue;
                contents[i] = newContent;
                modified = true;
            }
            if (modified) {
                bundleMeta.setItems(Arrays.asList(contents));
                stack = stack.clone();
                stack.setItemMeta((ItemMeta)bundleMeta);
            }
        }
        return stack;
    }

    public static ItemStack restoreAfterDeserialization(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStackRestoreAfterDeserializationEvent event = new ItemStackRestoreAfterDeserializationEvent(stack);
        event.callEvent();
        stack = event.getStack();
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof BlockStateMeta) {
            BlockState blockState;
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            if (blockStateMeta.hasBlockState() && (blockState = blockStateMeta.getBlockState()) != null && blockState instanceof Container) {
                Container container = (Container)blockState;
                Inventory inv = container.getSnapshotInventory();
                ItemStack[] contents = inv.getContents();
                boolean modified = false;
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack newContent;
                    ItemStack oldContent = contents[i];
                    if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.restoreAfterDeserialization(oldContent))) continue;
                    contents[i] = newContent;
                    modified = true;
                }
                if (modified) {
                    inv.setContents(contents);
                    blockStateMeta.setBlockState(blockState);
                    stack = stack.clone();
                    stack.setItemMeta((ItemMeta)blockStateMeta);
                }
            }
        } else if (meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            ItemStack[] contents = (ItemStack[])bundleMeta.getItems().toArray(ItemStack[]::new);
            boolean modified = false;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack newContent;
                ItemStack oldContent = contents[i];
                if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.restoreAfterDeserialization(oldContent))) continue;
                contents[i] = newContent;
                modified = true;
            }
            if (modified) {
                bundleMeta.setItems(Arrays.asList(contents));
                stack = stack.clone();
                stack.setItemMeta((ItemMeta)bundleMeta);
            }
        }
        return stack;
    }

    public static String getBase64StringFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(stack.serializeAsBytes());
    }

    public static ItemStack getItemStackFromBase64(String itemString) {
        if (itemString == null) {
            return null;
        }
        return ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(itemString));
    }
}

