/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.iani.cubesideutils.RandomUtil;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.Registry;

public class RegistryUtil {
    private static final HashMap<Registry<?>, List<? extends Keyed>> REGISTRY_ENTRIES = new HashMap();

    private RegistryUtil() {
        throw new RuntimeException("No instances allowed");
    }

    public static <T extends Keyed> List<T> getRegistryValues(RegistryKey<T> registryKey) {
        return RegistryUtil.getRegistryValues(RegistryAccess.registryAccess().getRegistry(registryKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Keyed> List<T> getRegistryValues(Registry<T> registry) {
        List<? extends Keyed> values = REGISTRY_ENTRIES.get(registry);
        if (values == null) {
            HashMap<Registry<?>, List<? extends Keyed>> hashMap = REGISTRY_ENTRIES;
            synchronized (hashMap) {
                ArrayList<? extends Keyed> valuesFinal = new ArrayList<Keyed>();
                values = valuesFinal;
                registry.forEach(t -> valuesFinal.add((Keyed)t));
                REGISTRY_ENTRIES.put(registry, Collections.unmodifiableList(values));
            }
        }
        return values;
    }

    public static <T extends Keyed> T getRandomRegistryEntry(RegistryKey<T> registryKey) {
        return RegistryUtil.getRandomRegistryEntry(RegistryAccess.registryAccess().getRegistry(registryKey));
    }

    public static <T extends Keyed> T getRandomRegistryEntry(Registry<T> registry) {
        List<T> valuesList = RegistryUtil.getRegistryValues(registry);
        return (T)(valuesList.isEmpty() ? null : (Keyed)RandomUtil.randomElement(valuesList));
    }

    public static <T extends Keyed> T getNextRegistryEntry(RegistryKey<T> registryKey, T previous) {
        return RegistryUtil.getNextRegistryEntry(RegistryAccess.registryAccess().getRegistry(registryKey), previous);
    }

    public static <T extends Keyed> T getNextRegistryEntry(Registry<T> registry, T previous) {
        List<T> valuesList = RegistryUtil.getRegistryValues(registry);
        int size = valuesList.size();
        for (int i = 0; i < size; ++i) {
            if (!((Keyed)valuesList.get(i)).equals(previous)) continue;
            return (T)((Keyed)valuesList.get((i + 1) % size));
        }
        return (T)((Keyed)valuesList.get(0));
    }
}

