/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;

public class StringUtilCore {
    public static final ToIntFunction<String> CASE_IGNORING_HASHER = s -> {
        if (s == null) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            hash = 31 * hash + Character.toLowerCase((int)c);
        }
        return hash;
    };
    public static final BiPredicate<String, String> CASE_IGNORING_EQUALITY = (s1, s2) -> s1 == null ? s2 == null : s1.equalsIgnoreCase((String)s2);

    public static String filterIncompleteSurrogatePairs(String input) {
        StringBuilder sb = null;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c < '\ud800' || c > '\udfff') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < input.length()) {
                char next = input.charAt(i + 1);
                if (next >= '\udc00' && next <= '\udfff') {
                    ++i;
                    if (Character.isDefined(Character.toCodePoint(c, next))) {
                        if (sb == null) continue;
                        sb.append(c);
                        sb.append(next);
                        continue;
                    }
                    if (sb != null) continue;
                    sb = new StringBuilder();
                    sb.append(input, 0, i - 1);
                    continue;
                }
                if (sb != null) continue;
                sb = new StringBuilder();
                sb.append(input, 0, i);
                continue;
            }
            if (sb != null) continue;
            sb = new StringBuilder();
            sb.append(input, 0, i);
        }
        return sb != null ? sb.toString() : input;
    }

    public static String filterControlCharacters(String input, boolean allowNewline) {
        StringBuilder sb = null;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c < ' ' && (!allowNewline || c != '\n') || c >= '\u007f' && c < '\u00a0') {
                if (sb != null) continue;
                sb = new StringBuilder();
                sb.append(input, 0, i);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : input;
    }

    public static int findMatchingBrace(String s) {
        int open = 1;
        block4: for (int i = 1; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '{': {
                    ++open;
                    continue block4;
                }
                case '}': {
                    if (--open != 0) continue block4;
                    return i;
                }
            }
        }
        return -1;
    }
}

