/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.ComponentUtilAdventure;
import de.iani.cubesideutils.NamedChatColor;
import de.iani.cubesideutils.StringUtilCore;
import de.iani.cubesideutils.linkextractor.LinkExtractor;
import de.iani.cubesideutils.linkextractor.LinkSegment;
import de.iani.cubesideutils.linkextractor.PlainSegment;
import de.iani.cubesideutils.linkextractor.Segment;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class CubesideComponentSerializer
implements ComponentSerializer<Component, TextComponent, String> {
    private static final ComponentFlattener FLATTENER = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).mapper(TextComponent.class, c -> c.clickEvent() != null && c.clickEvent().action() == ClickEvent.Action.OPEN_URL ? c.content() : c.content().replace("&", "&&")).build();
    private static final LegacyComponentSerializer SERIALIZER = LegacyComponentSerializer.builder().character('&').hexColors().hexCharacter('x').flattener(FLATTENER).build();
    private static final LegacyComponentSerializer SERIALIZER_NO_COLOR = LegacyComponentSerializer.builder().character('&').hexColors().hexCharacter('x').build();
    private static final CubesideComponentSerializer COLORS_AND_LINKS = new CubesideComponentSerializer(true, true);
    private static final CubesideComponentSerializer COLORS_AND_NO_LINKS = new CubesideComponentSerializer(true, false);
    private static final CubesideComponentSerializer NO_COLORS_AND_LINKS = new CubesideComponentSerializer(false, true);
    private static final CubesideComponentSerializer NO_COLORS_AND_NO_LINKS = new CubesideComponentSerializer(false, false);
    private final boolean allowColors;
    private final boolean convertLinks;

    private CubesideComponentSerializer(boolean allowColors, boolean convertLinks) {
        this.allowColors = allowColors;
        this.convertLinks = convertLinks;
    }

    public static CubesideComponentSerializer instance(boolean allowColors, boolean convertLinks) {
        if (allowColors) {
            return convertLinks ? COLORS_AND_LINKS : COLORS_AND_NO_LINKS;
        }
        return convertLinks ? NO_COLORS_AND_LINKS : NO_COLORS_AND_NO_LINKS;
    }

    @NotNull
    public TextComponent deserialize(@NotNull String input) {
        List<PlainSegment> segments = this.convertLinks ? LinkExtractor.extractLinks((String)input) : List.of(new PlainSegment(input));
        ArrayList<ComponentBuilder> parts = new ArrayList<ComponentBuilder>();
        ComponentBuilder currentPart = null;
        Style currentStyle = Style.empty();
        StringBuilder builder = new StringBuilder();
        for (Segment segment : segments) {
            if (segment instanceof PlainSegment) {
                PlainSegment plain = (PlainSegment)segment;
                String text = plain.value();
                if (!this.allowColors) {
                    if (currentPart == null) {
                        currentPart = new ComponentBuilder(text);
                        parts.add(currentPart);
                        continue;
                    }
                    currentPart.children().add(new ComponentBuilder(text));
                    continue;
                }
                builder.setLength(0);
                int len = text.length();
                for (int i = 0; i < len; ++i) {
                    char next;
                    char current = text.charAt(i);
                    if (current == '&' && i + 1 < len && (NamedChatColor.getByCode((char)(next = Character.toLowerCase(text.charAt(i + 1)))) != null || next == '&' || next == 'x' || next == '#')) {
                        ++i;
                        if (next != '&') {
                            if (next == 'x' || next == '#') {
                                Integer hex = StringUtilCore.parseHexColor((String)text, (int)(i + 1));
                                if (hex == null) {
                                    builder.append(current).append(next);
                                    continue;
                                }
                                if (!builder.isEmpty()) {
                                    if (currentPart == null) {
                                        currentPart = new ComponentBuilder(builder.toString(), currentStyle);
                                        parts.add(currentPart);
                                    } else {
                                        currentPart.children().add(new ComponentBuilder(builder.toString(), currentStyle));
                                    }
                                    builder.setLength(0);
                                }
                                currentPart = null;
                                currentStyle = Style.style((TextColor)TextColor.color((int)hex));
                                i += 6;
                                continue;
                            }
                            if (next == 'r' || next >= '0' && next <= '9' || next >= 'a' && next <= 'f') {
                                if (!builder.isEmpty()) {
                                    if (currentPart == null) {
                                        currentPart = new ComponentBuilder(builder.toString(), currentStyle);
                                        parts.add(currentPart);
                                    } else {
                                        currentPart.children().add(new ComponentBuilder(builder.toString(), currentStyle));
                                    }
                                    builder.setLength(0);
                                }
                                currentPart = null;
                                if (next == 'r') {
                                    currentStyle = Style.empty();
                                    continue;
                                }
                                currentStyle = Style.style((TextColor)((TextColor)ComponentUtilAdventure.COLOR_CHARS.get(Character.valueOf(next))));
                                continue;
                            }
                            TextDecoration deco = ComponentUtilAdventure.DECORATION_CHARS.get(Character.valueOf(next));
                            if (deco == null) {
                                builder.append(current).append(next);
                                continue;
                            }
                            if (!builder.isEmpty()) {
                                ComponentBuilder newPart = new ComponentBuilder(builder.toString(), currentStyle);
                                if (currentPart == null) {
                                    currentPart = newPart;
                                    parts.add(currentPart);
                                } else {
                                    currentPart.children().add(newPart);
                                    currentPart = newPart;
                                }
                                builder.setLength(0);
                                currentStyle = Style.style((TextDecoration)deco);
                                continue;
                            }
                            currentStyle = currentStyle.decorate(deco);
                            continue;
                        }
                    }
                    builder.append(current);
                }
                if (builder.isEmpty() && currentStyle.isEmpty()) continue;
                ComponentBuilder newPart = new ComponentBuilder(builder.toString(), currentStyle);
                if (currentPart == null) {
                    currentPart = newPart;
                    parts.add(currentPart);
                } else {
                    currentPart.children().add(newPart);
                    currentPart = newPart;
                }
                builder.setLength(0);
                currentStyle = Style.empty();
                continue;
            }
            if (!(segment instanceof LinkSegment)) continue;
            LinkSegment link = (LinkSegment)segment;
            Object linkUrl = link.value();
            if (!((String)linkUrl).regionMatches(true, 0, "https://", 0, 8) && !((String)linkUrl).regionMatches(true, 0, "http://", 0, 7)) {
                linkUrl = "https://" + (String)linkUrl;
            }
            if (currentPart == null) {
                currentPart = new ComponentBuilder("");
                parts.add(currentPart);
            }
            currentPart.children().add((ComponentLike)Component.text((String)link.value()).clickEvent(ClickEvent.openUrl((String)linkUrl)));
        }
        if (parts.isEmpty()) {
            return Component.empty();
        }
        if (parts.size() == 1) {
            return ((ComponentBuilder)parts.get(0)).asComponent();
        }
        if (((ComponentBuilder)parts.get((int)0)).style.isEmpty()) {
            ComponentBuilder top = (ComponentBuilder)parts.remove(0);
            top.children().addAll(parts);
            return top.asComponent();
        }
        return (TextComponent)Component.empty().children(parts);
    }

    @NotNull
    public String serialize(@NotNull Component component) {
        return this.allowColors ? SERIALIZER.serialize(component) : SERIALIZER_NO_COLOR.serialize(component);
    }

    record ComponentBuilder(String value, ArrayList<ComponentLike> children, Style style) implements ComponentLike
    {
        public ComponentBuilder(String value) {
            this(value, Style.empty());
        }

        public ComponentBuilder(String value, Style style) {
            this(value, new ArrayList<ComponentLike>(), style);
        }

        @NotNull
        public TextComponent asComponent() {
            return (TextComponent)((TextComponent)Component.text((String)this.value).style(this.style)).children(this.children);
        }
    }
}

