/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.ComponentUtilAdventure;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class HtmlUtil {
    public static final String COLOR_BLACK_HEX = "#000000";

    public static String colorToHex(int rgb) {
        String color = Integer.toHexString(rgb & 0xFFFFFF);
        return COLOR_BLACK_HEX.substring(0, 7 - color.length()) + color;
    }

    public static String escapeHtml(String text) {
        StringBuilder sb = new StringBuilder();
        HtmlUtil.escapeHtml(sb, text);
        return sb.toString();
    }

    public static void escapeHtml(StringBuilder out, String text) {
        int len = text.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public static String toHTML(String message) {
        return HtmlUtil.toHTML((Component)ComponentUtilAdventure.fromLegacy(message));
    }

    public static String toHTML(Component message) {
        StringBuilder stringBuilder = new StringBuilder();
        HtmlUtil.toHTML(stringBuilder, false, false, message);
        return stringBuilder.toString();
    }

    private static Boolean stateToBoolean(TextDecoration.State state) {
        return state == null || state == TextDecoration.State.NOT_SET ? null : Boolean.valueOf(state == TextDecoration.State.TRUE);
    }

    private static void toHTML(StringBuilder stringBuilder, boolean parentStrikethrough, boolean parentUnderlined, Component message) {
        boolean anyFormat;
        TextComponent textComponent;
        TextComponent component = null;
        component = message instanceof TextComponent ? (textComponent = (TextComponent)message) : ComponentUtilAdventure.fromLegacy(ComponentUtilAdventure.toLegacy(message));
        TextColor color = message.color();
        String colorRgbHex = color == null ? null : color.asHexString();
        Boolean bold = HtmlUtil.stateToBoolean(component.decoration(TextDecoration.BOLD));
        Boolean italic = HtmlUtil.stateToBoolean(component.decoration(TextDecoration.ITALIC));
        Boolean strikethrough = HtmlUtil.stateToBoolean(component.decoration(TextDecoration.STRIKETHROUGH));
        Boolean underlined = HtmlUtil.stateToBoolean(component.decoration(TextDecoration.UNDERLINED));
        boolean bl = anyFormat = colorRgbHex != null || bold != null || italic != null || strikethrough != null || underlined != null;
        if (anyFormat) {
            stringBuilder.append("<span style='");
            if (colorRgbHex != null) {
                stringBuilder.append("color:").append(colorRgbHex).append(";");
            }
            if (bold != null) {
                stringBuilder.append("font-weight:").append(bold != false ? "bold" : "normal").append(";");
            }
            if (italic != null) {
                stringBuilder.append("font-style:").append(italic != false ? "italic" : "normal").append(";");
            }
            if (strikethrough != null || underlined != null) {
                if (strikethrough == null) {
                    strikethrough = parentStrikethrough;
                }
                if (underlined == null) {
                    underlined = parentUnderlined;
                }
                stringBuilder.append("text-decoration:");
                if (strikethrough.booleanValue()) {
                    stringBuilder.append("line-through");
                }
                if (underlined.booleanValue()) {
                    if (strikethrough.booleanValue()) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append("underline");
                } else if (!strikethrough.booleanValue()) {
                    stringBuilder.append("none");
                }
                stringBuilder.append(";");
            }
            stringBuilder.append("'>");
        }
        HtmlUtil.escapeHtml(stringBuilder, component.content());
        if (!component.children().isEmpty()) {
            for (Component child : component.children()) {
                HtmlUtil.toHTML(stringBuilder, strikethrough != null ? strikethrough : parentStrikethrough, underlined != null ? underlined : parentUnderlined, child);
            }
        }
        if (anyFormat) {
            stringBuilder.append("</span>");
        }
    }
}

