/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.StringUtilAdventure;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ComponentUtilAdventure {
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER;
    public static final Map<Character, NamedTextColor> COLOR_CHARS;
    public static final Map<NamedTextColor, Character> COLOR_CHARS_INVERSE;
    public static final Map<Character, TextDecoration> DECORATION_CHARS;
    public static final Map<TextDecoration, Character> DECORATION_CHARS_INVERSE;

    private ComponentUtilAdventure() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static LegacyComponentSerializer getLegacyComponentSerializer() {
        return LEGACY_COMPONENT_SERIALIZER;
    }

    public static Component deserializeComponent(String text) throws ParseException {
        return ComponentUtilAdventure.convertEscaped(text);
    }

    public static Component deserializeComponent(String text, int from, int to) throws ParseException {
        return ComponentUtilAdventure.convertEscaped(text, from, to);
    }

    public static Component convertEscaped(String text) throws ParseException {
        return ComponentUtilAdventure.convertEscaped(text, 0, text.length());
    }

    public static Component convertEscaped(String text, int from, int to) throws ParseException {
        return new EscapedConverter(text, from, to).convert();
    }

    public static String serializeComponent(Component component) {
        return ComponentUtilAdventure.serializeComponent(component.compact(), new StringBuilder()).toString();
    }

    private static StringBuilder serializeComponent(Component component, StringBuilder builder) {
        ComponentUtilAdventure.serializeColor(component, builder);
        ComponentUtilAdventure.serializeFormatting(component, builder);
        ComponentUtilAdventure.serializeEvents(component, builder);
        if (component instanceof TextComponent) {
            TextComponent c = (TextComponent)component;
            ComponentUtilAdventure.serializeTextComponent(c, builder);
        } else if (component instanceof TranslatableComponent) {
            TranslatableComponent c = (TranslatableComponent)component;
            ComponentUtilAdventure.serializeTranslatableComponent(c, builder);
        } else if (component instanceof ScoreComponent) {
            ScoreComponent c = (ScoreComponent)component;
            ComponentUtilAdventure.serializeScoreComponent(c, builder);
        } else if (component instanceof SelectorComponent) {
            SelectorComponent c = (SelectorComponent)component;
            ComponentUtilAdventure.serializeSelectorComponent(c, builder);
        } else if (component instanceof KeybindComponent) {
            KeybindComponent c = (KeybindComponent)component;
            ComponentUtilAdventure.serializeKeybindComponent(c, builder);
        } else {
            throw new IllegalArgumentException("unsupported component type " + component.getClass().getName());
        }
        ComponentUtilAdventure.serializeChildren(component, builder);
        return builder;
    }

    private static void escapeString(String raw, StringBuilder builder) {
        block4: for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            switch (c) {
                case '\n': {
                    builder.append("\\n");
                    continue block4;
                }
                case '&': 
                case '\\': 
                case '{': 
                case '}': {
                    builder.append('\\');
                }
                default: {
                    builder.append(c);
                }
            }
        }
    }

    private static void serializeColor(Component component, StringBuilder builder) {
        TextColor color = component.color();
        if (color == null) {
            return;
        }
        NamedTextColor named = NamedTextColor.namedColor((int)color.value());
        if (named != null) {
            builder.append("&" + String.valueOf(COLOR_CHARS_INVERSE.get(named)));
            return;
        }
        builder.append("&x");
        ComponentUtilAdventure.appendHexColorString(color, builder);
    }

    private static void appendHexColorString(TextColor color, StringBuilder builder) {
        String hexString = Integer.toHexString(color.value());
        int i = 0;
        while (i + hexString.length() < 6) {
            builder.append('0');
            ++i;
        }
        builder.append(hexString);
    }

    private static void serializeFormatting(Component component, StringBuilder builder) {
        boolean containsFalse = component.style().decorations().values().contains(TextDecoration.State.FALSE);
        if (containsFalse) {
            throw new IllegalArgumentException("can't deal with explicitely false decorations");
        }
        for (Map.Entry deco : component.style().decorations().entrySet()) {
            if (deco.getValue() == TextDecoration.State.NOT_SET) continue;
            builder.append("&" + String.valueOf(DECORATION_CHARS_INVERSE.get(deco.getKey())));
        }
        if (component.font() != null) {
            builder.append("\\f{").append(component.font().asMinimalString()).append('}');
        }
    }

    private static void serializeEvents(Component component, StringBuilder builder) {
        String insertion;
        ClickEvent ce;
        HoverEvent he = component.hoverEvent();
        if (he != null) {
            builder.append("\\h");
            HoverEvent.Action action = he.action();
            Object value = he.value();
            if (action == HoverEvent.Action.SHOW_TEXT) {
                builder.append("t{");
                if (!(value instanceof ComponentLike)) {
                    throw new ClassCastException("Expected HoverEvent SHOW_TEXT value to be instance of ComponentLike.");
                }
                ComponentLike cLike = (ComponentLike)value;
                ComponentUtilAdventure.serializeComponent(cLike.asComponent(), builder);
                builder.append('}');
            } else if (action == HoverEvent.Action.SHOW_ITEM) {
                builder.append("i{");
                if (!(value instanceof HoverEvent.ShowItem)) {
                    throw new ClassCastException("Expected HoverEvent SHOW_ITEM value to be instance of ShowItem.");
                }
                HoverEvent.ShowItem item = (HoverEvent.ShowItem)value;
                builder.append(item.item().asMinimalString()).append(',').append(item.count()).append(',');
                ComponentUtilAdventure.escapeString(item.nbt().string(), builder);
                builder.append('}');
            } else if (action == HoverEvent.Action.SHOW_ENTITY) {
                builder.append("e{");
                if (!(value instanceof HoverEvent.ShowEntity)) {
                    throw new ClassCastException("Expected HoverEvent SHOW_ENTITY value to be instance of ShowEntity.");
                }
                HoverEvent.ShowEntity entity = (HoverEvent.ShowEntity)value;
                builder.append(entity.type().asMinimalString()).append(',').append(entity.id().toString()).append(',');
                ComponentUtilAdventure.serializeComponent(entity.name(), builder);
                builder.append('}');
            } else {
                throw new IllegalArgumentException("HoverEvent Action " + String.valueOf(action) + " is not supported.");
            }
        }
        if ((ce = component.clickEvent()) != null) {
            builder.append("\\c");
            ClickEvent.Action action = ce.action();
            if (action == ClickEvent.Action.RUN_COMMAND) {
                builder.append('r');
            } else if (action == ClickEvent.Action.SUGGEST_COMMAND) {
                builder.append('s');
            } else if (action == ClickEvent.Action.COPY_TO_CLIPBOARD) {
                builder.append('c');
            } else if (action == ClickEvent.Action.CHANGE_PAGE) {
                builder.append('p');
            } else if (action == ClickEvent.Action.OPEN_URL) {
                builder.append('u');
            } else if (action == ClickEvent.Action.OPEN_FILE) {
                throw new IllegalArgumentException("ClickEvent Action OPEN_FILE is rejectet by clients and not supported.");
            }
            builder.append('{');
            ComponentUtilAdventure.escapeString(ce.value(), builder);
            builder.append('}');
        }
        if ((insertion = component.insertion()) != null) {
            builder.append("\\i{");
            ComponentUtilAdventure.escapeString(component.insertion(), builder);
            builder.append('}');
        }
    }

    private static void serializeChildren(Component component, StringBuilder builder) {
        List children = component.children();
        if (children == null) {
            return;
        }
        if ((children = children.stream().filter(Component.IS_NOT_EMPTY).toList()).isEmpty()) {
            return;
        }
        for (Component child : children) {
            if (children.size() != 1) {
                builder.append('{');
            }
            ComponentUtilAdventure.serializeComponent(child, builder);
            if (children.size() == 1) continue;
            builder.append('}');
        }
    }

    private static void serializeTextComponent(TextComponent componet, StringBuilder builder) {
        ComponentUtilAdventure.escapeString(componet.content(), builder);
    }

    private static void serializeTranslatableComponent(TranslatableComponent component, StringBuilder builder) {
        builder.append("\\t{");
        builder.append(component.key());
        for (TranslationArgument argument : component.arguments()) {
            builder.append('{');
            ComponentUtilAdventure.serializeComponent(argument.asComponent(), builder);
            builder.append('}');
        }
        builder.append('}');
    }

    private static void serializeScoreComponent(ScoreComponent component, StringBuilder builder) {
        builder.append("\\s{");
        builder.append(component.name()).append(',');
        builder.append(component.objective());
        builder.append('}');
    }

    private static void serializeSelectorComponent(SelectorComponent component, StringBuilder builder) {
        builder.append("\\@{");
        builder.append(component.pattern());
        builder.append('}');
    }

    private static void serializeKeybindComponent(KeybindComponent component, StringBuilder builder) {
        builder.append("\\k{");
        builder.append(component.keybind());
        builder.append('}');
    }

    static {
        LegacyComponentSerializer ser = null;
        try {
            ser = LegacyComponentSerializer.builder().character('\u00a7').extractUrls().useUnusualXRepeatedCharacterHexFormat().build();
        }
        catch (Throwable t) {
            ser = null;
        }
        LEGACY_COMPONENT_SERIALIZER = ser;
        LinkedHashMap<Character, NamedTextColor> colorChars = new LinkedHashMap<Character, NamedTextColor>();
        colorChars.put(Character.valueOf('0'), NamedTextColor.BLACK);
        colorChars.put(Character.valueOf('1'), NamedTextColor.DARK_BLUE);
        colorChars.put(Character.valueOf('2'), NamedTextColor.DARK_GREEN);
        colorChars.put(Character.valueOf('3'), NamedTextColor.DARK_AQUA);
        colorChars.put(Character.valueOf('4'), NamedTextColor.DARK_RED);
        colorChars.put(Character.valueOf('5'), NamedTextColor.DARK_PURPLE);
        colorChars.put(Character.valueOf('6'), NamedTextColor.GOLD);
        colorChars.put(Character.valueOf('7'), NamedTextColor.GRAY);
        colorChars.put(Character.valueOf('8'), NamedTextColor.DARK_GRAY);
        colorChars.put(Character.valueOf('9'), NamedTextColor.BLUE);
        colorChars.put(Character.valueOf('a'), NamedTextColor.GREEN);
        colorChars.put(Character.valueOf('b'), NamedTextColor.AQUA);
        colorChars.put(Character.valueOf('c'), NamedTextColor.RED);
        colorChars.put(Character.valueOf('d'), NamedTextColor.LIGHT_PURPLE);
        colorChars.put(Character.valueOf('e'), NamedTextColor.YELLOW);
        colorChars.put(Character.valueOf('f'), NamedTextColor.WHITE);
        COLOR_CHARS = Collections.unmodifiableMap(colorChars);
        LinkedHashMap<NamedTextColor, Character> colorCharsInverse = new LinkedHashMap<NamedTextColor, Character>();
        for (Map.Entry<Character, NamedTextColor> entry : COLOR_CHARS.entrySet()) {
            colorCharsInverse.put(entry.getValue(), entry.getKey());
        }
        COLOR_CHARS_INVERSE = Collections.unmodifiableMap(colorCharsInverse);
        LinkedHashMap<Character, TextDecoration> decorationChars = new LinkedHashMap<Character, TextDecoration>();
        decorationChars.put(Character.valueOf('k'), TextDecoration.OBFUSCATED);
        decorationChars.put(Character.valueOf('l'), TextDecoration.BOLD);
        decorationChars.put(Character.valueOf('m'), TextDecoration.STRIKETHROUGH);
        decorationChars.put(Character.valueOf('n'), TextDecoration.UNDERLINED);
        decorationChars.put(Character.valueOf('o'), TextDecoration.ITALIC);
        DECORATION_CHARS = Collections.unmodifiableMap(decorationChars);
        LinkedHashMap<TextDecoration, Character> decorationCharsInverse = new LinkedHashMap<TextDecoration, Character>();
        for (Map.Entry<Character, NamedTextColor> entry : DECORATION_CHARS.entrySet()) {
            decorationCharsInverse.put((TextDecoration)entry.getValue(), entry.getKey());
        }
        DECORATION_CHARS_INVERSE = Collections.unmodifiableMap(decorationCharsInverse);
    }

    private static class EscapedConverter {
        private String text;
        private int to;
        private List<Component> components;
        private int index;
        private StringBuilder currentBuilder;
        private Component currentComponent;

        EscapedConverter(String text, int from, int to) {
            this.text = Objects.requireNonNull(text);
            this.to = to;
            this.components = new ArrayList<Component>();
            this.index = from;
            this.currentBuilder = new StringBuilder();
            this.currentComponent = Component.empty();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Component convert() throws ParseException {
            while (this.index < this.to) {
                char current = this.text.charAt(this.index);
                if (current == '&') {
                    next = this.charAtOrException(this.index + 1);
                    if (next == '&') {
                        this.currentBuilder.append('&');
                        ++this.index;
                    } else if (COLOR_CHARS.containsKey(Character.valueOf(next)) || next == 'x') {
                        TextColor color;
                        if (next == 'x') {
                            if (this.index + 2 + 6 > this.to) {
                                throw new ParseException("illegal hex code", this.index);
                            }
                            color = StringUtilAdventure.parseHexColor(this.text, this.index + 2);
                            if (color == null) {
                                throw new ParseException("illegal hex code", this.index);
                            }
                            this.index += 7;
                        } else {
                            color = (TextColor)COLOR_CHARS.get(Character.valueOf(next));
                            ++this.index;
                        }
                        this.finishComponent(FormatRetention.EVENTS);
                        this.currentComponent = this.currentComponent.color(color);
                    } else if (DECORATION_CHARS.containsKey(Character.valueOf(next))) {
                        TextDecoration deco = DECORATION_CHARS.get(Character.valueOf(next));
                        this.finishComponent(FormatRetention.ALL);
                        this.currentComponent = this.currentComponent.decorate(deco);
                        ++this.index;
                    } else {
                        if (next != 'r') throw new ParseException("unknown color code &" + next, this.index);
                        this.finishComponent(FormatRetention.EVENTS);
                        ++this.index;
                    }
                } else if (current == '\\') {
                    next = this.charAtOrException(this.index + 1);
                    if (next == '\\' || next == '&' || next == '{' || next == '}') {
                        this.currentBuilder.append(next);
                        ++this.index;
                    } else if (next == 'n') {
                        this.currentBuilder.append('\n');
                        ++this.index;
                    } else if (next == 'r') {
                        char resetType = this.charAtOrException(this.index + 2);
                        if (resetType != 'a' && resetType != 'e' && resetType != 'f') {
                            throw new ParseException("unknown reset type " + resetType, this.index + 2);
                        }
                        this.finishComponent(resetType == 'a' ? FormatRetention.NONE : (resetType == 'e' ? FormatRetention.FORMATTING : FormatRetention.EVENTS));
                        this.index += 2;
                    } else if (next == 'h') {
                        HoverEvent event;
                        char actionType = this.charAtOrException(this.index + 2);
                        if (actionType != 't' && actionType != 'i' && actionType != 'e') {
                            throw new ParseException("unknown action type " + actionType, this.index + 2);
                        }
                        if (this.charAtOrException(this.index + 3) != '{') {
                            throw new ParseException("expected {", this.index + 3);
                        }
                        contentStartIndex = this.index + 4;
                        int contentEndIndex = this.findMatchingRightBrace(this.index + 3, this.to);
                        if (actionType == 't') {
                            event = HoverEvent.showText((Component)ComponentUtilAdventure.convertEscaped(this.text, contentStartIndex, contentEndIndex));
                        } else if (actionType == 'i') {
                            int itemCount;
                            String[] itemStrings = this.text.substring(contentStartIndex, contentEndIndex).split("\\,", 3);
                            Key itemKey = Key.key((String)itemStrings[0].toLowerCase());
                            try {
                                itemCount = itemStrings.length < 2 || itemStrings[1].isEmpty() ? 1 : Integer.parseInt(itemStrings[1]);
                            }
                            catch (NumberFormatException e) {
                                throw new ParseException("illegal item count " + itemStrings[1], this.index + 3 + itemStrings[0].length() + 1);
                            }
                            BinaryTagHolder itemTag = itemStrings.length < 3 || itemStrings[2].isEmpty() ? null : BinaryTagHolder.binaryTagHolder((String)this.convertEscapedString(itemStrings[2]));
                            event = HoverEvent.showItem((Key)itemKey, (int)itemCount, itemTag);
                        } else if (actionType == 'e') {
                            UUID entityId;
                            int nameStartIndex = this.text.substring(contentStartIndex, contentEndIndex).indexOf(123) + contentStartIndex;
                            String[] entityStrings = this.text.substring(contentStartIndex, nameStartIndex < 0 ? contentEndIndex : nameStartIndex).split("\\,", 2);
                            Key entityKey = Key.key((String)entityStrings[0].toLowerCase());
                            try {
                                entityId = entityStrings.length < 2 || entityStrings[1].isEmpty() ? UUID.randomUUID() : UUID.fromString(entityStrings[1]);
                            }
                            catch (IllegalArgumentException e) {
                                throw new ParseException("illegal entity id " + entityStrings[1], this.index + 3 + entityStrings[0].length() + 1);
                            }
                            Component entityName = nameStartIndex < contentStartIndex ? null : ComponentUtilAdventure.convertEscaped(this.text, nameStartIndex + 1, this.findMatchingRightBrace(nameStartIndex, contentEndIndex));
                            event = HoverEvent.showEntity((Key)entityKey, (UUID)entityId, entityName);
                        } else {
                            if ($assertionsDisabled) throw new ParseException("unknown action type " + actionType, this.index + 2);
                            throw new AssertionError();
                        }
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.hoverEvent((HoverEventSource)event);
                        this.index = contentEndIndex;
                    } else if (next == 'c') {
                        ClickEvent event;
                        char actionType = this.charAtOrException(this.index + 2);
                        if (this.charAtOrException(this.index + 3) != '{') {
                            throw new ParseException("expected {", this.index + 3);
                        }
                        contentStartIndex = this.index + 4;
                        int contentEndIndex = this.findMatchingRightBrace(this.index + 3, this.to);
                        String value = this.convertEscapedString(contentStartIndex, contentEndIndex);
                        if (actionType == 'r') {
                            event = ClickEvent.runCommand((String)value);
                        } else if (actionType == 's') {
                            event = ClickEvent.suggestCommand((String)value);
                        } else if (actionType == 'c') {
                            event = ClickEvent.copyToClipboard((String)value);
                        } else if (actionType == 'p') {
                            event = ClickEvent.changePage((String)value);
                        } else if (actionType == 'u') {
                            event = ClickEvent.openUrl((String)value);
                        } else {
                            if (actionType != 'f') throw new ParseException("unknown action type " + actionType, this.index + 2);
                            throw new ParseException("action type f is rejected by clients", this.index + 2);
                        }
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.clickEvent(event);
                        this.index = contentEndIndex;
                    } else if (next == 'i') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String insertion = this.convertEscapedString(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.insertion(insertion);
                        this.index = contentEndIndex;
                    } else if (next == 'f') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int fontStartIndex = this.index + 3;
                        int fontEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        Key fontKey = Key.key((String)this.text.substring(fontStartIndex, fontEndIndex).toLowerCase());
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.font(fontKey);
                        this.index = fontEndIndex;
                    } else if (next == 't') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        int translationKeyEndIndex = this.text.substring(contentStartIndex, contentEndIndex).indexOf(123);
                        translationKeyEndIndex = translationKeyEndIndex < 0 ? contentEndIndex : (translationKeyEndIndex += contentStartIndex);
                        String translationKey = this.text.substring(contentStartIndex, translationKeyEndIndex);
                        ArrayList<Component> translationExtras = new ArrayList<Component>();
                        int blockStartIndex = translationKeyEndIndex;
                        while (blockStartIndex < contentEndIndex) {
                            if (this.charAtOrException(blockStartIndex) != '{') {
                                throw new ParseException("expected {", blockStartIndex);
                            }
                            int blockEndIndex = this.findMatchingRightBrace(blockStartIndex, contentEndIndex);
                            assert (blockEndIndex >= 0);
                            translationExtras.add(ComponentUtilAdventure.convertEscaped(this.text, blockStartIndex + 1, blockEndIndex));
                            blockStartIndex = blockEndIndex + 1;
                        }
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.append((Component)Component.translatable((String)translationKey, translationExtras));
                        this.index = contentEndIndex;
                    } else if (next == 's') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String[] scoreStrings = this.text.substring(contentStartIndex, contentEndIndex).split("\\,", 2);
                        if (scoreStrings.length < 2) {
                            throw new ParseException("missing objective name", contentEndIndex);
                        }
                        String name = scoreStrings[0];
                        String objective = scoreStrings[1];
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.append((Component)Component.score((String)name, (String)objective));
                        this.index = contentEndIndex;
                    } else if (next == '@') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String selector = this.text.substring(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.append((Component)Component.selector((String)selector));
                        this.index = contentEndIndex;
                    } else {
                        if (next != 'k') throw new ParseException("unknown control sequence \\" + next, this.index);
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String keybind = this.text.substring(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent = this.currentComponent.append((Component)Component.keybind((String)keybind));
                        this.index = contentEndIndex;
                    }
                } else if (current == '{') {
                    int closingIndex = this.findMatchingRightBrace(this.index, this.to);
                    this.finishComponent();
                    Component subComponent = ComponentUtilAdventure.convertEscaped(this.text, this.index + 1, closingIndex);
                    this.currentComponent = this.currentComponent.append(subComponent);
                    this.index = closingIndex;
                } else {
                    if (current == '}') {
                        throw new ParseException("unmatched right brace", this.index);
                    }
                    this.currentBuilder.append(current);
                }
                ++this.index;
            }
            this.currentComponent = this.currentComponent.append((Component)Component.text((String)this.currentBuilder.toString()));
            this.components.add(this.currentComponent);
            return Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), this.components).compact();
        }

        private char charAtOrException(int i) throws ParseException {
            if (i >= this.to) {
                throw new ParseException("unexpected end of block", this.to);
            }
            return this.text.charAt(i);
        }

        private void finishComponent() {
            this.finishComponent(FormatRetention.ALL);
        }

        private void finishComponent(FormatRetention retention) {
            this.currentComponent = this.currentComponent.append((Component)Component.text((String)this.currentBuilder.toString()));
            this.components.add(this.currentComponent);
            TextComponent newComponent = Component.empty();
            newComponent = newComponent.mergeStyle(this.currentComponent, retention.MERGES);
            this.currentComponent = newComponent;
            this.currentBuilder = new StringBuilder();
        }

        private int findMatchingRightBrace(int leftBraceIndex, int endIndex) throws ParseException {
            int depth = 0;
            block5: for (int i = leftBraceIndex; i < endIndex; ++i) {
                switch (this.text.charAt(i)) {
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '{': {
                        ++depth;
                        break;
                    }
                    case '}': {
                        --depth;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (depth != 0) continue;
                return i;
            }
            throw new ParseException("unmatched left brace", leftBraceIndex);
        }

        private String convertEscapedString(String text) throws ParseException {
            return this.convertEscapedString(text, 0, text.length());
        }

        private String convertEscapedString(int from, int to) throws ParseException {
            return this.convertEscapedString(this.text, from, to);
        }

        private String convertEscapedString(String text, int from, int to) throws ParseException {
            StringBuilder result = new StringBuilder();
            for (int i = from; i < to; ++i) {
                char next;
                char curr = text.charAt(i);
                if (curr == '\\') {
                    if (i + 1 >= to) {
                        throw new ParseException("unexpected end of block", to);
                    }
                    next = text.charAt(i + 1);
                    if (next == '\\' || next == '&' || next == '{' || next == '}') {
                        result.append(next);
                    } else if (next == 'n') {
                        result.append('\n');
                    } else {
                        throw new ParseException("unknown simple control sequence \\" + next, i);
                    }
                    ++i;
                    continue;
                }
                if (curr == '&') {
                    if (i + 1 >= to) {
                        result.append('\u00a7');
                        continue;
                    }
                    next = text.charAt(i + 1);
                    if (next == '&') {
                        result.append('&');
                        ++i;
                        continue;
                    }
                    result.append('\u00a7');
                    continue;
                }
                result.append(curr);
            }
            return result.toString();
        }
    }

    private static enum FormatRetention {
        NONE(Style.Merge.merges((Style.Merge[])new Style.Merge[0])),
        FORMATTING(Style.Merge.merges((Style.Merge[])new Style.Merge[]{Style.Merge.COLOR, Style.Merge.DECORATIONS, Style.Merge.FONT})),
        EVENTS(Style.Merge.merges((Style.Merge[])new Style.Merge[]{Style.Merge.EVENTS, Style.Merge.INSERTION})),
        ALL(Style.Merge.all());

        public final Set<Style.Merge> MERGES;

        private FormatRetention(Set<Style.Merge> merges) {
            this.MERGES = merges;
        }
    }
}

