/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class Triple<T, S, U>
implements ConfigurationSerializable {
    public final T first;
    public final S second;
    public final U third;

    public Triple(T first, S second, U third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public Triple(Map<String, Object> serialized) {
        this.first = serialized.get("first");
        this.second = serialized.get("second");
        this.third = serialized.get("third");
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        result.put("first", this.first);
        result.put("second", this.second);
        result.put("third", this.third);
        return result;
    }

    public String toString() {
        return "(" + this.first + ";" + this.second + ";" + this.third + ")";
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Triple)) {
            return false;
        }
        Triple op = (Triple)other;
        return Objects.equals(this.first, op.first) && Objects.equals(this.second, op.second) && Objects.equals(this.third, op.third);
    }

    static {
        ConfigurationSerialization.registerClass(Triple.class);
    }
}

