/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.commands;

import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.cubesideutils.commands.CommandExceptionHandler;
import de.iani.cubesideutils.commands.SubCommand;
import de.iani.cubesideutils.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.commands.exceptions.RequiresPlayerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.util.StringUtil;

public abstract class HybridCommand
extends SubCommand
implements CommandExecutor,
TabCompleter {
    private CommandExceptionHandler handler;

    public HybridCommand(CommandExceptionHandler handler) {
        this.handler = Objects.requireNonNull(handler);
    }

    public HybridCommand() {
        this(CommandExceptionHandler.DEFAULT_HANDLER);
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        try {
            if (!this.allowsCommandBlock() && (sender instanceof BlockCommandSender || sender instanceof CommandMinecart)) {
                throw new DisallowsCommandBlockException(sender, command, alias, this, args);
            }
            if (this.requiresPlayer() && !(sender instanceof Player)) {
                throw new RequiresPlayerException(sender, command, alias, this, args);
            }
            if (!this.hasRequiredPermission(sender) || !this.isAvailable(sender)) {
                throw new NoPermissionException(sender, command, alias, (SubCommand)this, args, this.getRequiredPermission());
            }
            if (this.onCommand(sender, command, alias, "/" + alias, new ArgsParser(args))) {
                return true;
            }
            throw new IllegalSyntaxException(sender, command, alias, this, args);
        }
        catch (DisallowsCommandBlockException e) {
            return this.handler.handleDisallowsCommandBlock(e);
        }
        catch (RequiresPlayerException e) {
            return this.handler.handleRequiresPlayer(e);
        }
        catch (NoPermissionException e) {
            return this.handler.handleNoPermission(e);
        }
        catch (IllegalSyntaxException e) {
            return this.handler.handleIllegalSyntax(e);
        }
        catch (Throwable t) {
            return this.handler.handleInternalException(new InternalCommandException(sender, command, alias, (SubCommand)this, args, t));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (this.getRequiredPermission() != null && !sender.hasPermission(this.getRequiredPermission())) {
            return Collections.emptyList();
        }
        Collection<String> options = this.onTabComplete(sender, command, alias, new ArgsParser(args));
        if (options == null) {
            return null;
        }
        List result = (List)StringUtil.copyPartialMatches((String)(args.length > 0 ? args[args.length - 1] : ""), options, new ArrayList());
        Collections.sort(result);
        return result;
    }
}

