/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.commands;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.commands.AbstractCommandRouter;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.cubesideutils.commands.SubCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.util.StringUtil;

public class CommandRouter
extends AbstractCommandRouter<SubCommand, CommandSender>
implements CommandExecutor,
TabCompleter {
    public static final String UNKNOWN_COMMAND_MESSAGE = "Unknown command. Type \"/help\" for help.";

    public CommandRouter(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public void addPluginCommand(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    @Override
    public SubCommand getSubCommand(String path) {
        String[] args = path.split(" ");
        return (SubCommand)((AbstractCommandRouter.CommandMap)this.matchCommandMap(null, (String[])args).first).executor;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args, 1);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        String partial = args.length > 0 ? args[args.length - 1] : "";
        Collection<Object> options = null;
        ArrayList optionsList = null;
        if (currentMap.executor != null) {
            options = Collections.emptyList();
            if (this.hasPermission(sender, ((SubCommand)currentMap.executor).getRequiredPermission()) && (sender instanceof Player || !((SubCommand)currentMap.executor).requiresPlayer())) {
                options = ((SubCommand)currentMap.executor).onTabComplete(sender, command, alias, new ArgsParser(args, nr));
            }
        } else {
            options = Collections.emptyList();
        }
        if (nr == args.length - 1 && currentMap.subCommands != null) {
            for (Map.Entry<String, AbstractCommandRouter.CommandMap> e : currentMap.subCommands.entrySet()) {
                String key = e.getKey();
                if (!StringUtil.startsWithIgnoreCase((String)key, (String)partial)) continue;
                AbstractCommandRouter.CommandMap subcmd = e.getValue();
                if (!this.hasAnyPermission(sender, (Set<String>)subcmd.requiredPermissions) || !(sender instanceof Player) && subcmd.executor != null && ((SubCommand)subcmd.executor).requiresPlayer() || !this.isAnySubCommandAvailable(sender, subcmd)) continue;
                if (optionsList == null) {
                    optionsList = options == null ? new ArrayList() : new ArrayList(options);
                    options = optionsList;
                }
                optionsList.add(key);
            }
        }
        if (options != null) {
            optionsList = (ArrayList)StringUtil.copyPartialMatches((String)partial, options, new ArrayList());
            Collections.sort(optionsList);
        }
        return optionsList;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        SubCommand toExecute = (SubCommand)currentMap.executor;
        if (toExecute != null) {
            if (toExecute.allowsCommandBlock() || !(sender instanceof BlockCommandSender) && !(sender instanceof CommandMinecart)) {
                if (!toExecute.requiresPlayer() || sender instanceof Player) {
                    if (this.hasPermission(sender, toExecute.getRequiredPermission()) && toExecute.isAvailable(sender)) {
                        return toExecute.onCommand(sender, command, alias, this.getCommandString(alias, currentMap), new ArgsParser(args, nr));
                    }
                    sender.sendMessage(ChatColor.RED + "No permission!");
                    return true;
                }
                sender.sendMessage(ChatColor.RED + "This command can only be executed by players!");
                return true;
            }
            sender.sendMessage(ChatColor.RED + "This command is not allowed for CommandBlocks!");
            return true;
        }
        if (!this.hasAnyPermission(sender, (Set<String>)currentMap.requiredPermissions) || !this.isAnySubCommandAvailable(sender, currentMap)) {
            sender.sendMessage(ChatColor.RED + "No permission!");
            return true;
        }
        this.showHelp(sender, alias, currentMap);
        return true;
    }

    private String getCommandString(String alias, AbstractCommandRouter.CommandMap currentMap) {
        StringBuilder prefixBuilder = new StringBuilder();
        prefixBuilder.append('/').append(alias).append(' ');
        ArrayList<AbstractCommandRouter.CommandMap> hierarchy = new ArrayList<AbstractCommandRouter.CommandMap>();
        AbstractCommandRouter.CommandMap map = currentMap;
        while (map != null) {
            hierarchy.add(map);
            map = map.parent;
        }
        for (int i = hierarchy.size() - 2; i >= 0; --i) {
            prefixBuilder.append(((AbstractCommandRouter.CommandMap)hierarchy.get((int)i)).name).append(' ');
        }
        return prefixBuilder.toString();
    }

    private void showHelp(CommandSender sender, String alias, AbstractCommandRouter.CommandMap currentMap) {
        if (currentMap.subCommands != null) {
            String prefix = this.getCommandString(alias, currentMap);
            for (AbstractCommandRouter.CommandMap subcmd : currentMap.subcommandsOrdered) {
                String key = subcmd.name;
                if (subcmd.executor == null) {
                    if (!this.hasAnyPermission(sender, (Set<String>)subcmd.requiredPermissions) || !this.isAnySubCommandAvailable(sender, subcmd)) continue;
                    sender.sendMessage(prefix + key + " ...");
                    continue;
                }
                if (!this.hasPermission(sender, ((SubCommand)subcmd.executor).getRequiredPermission()) || !((SubCommand)subcmd.executor).isAvailable(sender) || !(sender instanceof Player) && ((SubCommand)subcmd.executor).requiresPlayer()) continue;
                sender.sendMessage(prefix + key + " " + ((SubCommand)subcmd.executor).getUsage(sender));
            }
        }
    }

    private boolean isAnySubCommandAvailable(CommandSender sender, AbstractCommandRouter.CommandMap cmd) {
        if (cmd.executor != null && ((SubCommand)cmd.executor).isAvailable(sender)) {
            return true;
        }
        if (cmd.subcommandsOrdered != null) {
            for (AbstractCommandRouter.CommandMap subcommand : cmd.subcommandsOrdered) {
                if (!this.isAnySubCommandAvailable(sender, subcommand)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasPermission(CommandSender handler, String permission) {
        return permission == null || handler.hasPermission(permission);
    }

    @Override
    protected boolean hasAnyPermission(CommandSender handler, Set<String> permissions) {
        if (permissions == null) {
            return true;
        }
        for (String permission : permissions) {
            if (!handler.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }
}

