/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;

public class StringUtil {
    public static final ToIntFunction<String> CASE_IGNORING_HASHER;
    public static final BiPredicate<String, String> CASE_IGNOREING_EQUALITY;
    public static final Pattern MATCH_COLOR_CODES;
    private static final Set<Character> CHARS_ILLEGAL_IN_FILENAME;
    private static final NavigableMap<Integer, String> ROMAN_NUMBER_MAP;
    public static final String DATE_FORMAT_STRING = "dd.MM.yyyy";
    public static final String TIME_FORMAT_STRING = "HH:mm";
    public static final String TIME_SECONDS_FORMAT_STRING = "HH:mm:ss";
    public static final String DATE_AND_TIME_FORMAT_STRING = "dd.MM.yyyy HH:mm";
    public static final String DATE_AND_TIME_SECONDS_FORMAT_STRING = "dd.MM.yyyy HH:mm:ss";
    private static final DateFormat dateFormat;
    private static final DateFormat timeFormat;
    private static final DateFormat timeSecondsFormat;
    private static final Map<Color, String> CONSTANT_COLORS;

    public static String capitalizeFirstLetter(String s, boolean replaceUnderscores) {
        char[] cap = s.toCharArray();
        boolean lastSpace = true;
        for (int i = 0; i < cap.length; ++i) {
            char c = cap[i];
            if (c == '_') {
                if (replaceUnderscores) {
                    c = ' ';
                }
                lastSpace = true;
            } else if (c >= '0' && c <= '9' || c == '(' || c == ')') {
                lastSpace = true;
            } else {
                c = lastSpace ? Character.toUpperCase(c) : Character.toLowerCase(c);
                lastSpace = false;
            }
            cap[i] = c;
        }
        return new String(cap);
    }

    public static String formatBlockLocationWithoutWorld(Location loc) {
        return loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static String convertColors(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char next;
            char current = text.charAt(i);
            if (current == '&' && i + 1 < len && (ChatColor.getByChar((char)(next = text.charAt(i + 1))) != null || next == '&')) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(text, 0, i);
                }
                ++i;
                if (next != '&') {
                    builder.append('\u00a7').append(next);
                    continue;
                }
            }
            if (builder == null) continue;
            builder.append(current);
        }
        return builder == null ? text : builder.toString();
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength) {
        return StringUtil.breakLines(text, lineLength, MATCH_COLOR_CODES);
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength, boolean forceLineBreak) {
        return StringUtil.breakLines(text, lineLength, MATCH_COLOR_CODES, forceLineBreak);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength) {
        return StringUtil.breakLines(text, lineLength, ignoreForLength, false);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength, boolean forceLineBreak) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentBuilder = new StringBuilder();
        char[] chars = text.toCharArray();
        int index = 0;
        int lastBlank = -1;
        int lastBreak = 0;
        while (index < chars.length) {
            char current = chars[index];
            if (current == ' ') {
                lastBlank = index;
            }
            currentBuilder.append(current);
            if (StringUtil.tooLong(currentBuilder.toString(), lineLength, ignoreForLength)) {
                if (lastBlank > lastBreak) {
                    int start = lastBlank - lastBreak;
                    int end = currentBuilder.length();
                    currentBuilder.delete(start, end);
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    lastBreak = index = lastBlank + 1;
                    continue;
                }
                if (forceLineBreak) {
                    currentBuilder.delete(currentBuilder.length() - 1, currentBuilder.length());
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    lastBreak = index;
                    continue;
                }
            }
            ++index;
        }
        if (currentBuilder.length() > 0) {
            result.add(currentBuilder.toString());
        }
        return result;
    }

    private static boolean tooLong(String string, int limit, Pattern ignoreForLength) {
        string = ignoreForLength == null ? string : ignoreForLength.matcher(string).replaceAll("");
        return string.length() > limit;
    }

    public static boolean isSafeFilename(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!CHARS_ILLEGAL_IN_FILENAME.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalCommandName(String name) {
        return !name.contains(" ");
    }

    public static String toRomanNumber(int arg) {
        int i = ROMAN_NUMBER_MAP.floorKey(arg);
        if (arg == i) {
            return (String)ROMAN_NUMBER_MAP.get(arg);
        }
        return (String)ROMAN_NUMBER_MAP.get(i) + StringUtil.toRomanNumber(arg - i);
    }

    public static String formatTimespan(long ms) {
        return StringUtil.formatTimespan(ms, "d", "h", "m", "s", "", "");
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter) {
        return StringUtil.formatTimespan(ms, d, h, m, s, delimiter, lastDelimiter, true);
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter, boolean dropAllLowerIfZero) {
        return StringUtil.formatTimespan(ms, d, h, m, s, delimiter, lastDelimiter, dropAllLowerIfZero, false);
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter, boolean dropAllLowerIfZero, boolean forceMinutesAndTwoDigitsForTime) {
        String result;
        long days = ms / 86400000L;
        long hours = (ms -= days * 86400000L) / 3600000L;
        long minutes = (ms -= hours * 3600000L) / 60000L;
        long seconds = (ms -= minutes * 60000L) / 1000L;
        double lessThanSeconds = (double)(ms -= seconds * 1000L) / 1000.0;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        boolean allNext = false;
        if (days != 0L) {
            first = false;
            allNext = !dropAllLowerIfZero;
            builder.append(days);
            builder.append(d);
        }
        if (allNext || hours != 0L) {
            if (!first) {
                if (allNext || minutes != 0L || seconds != 0L || lessThanSeconds != 0.0) {
                    builder.append(delimiter);
                } else {
                    builder.append(lastDelimiter);
                }
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && hours < 10L) {
                builder.append('0');
            }
            builder.append(hours);
            builder.append(h);
        }
        if (allNext || forceMinutesAndTwoDigitsForTime || minutes != 0L) {
            if (!first) {
                if (allNext || seconds != 0L || lessThanSeconds != 0.0) {
                    builder.append(delimiter);
                } else {
                    builder.append(lastDelimiter);
                }
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && minutes < 10L) {
                builder.append('0');
            }
            builder.append(minutes);
            builder.append(m);
        }
        if (allNext || seconds != 0L || lessThanSeconds != 0.0) {
            if (!first) {
                builder.append(lastDelimiter);
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && seconds < 10L) {
                builder.append('0');
            }
            builder.append(seconds);
            if (lessThanSeconds != 0.0) {
                builder.append(".");
                String lessThanSecondsString = "" + lessThanSeconds;
                lessThanSecondsString = lessThanSecondsString.substring(lessThanSecondsString.indexOf(46) + 1);
                builder.append(lessThanSecondsString);
            }
            builder.append(s);
        }
        if (!(result = builder.toString().trim()).equals("")) {
            return result;
        }
        return ("0" + s).trim();
    }

    public static synchronized String formatDate(long date) {
        return StringUtil.formatDate(new Date(date));
    }

    public static synchronized String formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String result = dateFormat.format(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if (hour == 0 && minute == 0 && second == 0) {
            return result;
        }
        result = result + " " + (second == 0 ? timeFormat.format(date) : timeSecondsFormat.format(date)) + " Uhr";
        return result;
    }

    public static String toNiceString(Color color) {
        if (CONSTANT_COLORS.containsKey(color)) {
            return CONSTANT_COLORS.get(color);
        }
        double lowestDiff = Double.MAX_VALUE;
        String bestMatch = null;
        for (Color other : CONSTANT_COLORS.keySet()) {
            double diff = StringUtil.diff(color, other);
            if (!(diff < lowestDiff)) continue;
            lowestDiff = diff;
            bestMatch = CONSTANT_COLORS.get(other);
        }
        String hexString = Integer.toHexString(color.asRGB()).toUpperCase();
        int zerosMissing = 6 - hexString.length();
        StringBuilder builder = new StringBuilder("roughly ");
        builder.append(bestMatch).append(" (#");
        for (int i = 0; i < zerosMissing; ++i) {
            builder.append('0');
        }
        builder.append(hexString).append(")");
        return builder.toString();
    }

    private static double diff(Color c1, Color c2) {
        return Math.sqrt(Math.pow(c1.getRed() - c2.getRed(), 2.0) + Math.pow(c1.getBlue() - c2.getBlue(), 2.0) + Math.pow(c1.getGreen() - c2.getGreen(), 2.0));
    }

    static {
        char c;
        CASE_IGNORING_HASHER = s -> {
            if (s == null) {
                return 0;
            }
            int hash = 0;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                hash = 31 * hash + Character.toLowerCase((int)c);
            }
            return hash;
        };
        CASE_IGNOREING_EQUALITY = (s1, s2) -> s1 == null ? s2 == null : s1.equalsIgnoreCase((String)s2);
        MATCH_COLOR_CODES = Pattern.compile("\\\u00a7[" + Arrays.stream(ChatColor.values()).map(ChatColor::getChar).map(String::valueOf).collect(Collectors.joining()) + "]", 2);
        HashSet<Character> illegals = new HashSet<Character>();
        boolean bl = false;
        while (c <= '\u001f') {
            illegals.add(Character.valueOf(c));
            c = (char)(c + true);
        }
        for (char c2 : new char[]{'|', '\\', '/', '?', '!', '*', '+', '%', '<', '>', '\"', ':', ';', ',', '.', '=', '[', ']', '@', '\u007f'}) {
            illegals.add(Character.valueOf(c2));
        }
        CHARS_ILLEGAL_IN_FILENAME = Collections.unmodifiableSet(illegals);
        TreeMap<Integer, String> romanNumberMap = new TreeMap<Integer, String>();
        romanNumberMap.put(1000, "M");
        romanNumberMap.put(900, "CM");
        romanNumberMap.put(500, "D");
        romanNumberMap.put(400, "CD");
        romanNumberMap.put(100, "C");
        romanNumberMap.put(90, "XC");
        romanNumberMap.put(50, "L");
        romanNumberMap.put(40, "XL");
        romanNumberMap.put(10, "X");
        romanNumberMap.put(9, "IX");
        romanNumberMap.put(5, "V");
        romanNumberMap.put(4, "IV");
        romanNumberMap.put(1, "I");
        ROMAN_NUMBER_MAP = Collections.unmodifiableNavigableMap(romanNumberMap);
        dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        timeFormat = new SimpleDateFormat(TIME_FORMAT_STRING);
        timeSecondsFormat = new SimpleDateFormat(TIME_SECONDS_FORMAT_STRING);
        LinkedHashMap<Color, String> constantColors = new LinkedHashMap<Color, String>();
        constantColors.put(Color.AQUA, "aqua");
        constantColors.put(Color.BLACK, "black");
        constantColors.put(Color.BLUE, "blue");
        constantColors.put(Color.FUCHSIA, "fuchsia");
        constantColors.put(Color.GRAY, "gray");
        constantColors.put(Color.GREEN, "greeen");
        constantColors.put(Color.LIME, "lime");
        constantColors.put(Color.MAROON, "maroon");
        constantColors.put(Color.NAVY, "navy");
        constantColors.put(Color.OLIVE, "olive");
        constantColors.put(Color.ORANGE, "orange");
        constantColors.put(Color.PURPLE, "purple");
        constantColors.put(Color.RED, "Aqua");
        constantColors.put(Color.SILVER, "red");
        constantColors.put(Color.TEAL, "teal");
        constantColors.put(Color.WHITE, "white");
        constantColors.put(Color.YELLOW, "yellow");
        for (DyeColor dc : DyeColor.values()) {
            constantColors.put(dc.getColor(), dc.name().replaceAll(Pattern.quote("_"), " ").toLowerCase());
        }
        CONSTANT_COLORS = Collections.unmodifiableMap(constantColors);
    }
}

