/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.GlobalStatisticKeyImplementation;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.Callback;
import de.iani.cubesidestats.api.GlobalStatisticKey;
import de.iani.cubesidestats.api.GlobalStatistics;
import de.iani.cubesidestats.api.TimeFrame;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class GlobalStatisticsImplementation
implements GlobalStatistics {
    private CubesideStatisticsImplementation stats;

    public GlobalStatisticsImplementation(CubesideStatisticsImplementation stats) {
        if (stats == null) {
            throw new NullPointerException("stats");
        }
        this.stats = stats;
    }

    @Override
    public void decreaseValue(GlobalStatisticKey key, int amount) {
        this.increaseValue(key, -amount);
    }

    @Override
    public void increaseValue(final GlobalStatisticKey key, final int amount) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.increaseGlobalStatsValue((GlobalStatisticKeyImplementation)key, month, daykey, amount);
                }
                catch (SQLException e) {
                    GlobalStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not increase global value", e);
                }
            }
        });
    }

    @Override
    public void setValue(final GlobalStatisticKey key, final int value) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.setGlobalStatsValue((GlobalStatisticKeyImplementation)key, month, daykey, value);
                }
                catch (SQLException e) {
                    GlobalStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set global value", e);
                }
            }
        });
    }

    @Override
    public void maxValue(GlobalStatisticKey key, int value) {
        this.maxValue(key, value, null);
    }

    @Override
    public void maxValue(final GlobalStatisticKey key, final int value, final Callback<Boolean> updatedCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    final boolean result = database.maxGlobalStatsValue((GlobalStatisticKeyImplementation)key, month, daykey, value);
                    if (updatedCallback != null && GlobalStatisticsImplementation.this.stats.getPlugin().isEnabled()) {
                        GlobalStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)GlobalStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(result);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    GlobalStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set global value", e);
                }
            }
        });
    }

    @Override
    public void minValue(GlobalStatisticKey key, int value) {
        this.minValue(key, value, null);
    }

    @Override
    public void minValue(final GlobalStatisticKey key, final int value, final Callback<Boolean> updatedCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    final boolean result = database.minGlobalStatsValue((GlobalStatisticKeyImplementation)key, month, daykey, value);
                    if (updatedCallback != null && GlobalStatisticsImplementation.this.stats.getPlugin().isEnabled()) {
                        GlobalStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)GlobalStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(result);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    GlobalStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set global value", e);
                }
            }
        });
    }

    @Override
    public void getValue(GlobalStatisticKey key, TimeFrame timeFrame, Callback<Integer> scoreCallback) {
        this.getScoreInMonth(key, this.getMonthKey(timeFrame), scoreCallback);
    }

    private int getMonthKey(TimeFrame timeFrame) {
        int month = -1;
        if (timeFrame == TimeFrame.MONTH) {
            month = this.stats.getCurrentMonthKey();
        } else if (timeFrame == TimeFrame.DAY) {
            month = this.stats.getCurrentDayKey();
        }
        return month;
    }

    private void getScoreInMonth(final GlobalStatisticKey key, final int month, final Callback<Integer> scoreCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (scoreCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                final Integer score = GlobalStatisticsImplementation.this.internalGetScoreInMonth(database, key, month);
                if (score != null && GlobalStatisticsImplementation.this.stats.getPlugin().isEnabled()) {
                    GlobalStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)GlobalStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            scoreCallback.call(score);
                        }
                    });
                }
            }
        });
    }

    protected Integer internalGetScoreInMonth(StatisticsDatabase database, GlobalStatisticKey key, int month) {
        try {
            return database.getGlobalStatsValue((GlobalStatisticKeyImplementation)key, month);
        }
        catch (SQLException e) {
            this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get global value", e);
            return null;
        }
    }
}

