/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.AchivementKey;
import de.iani.cubesidestats.api.Callback;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.StatisticKey;
import de.iani.cubesidestats.api.TimeFrame;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class PlayerStatisticsImplementation
implements PlayerStatistics {
    private CubesideStatisticsImplementation stats;
    private final UUID playerId;
    private int databaseId;

    public PlayerStatisticsImplementation(final CubesideStatisticsImplementation stats, final UUID player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (stats == null) {
            throw new NullPointerException("stats");
        }
        this.stats = stats;
        this.playerId = player;
        this.databaseId = -1;
        stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    PlayerStatisticsImplementation.this.databaseId = database.getOrCreatePlayerId(player);
                }
                catch (SQLException e) {
                    stats.getPlugin().getLogger().log(Level.SEVERE, "Could not load database id for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public UUID getOwner() {
        return this.playerId;
    }

    @Override
    public void decreaseScore(StatisticKey key, int amount) {
        this.increaseScore(key, -amount);
    }

    @Override
    public void increaseScore(final StatisticKey key, final int amount) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.increaseScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, amount);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not increase score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void setScore(final StatisticKey key, final int value) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.setScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, value);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void maxScore(StatisticKey key, int value) {
        this.maxScore(key, value, null);
    }

    @Override
    public void maxScore(final StatisticKey key, final int value, final Callback<Boolean> updatedCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final boolean result = database.maxScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, value);
                    if (updatedCallback != null) {
                        PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(result);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void minScore(StatisticKey key, int value) {
        this.minScore(key, value, null);
    }

    @Override
    public void minScore(final StatisticKey key, final int value, final Callback<Boolean> updatedCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final boolean result = database.minScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, value);
                    if (updatedCallback != null) {
                        PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(result);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void getScore(StatisticKey key, TimeFrame timeFrame, Callback<Integer> scoreCallback) {
        this.getScoreInMonth(key, this.getMonthKey(timeFrame), scoreCallback);
    }

    @Override
    public void getPosition(StatisticKey key, TimeFrame timeFrame, Callback<Integer> positionCallback) {
        this.getPositionInMonth(key, this.getMonthKey(timeFrame), positionCallback);
    }

    private int getMonthKey(TimeFrame timeFrame) {
        int month = -1;
        if (timeFrame == TimeFrame.MONTH) {
            month = this.stats.getCurrentMonthKey();
        } else if (timeFrame == TimeFrame.DAY) {
            month = this.stats.getCurrentDayKey();
        }
        return month;
    }

    private void getScoreInMonth(final StatisticKey key, final int month, final Callback<Integer> scoreCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (scoreCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer score = database.getScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            scoreCallback.call(score);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private void getPositionInMonth(final StatisticKey key, final int month, final Callback<Integer> scoreCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (scoreCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer score = database.getScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            scoreCallback.call(score);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void grantAchivement(AchivementKey key) {
    }

    @Override
    public void revokeAchivement(AchivementKey key) {
    }

    @Override
    public void hasAchivement(AchivementKey key, Callback<Boolean> achivementCallback) {
    }
}

