/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings;

import de.iani.cubesideutils.bukkit.commands.CommandRouter;
import de.iani.cubesideutils.bukkit.commands.NoChangeCommandActionFlagsCheckListener;
import de.iani.cubesideutils.commands.PermissionRequirer;
import de.iani.settings.CubesideSettingsAPI;
import de.iani.settings.PlayerListener;
import de.iani.settings.PlayerSettings;
import de.iani.settings.PluginConfig;
import de.iani.settings.SettingsDatabase;
import de.iani.settings.commands.AddAliasCommand;
import de.iani.settings.commands.ListAliasesCommand;
import de.iani.settings.commands.RemoveAliasCommand;
import de.iani.settings.commands.SettingsCommand;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class CubesideSettings
extends JavaPlugin
implements CubesideSettingsAPI {
    private PluginConfig pluginConfig;
    private SettingsDatabase settingsDatabase;
    private ItemStack settingsItem;
    private ConcurrentHashMap<UUID, PlayerSettings> playerSettings;

    public void onEnable() {
        this.saveDefaultConfig();
        this.playerSettings = new ConcurrentHashMap();
        this.pluginConfig = new PluginConfig(this.getConfig());
        try {
            this.settingsDatabase = new SettingsDatabase(this, this.pluginConfig.getDatabaseConfig());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not connect to database", e);
        }
        this.settingsItem = new ItemStack(Material.REPEATER);
        ItemMeta meta = this.settingsItem.getItemMeta();
        meta.displayName((Component)Component.text((String)"Einstellungen", (TextColor)NamedTextColor.BLUE));
        this.settingsItem.setItemMeta(meta);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getServicesManager().register(CubesideSettingsAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        CommandRouter commandRouter = new CommandRouter(this.getCommand("settings"));
        commandRouter.addCommandMapping((PermissionRequirer)new SettingsCommand(this), new String[0]);
        commandRouter.addCommandMapping((PermissionRequirer)new AddAliasCommand(this), new String[]{"addhighlight"});
        commandRouter.addCommandMapping((PermissionRequirer)new RemoveAliasCommand(this), new String[]{"removehighlight"});
        commandRouter.addCommandMapping((PermissionRequirer)new ListAliasesCommand(this), new String[]{"listhighlights"});
        this.getServer().getPluginManager().registerEvents((Listener)new NoChangeCommandActionFlagsCheckListener((Command)this.getCommand("settings")), (Plugin)this);
    }

    public ItemStack getSettingsItem() {
        return this.settingsItem;
    }

    public Component getSettingsInventoryTitle() {
        return Component.text((String)"Einstellungen", null, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
    }

    public Component getSettingsChatInventoryTitle() {
        return Component.text((String)"Einstellungen - Chat", null, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
    }

    public Component getSettingsSoundsInventoryTitle() {
        return Component.text((String)"Einstellungen - Sounds", null, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
    }

    public Component getSettingsAllgemeinInventoryTitle() {
        return Component.text((String)"Allgemeine Einstellungen", null, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
    }

    private Inventory createBaseInventory(Player p, int rows, Component title, ItemStack backItem) {
        int i;
        Inventory inv = Bukkit.createInventory(null, (int)((rows + 2) * 9), (Component)title);
        ItemStack frameSlot = this.createItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE, null, new Component[0]);
        for (i = 0; i < 9; ++i) {
            if (i == 0 && backItem != null) {
                inv.setItem(i, backItem);
            } else {
                inv.setItem(i, frameSlot);
            }
            inv.setItem(i + (rows + 1) * 9, frameSlot);
        }
        for (i = 1; i < rows + 1; ++i) {
            inv.setItem(0 + i * 9, frameSlot);
            inv.setItem(8 + i * 9, frameSlot);
        }
        return inv;
    }

    public void openSettingsInventoryOnPlayer(Player p) {
        int rows = 3;
        Inventory inv = this.createBaseInventory(p, rows, this.getSettingsInventoryTitle(), null);
        PlayerSettings ps = this.getSettings(p);
        ps.setOpenSettingsInventory(inv, PlayerSettings.OpenSettingsWindow.MAIN);
        ItemStack stack = this.createItemStack(Material.PAPER, this.greenBold("Chateinstellungen"), new Component[0]);
        inv.setItem(20, stack);
        stack = this.createItemStack(Material.NOTE_BLOCK, this.greenBold("Soundeinstellungen"), new Component[0]);
        inv.setItem(22, stack);
        stack = this.createItemStack(Material.REPEATER, this.greenBold("Allgemeine Einstellungen"), new Component[0]);
        inv.setItem(24, stack);
        p.openInventory(inv);
    }

    public void openChatSettingsInventoryOnPlayer(Player p) {
        int rows = 2;
        Inventory inv = this.createBaseInventory(p, rows, this.getSettingsChatInventoryTitle(), this.createItemStack(Material.BOOK, this.greenBold("zur\u00fcck zu den Einstellungen"), new Component[0]));
        PlayerSettings ps = this.getSettings(p);
        ps.setOpenSettingsInventory(inv, PlayerSettings.OpenSettingsWindow.CHAT);
        this.updateShowPublicChatItems(inv, ps);
        this.updateShowJoinQuitMessages(inv, ps);
        this.updateShowPrivateMessages(inv, ps);
        this.updateShowNewsticker(inv, ps);
        p.openInventory(inv);
    }

    public void openSoundsSettingsInventoryOnPlayer(Player p) {
        int rows = 2;
        Inventory inv = this.createBaseInventory(p, rows, this.getSettingsSoundsInventoryTitle(), this.createItemStack(Material.BOOK, this.greenBold("zur\u00fcck zu den Einstellungen"), new Component[0]));
        PlayerSettings ps = this.getSettings(p);
        ps.setOpenSettingsInventory(inv, PlayerSettings.OpenSettingsWindow.SOUND);
        this.updateSoundOnPrivateMessageItems(inv, ps);
        this.updateSoundOnReferenceMessagesItems(inv, ps);
        p.openInventory(inv);
    }

    public void openAllgemeinSettingsInventoryOnPlayer(Player p) {
        int rows = 2;
        Inventory inv = this.createBaseInventory(p, rows, this.getSettingsAllgemeinInventoryTitle(), this.createItemStack(Material.BOOK, this.greenBold("zur\u00fcck zu den Einstellungen"), new Component[0]));
        PlayerSettings ps = this.getSettings(p);
        ps.setOpenSettingsInventory(inv, PlayerSettings.OpenSettingsWindow.ALLGEMEIN);
        this.updateAllgemeinesShowCompassInSurvivalItems(inv, ps);
        p.openInventory(inv);
    }

    private void updateShowPublicChatItems(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getShowPublicChat();
        ItemStack stack = this.createItemStack(Material.PAPER, this.colorBold(this.getYesNoNotInGamesToColor(pc), "\u00d6ffentlichen Chat anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.colorBold(this.getYesNoNotInGamesToColor(pc), "\u00d6ffentlichen Chat anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        inv.setItem(10, stack);
        inv.setItem(19, stack2);
    }

    private void updateShowJoinQuitMessages(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getShowJoinAndQuitMessages();
        ItemStack stack = this.createItemStack(Material.ENDER_EYE, this.colorBold(this.getYesNoNotInGamesToColor(pc), "Join/Quit-Nachrichten anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.colorBold(this.getYesNoNotInGamesToColor(pc), "Join/Quit-Nachrichten anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        inv.setItem(12, stack);
        inv.setItem(21, stack2);
    }

    private void updateShowPrivateMessages(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = PlayerSettings.YesNoNotInGames.valueOf(ps.getShowPrivateMessages());
        ItemStack stack = this.createItemStack(Material.MAP, this.colorBold(this.getYesNoNotInGamesToColor(pc), "Private Nachrichten anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.colorBold(this.getYesNoNotInGamesToColor(pc), "Private Nachrichten anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        inv.setItem(14, stack);
        inv.setItem(23, stack2);
    }

    private void updateShowNewsticker(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getShowNewsticker();
        ItemStack stack = this.createItemStack(Material.MAP, this.colorBold(this.getYesNoNotInGamesToColor(pc), "Newsticker anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.colorBold(this.getYesNoNotInGamesToColor(pc), "Newsticker anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        inv.setItem(16, stack);
        inv.setItem(25, stack2);
    }

    private void updateSoundOnPrivateMessageItems(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getSoundOnPrivateMessage();
        ItemStack stack = this.createItemStack(Material.MAP, this.colorBold(this.getYesNoNotInGamesToColor(pc), "Sound bei privaten Nachrichten"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.colorBold(this.getYesNoNotInGamesToColor(pc), "Sound bei privaten Nachrichten"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        inv.setItem(10, stack);
        inv.setItem(19, stack2);
    }

    private void updateSoundOnReferenceMessagesItems(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getSoundOnReference();
        ItemStack stack = this.createItemStack(Material.PUFFERFISH, this.colorBold(this.getYesNoNotInGamesToColor(pc), "Sound bei Erw\u00e4hnung im Chat"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.colorBold(this.getYesNoNotInGamesToColor(pc), "Sound bei Erw\u00e4hnung im Chat"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        inv.setItem(12, stack);
        inv.setItem(21, stack2);
    }

    private void updateAllgemeinesShowCompassInSurvivalItems(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = PlayerSettings.YesNoNotInGames.valueOf(ps.getShowCompassInSurvival());
        ItemStack stack = this.createItemStack(Material.COMPASS, this.colorBold(this.getYesNoNotInGamesToColor(pc), "Kompass in Bauwelten anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.colorBold(this.getYesNoNotInGamesToColor(pc), "Kompass in Bauwelten anzeigen"), new Component[]{this.getYesNoNotInGamesToColorAndText(pc), Component.empty(), this.white("Klicken zum \u00c4ndern")});
        inv.setItem(10, stack);
        inv.setItem(19, stack2);
    }

    public TextColor getYesNoNotInGamesToColor(PlayerSettings.YesNoNotInGames value) {
        return value == PlayerSettings.YesNoNotInGames.Yes ? NamedTextColor.GREEN : (value == PlayerSettings.YesNoNotInGames.No ? NamedTextColor.RED : NamedTextColor.YELLOW);
    }

    public Component getYesNoNotInGamesToColorAndText(PlayerSettings.YesNoNotInGames value) {
        return Component.text((String)(value == PlayerSettings.YesNoNotInGames.Yes ? "Aktiv" : (value == PlayerSettings.YesNoNotInGames.No ? "Nicht aktiv" : "Nur ausserhalb von Spielrunden")), (TextColor)this.getYesNoNotInGamesToColor(value));
    }

    private Component white(String text) {
        return Component.text((String)text, (TextColor)NamedTextColor.WHITE);
    }

    private Component greenBold(String text) {
        return Component.text((String)text, (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
    }

    private Component colorBold(TextColor color, String text) {
        return Component.text((String)text, (TextColor)color, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
    }

    public ItemStack getYesNoNotInGamesToDyeStack(PlayerSettings.YesNoNotInGames value) {
        if (value == PlayerSettings.YesNoNotInGames.Yes) {
            return new ItemStack(Material.GREEN_DYE);
        }
        if (value == PlayerSettings.YesNoNotInGames.No) {
            return new ItemStack(Material.RED_DYE);
        }
        return new ItemStack(Material.YELLOW_DYE);
    }

    public PlayerSettings.YesNoNotInGames nextYesNoNotInGames(PlayerSettings.YesNoNotInGames old) {
        return PlayerSettings.YesNoNotInGames.valueOf((old.ordinal() + 1) % 3);
    }

    public ItemStack setItemStack(ItemStack stack, Component name, Component ... lore) {
        ItemMeta meta = stack.getItemMeta();
        if (name == null) {
            meta.setHideTooltip(true);
        } else {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
            ArrayList<Component> loreResult = new ArrayList<Component>();
            for (Component line : lore) {
                loreResult.add(line.decoration(TextDecoration.ITALIC, false));
            }
            meta.lore(loreResult);
        }
        stack.setItemMeta(meta);
        return stack;
    }

    public ItemStack createItemStack(Material material, Component name, Component ... lore) {
        return this.setItemStack(new ItemStack(material, 1), name, lore);
    }

    public void checkForSettingsItem(Player p) {
        if (this.pluginConfig.getSettingsItemWorlds().contains(p.getWorld().getName())) {
            ItemStack compass = this.getSettingsItem();
            compass.setAmount(Integer.MAX_VALUE);
            p.getInventory().removeItem(new ItemStack[]{compass});
            if (!p.getInventory().containsAtLeast(compass, 1)) {
                compass.setAmount(1);
                if (this.pluginConfig.getSettingsItemSlot() >= 0) {
                    p.getInventory().setItem(this.pluginConfig.getSettingsItemSlot(), compass);
                } else {
                    p.getInventory().addItem(new ItemStack[]{compass});
                }
                p.updateInventory();
            }
        } else {
            ItemStack compass = this.getSettingsItem();
            compass.setAmount(Integer.MAX_VALUE);
            p.getInventory().removeItem(new ItemStack[]{compass});
        }
    }

    public SettingsDatabase getSettingsDatabase() {
        return this.settingsDatabase;
    }

    @Override
    public PlayerSettings getSettings(Player player) {
        return this.playerSettings.get(player.getUniqueId());
    }

    public void loadPlayerSettings(Player player) {
        try {
            this.playerSettings.put(player.getUniqueId(), this.settingsDatabase.getPlayerSettings(player.getUniqueId()));
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Could not load player settings for " + player.getName(), e);
            this.playerSettings.put(player.getUniqueId(), new PlayerSettings(this, player.getUniqueId()));
        }
    }

    public void removeLoadedPlayerSettings(Player player) {
        this.playerSettings.remove(player.getUniqueId());
    }

    public void handleSettingsInventoryClick(Inventory inventory, Player p, int slot) {
        if (slot == 20) {
            this.openChatSettingsInventoryOnPlayer(p);
        }
        if (slot == 22) {
            this.openSoundsSettingsInventoryOnPlayer(p);
        }
        if (slot == 24) {
            this.openAllgemeinSettingsInventoryOnPlayer(p);
        }
    }

    public void handleSettingsChatInventoryClick(Inventory inventory, Player p, int slot) {
        if (slot == 0) {
            this.openSettingsInventoryOnPlayer(p);
            return;
        }
        PlayerSettings ps = this.getSettings(p);
        if (slot == 10 || slot == 19) {
            ps.setShowPublicChat(this.nextYesNoNotInGames(ps.getShowPublicChat()));
            this.updateShowPublicChatItems(inventory, ps);
        }
        if (slot == 12 || slot == 21) {
            ps.setShowJoinAndQuitMessages(this.nextYesNoNotInGames(ps.getShowJoinAndQuitMessages()));
            this.updateShowJoinQuitMessages(inventory, ps);
        }
        if (slot == 14 || slot == 23) {
            ps.setShowPrivateMessages(!ps.getShowPrivateMessages());
            this.updateShowPrivateMessages(inventory, ps);
        }
        if (slot == 16 || slot == 25) {
            ps.setShowNewsticker(this.nextYesNoNotInGames(ps.getShowNewsticker()));
            this.updateShowNewsticker(inventory, ps);
        }
    }

    public void handleSettingsSoundsInventoryClick(Inventory inventory, Player p, int slot) {
        if (slot == 0) {
            this.openSettingsInventoryOnPlayer(p);
            return;
        }
        PlayerSettings ps = this.getSettings(p);
        if (slot == 10 || slot == 19) {
            ps.setSoundOnPrivateMessage(this.nextYesNoNotInGames(ps.getSoundOnPrivateMessage()));
            this.updateSoundOnPrivateMessageItems(inventory, ps);
        }
        if (slot == 12 || slot == 21) {
            ps.setSoundOnReference(this.nextYesNoNotInGames(ps.getSoundOnReference()));
            this.updateSoundOnReferenceMessagesItems(inventory, ps);
        }
    }

    public void handleAllgemeinesInventoryClick(Inventory inventory, Player p, int slot) {
        if (slot == 0) {
            this.openSettingsInventoryOnPlayer(p);
            return;
        }
        PlayerSettings ps = this.getSettings(p);
        if (slot == 10 || slot == 19) {
            ps.setShowCompassInSurvival(!ps.getShowCompassInSurvival());
            this.updateAllgemeinesShowCompassInSurvivalItems(inventory, ps);
        }
    }
}

