/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubeConomy.commands.money;

import de.iani.cubeConomy.CubeConomy;
import de.iani.cubeConomy.commands.ArgsParser;
import de.iani.cubeConomy.commands.SubCommand;
import de.iani.playerUUIDCache.CachedPlayer;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class MoneyTopCommand
extends SubCommand {
    private CubeConomy plugin;

    public MoneyTopCommand(CubeConomy plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getUsage() {
        return "[count]";
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) {
        LinkedHashMap<UUID, Double> accounts;
        int count = args.getNext(5);
        if (count < 0 || count > 20) {
            count = 5;
        }
        try {
            accounts = this.plugin.getPluginDatabase().listTop(0, count);
        }
        catch (SQLException e1) {
            sender.sendMessage(CubeConomy.MESSAGE_PREFIX + ChatColor.RED + "Database error");
            return true;
        }
        sender.sendMessage(ChatColor.DARK_GREEN + "-----[ " + ChatColor.WHITE + "Wealthiest Accounts " + ChatColor.DARK_GREEN + "]-----");
        int nr = 1;
        for (Map.Entry<UUID, Double> e : accounts.entrySet()) {
            CachedPlayer p = this.plugin.getPlayerUUIDCache().getPlayer(e.getKey(), true);
            sender.sendMessage(ChatColor.DARK_GRAY.toString() + nr++ + ". " + ChatColor.DARK_GREEN + (p != null ? p.getName() : (Serializable)e.getKey()) + ChatColor.DARK_GRAY + " - " + ChatColor.WHITE + this.plugin.formatMoney(e.getValue()));
        }
        return true;
    }

    @Override
    public ArrayList<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        return new ArrayList<String>();
    }
}

