/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.blockstate.BlockStateCodecs;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class WorldEditLoggingHook {
    private LogBlock plugin;

    public WorldEditLoggingHook(LogBlock plugin) {
        this.plugin = plugin;
    }

    private Actor AtoA(com.sk89q.worldedit.extension.platform.Actor weActor) {
        if (weActor.isPlayer()) {
            return new Actor(weActor.getName(), weActor.getUniqueId());
        }
        return new Actor(weActor.getName());
    }

    public void hook() {
        WorldEdit.getInstance().getEventBus().register(new Object(){

            @Subscribe
            public void wrapForLogging(final EditSessionEvent event) {
                org.bukkit.World world;
                com.sk89q.worldedit.extension.platform.Actor actor = event.getActor();
                if (actor == null) {
                    return;
                }
                final Actor lbActor = WorldEditLoggingHook.this.AtoA(actor);
                try {
                    world = BukkitAdapter.adapt((World)event.getWorld());
                }
                catch (RuntimeException ex) {
                    WorldEditLoggingHook.this.plugin.getLogger().warning("Failed to register logging for WorldEdit!");
                    WorldEditLoggingHook.this.plugin.getLogger().log(Level.WARNING, ex.getMessage(), ex);
                    return;
                }
                if (!Config.isLogging(world, Logging.WORLDEDIT)) {
                    return;
                }
                event.setExtent((Extent)new AbstractDelegateExtent(event.getExtent()){

                    public final <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block) throws WorldEditException {
                        this.onBlockChange(position, block);
                        return super.setBlock(position, block);
                    }

                    protected <B extends BlockStateHolder<B>> void onBlockChange(BlockVector3 pt, B block) {
                        if (event.getStage() != EditSession.Stage.BEFORE_CHANGE) {
                            return;
                        }
                        Location location = BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)pt);
                        Block blockBefore = location.getBlock();
                        BlockData blockDataBefore = blockBefore.getBlockData();
                        Material typeBefore = blockDataBefore.getMaterial();
                        BlockData blockDataNew = BukkitAdapter.adapt(block);
                        if (!blockDataBefore.equals((Object)blockDataNew)) {
                            if (BlockStateCodecs.hasCodec(typeBefore)) {
                                WorldEditLoggingHook.this.plugin.getConsumer().queueBlockBreak(lbActor, blockBefore.getState());
                            } else if (!BukkitUtils.isEmpty(typeBefore)) {
                                WorldEditLoggingHook.this.plugin.getConsumer().queueBlockBreak(lbActor, location, blockDataBefore);
                            }
                            if (!BukkitUtils.isEmpty(blockDataNew.getMaterial())) {
                                WorldEditLoggingHook.this.plugin.getConsumer().queueBlockPlace(lbActor, location, blockDataNew);
                            }
                        }
                    }
                });
            }
        });
    }
}

