/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.util.LoggingUtil;
import de.diddiz.LogBlock.util.MessagingUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;

public class ChatMessage
implements LookupCacheElement {
    final long id;
    final long date;
    final String playerName;
    final String message;
    final Actor player;

    public ChatMessage(Actor player, String message) {
        this.id = 0L;
        this.date = System.currentTimeMillis() / 1000L;
        this.player = player;
        this.message = LoggingUtil.checkText(message);
        this.playerName = player == null ? null : player.getName();
    }

    public ChatMessage(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? rs.getInt("id") : 0;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.player = p.needPlayer ? new Actor(rs) : null;
        this.playerName = p.needPlayer ? rs.getString("playername") : null;
        this.message = p.needMessage ? rs.getString("message") : null;
    }

    @Override
    public Location getLocation() {
        return null;
    }

    @Override
    public BaseComponent[] getLogMessage(int entry) {
        TextComponent msg = new TextComponent();
        if (this.date > 0L) {
            msg.addExtra((BaseComponent)MessagingUtil.prettyDate(this.date));
            msg.addExtra(" ");
        }
        if (this.playerName != null) {
            msg.addExtra((BaseComponent)MessagingUtil.brackets(MessagingUtil.BracketType.ANGLE, new BaseComponent[]{MessagingUtil.createTextComponentWithColor(this.playerName, ChatColor.WHITE)}));
            msg.addExtra(" ");
        }
        if (this.message != null) {
            BaseComponent[] baseComponentArray = TextComponent.fromLegacyText((String)this.message);
            int n = baseComponentArray.length;
            int n2 = 0;
            while (n2 < n) {
                BaseComponent messageComponent = baseComponentArray[n2];
                msg.addExtra(messageComponent);
                ++n2;
            }
        }
        return new BaseComponent[]{msg};
    }
}

