/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Updater;
import de.diddiz.LogBlock.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RandomLoadGenerator
implements Runnable {
    private LogBlock logBlock;
    private Updater.MaterialUpdater1_13 materials;
    private ArrayList<UUID> actorIDs;

    public RandomLoadGenerator(LogBlock logBlock) {
        this.logBlock = logBlock;
        try {
            this.materials = new Updater.MaterialUpdater1_13(logBlock);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.actorIDs = new ArrayList();
        for (int i = 0; i < 300; ++i) {
            this.actorIDs.add(UUID.randomUUID());
        }
        logBlock.getServer().getScheduler().runTaskTimer((Plugin)logBlock, (Runnable)this, 1L, 1L);
    }

    @Override
    public void run() {
        Consumer consumer = this.logBlock.getConsumer();
        Random random = new Random();
        World world = (World)this.logBlock.getServer().getWorlds().get(0);
        if (!Config.isLogged(world)) {
            return;
        }
        for (int i = 0; i < 400; ++i) {
            BlockData first = this.selectRandomMaterial(random);
            BlockData second = this.selectRandomMaterial(random);
            Location loc = this.getRandomLocation(random, world);
            Actor actor = new Actor(Long.toString(random.nextLong()), this.actorIDs.get(random.nextInt(this.actorIDs.size())));
            int type = random.nextInt(16);
            if (type < 5) {
                consumer.queueBlockBreak(actor, loc, first);
                continue;
            }
            if (type < 10) {
                consumer.queueBlockPlace(actor, loc, first);
                continue;
            }
            if (type <= 12) {
                consumer.queueBlockReplace(actor, loc, first, second);
                continue;
            }
            if (type == 13) continue;
            if (type == 14) {
                consumer.queueChestAccess(actor, loc, first, new ItemStack(Material.STONE, random.nextInt(100)), random.nextBoolean());
                continue;
            }
            if (type != 15) continue;
            consumer.queueChat(actor, Long.toString(random.nextLong()));
        }
    }

    private Location getRandomLocation(Random random, World world) {
        int x = random.nextInt(500) - 250;
        int y = random.nextInt(200);
        int z = random.nextInt(500) - 250;
        return new Location(world, (double)x, (double)y, (double)z);
    }

    private BlockData selectRandomMaterial(Random random) {
        int data;
        int type;
        BlockData bd;
        while ((bd = this.materials.getBlockData(type = random.nextInt(256), data = random.nextInt(16))) == null) {
        }
        return bd;
    }
}

