/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.CommandsHandler;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Session;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.ToolBehavior;
import de.diddiz.LogBlock.ToolData;
import de.diddiz.LogBlock.ToolMode;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import de.diddiz.worldedit.CuboidRegion;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ToolListener
implements Listener {
    private final CommandsHandler handler;
    private final LogBlock logblock;

    public ToolListener(LogBlock logblock) {
        this.logblock = logblock;
        this.handler = logblock.getCommandsHandler();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getMaterial() != null) {
            Action action = event.getAction();
            Material type = event.getMaterial();
            Tool tool = Config.toolsByType.get(type);
            Player player = event.getPlayer();
            if (tool != null && (action == Action.RIGHT_CLICK_BLOCK || action == Action.LEFT_CLICK_BLOCK) && this.logblock.hasPermission((CommandSender)player, "logblock.tools." + tool.name)) {
                ToolBehavior behavior = action == Action.RIGHT_CLICK_BLOCK ? tool.rightClickBehavior : tool.leftClickBehavior;
                ToolData toolData = Session.getSession((CommandSender)player).toolData.get(tool);
                if (behavior != ToolBehavior.NONE && toolData.enabled) {
                    if (!Config.isLogged(player.getWorld())) {
                        player.sendMessage(ChatColor.RED + "This world is not currently logged.");
                        event.setCancelled(true);
                        return;
                    }
                    Block block = event.getClickedBlock();
                    QueryParams params = toolData.params.clone();
                    params.loc = null;
                    params.sel = null;
                    if (behavior == ToolBehavior.BLOCK) {
                        params.setLocation(block.getRelative(event.getBlockFace()).getLocation());
                    } else if (tool.params.radius != 0) {
                        params.setLocation(block.getLocation());
                    } else {
                        Block otherHalfChest = BukkitUtils.getConnectedChest(block);
                        if (otherHalfChest == null) {
                            params.setLocation(block.getLocation());
                        } else {
                            params.setSelection(CuboidRegion.fromCorners(block.getLocation().getWorld(), block.getLocation(), otherHalfChest.getLocation()));
                        }
                    }
                    try {
                        params.validate();
                        if (toolData.mode == ToolMode.ROLLBACK) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandRollback((CommandSender)player, params, true);
                        } else if (toolData.mode == ToolMode.REDO) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandRedo((CommandSender)player, params, true);
                        } else if (toolData.mode == ToolMode.CLEARLOG) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandClearLog((CommandSender)player, params, true);
                        } else if (toolData.mode == ToolMode.WRITELOGFILE) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandWriteLogFile((CommandSender)player, params, true);
                        } else {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandLookup((CommandSender)player, params, true);
                        }
                    }
                    catch (Exception ex) {
                        player.sendMessage(ChatColor.RED + ex.getMessage());
                    }
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (Session.hasSession((CommandSender)player)) {
            Session session = Session.getSession((CommandSender)player);
            for (Map.Entry<Tool, ToolData> entry : session.toolData.entrySet()) {
                Tool tool = entry.getKey();
                ToolData toolData = entry.getValue();
                if (!toolData.enabled || this.logblock.hasPermission((CommandSender)player, "logblock.tools." + tool.name)) continue;
                toolData.enabled = false;
                if (tool.removeOnDisable && this.logblock.hasPermission((CommandSender)player, "logblock.spawnTools")) {
                    player.getInventory().removeItem(new ItemStack[]{new ItemStack(tool.item, 1)});
                }
                player.sendMessage(ChatColor.GREEN + "Tool disabled.");
            }
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (Session.hasSession((CommandSender)player)) {
            Session session = Session.getSession((CommandSender)player);
            for (Map.Entry<Tool, ToolData> entry : session.toolData.entrySet()) {
                Tool tool = entry.getKey();
                ToolData toolData = entry.getValue();
                Material item = event.getItemDrop().getItemStack().getType();
                if (item != tool.item || !toolData.enabled) continue;
                if (tool.dropToDisable) {
                    toolData.enabled = false;
                    ItemStack stack = event.getItemDrop().getItemStack();
                    if (tool.removeOnDisable && this.logblock.hasPermission((CommandSender)player, "logblock.spawnTools") && stack.isSimilar(new ItemStack(item))) {
                        if (stack.getAmount() > 1) {
                            stack.setAmount(stack.getAmount() - 1);
                            event.getItemDrop().setItemStack(stack);
                        } else {
                            event.getItemDrop().remove();
                        }
                    }
                    if (BukkitUtils.hasInventoryStorageSpaceFor((Inventory)player.getInventory(), stack)) {
                        event.setCancelled(true);
                    }
                    player.sendMessage(ChatColor.GREEN + "Tool disabled.");
                    continue;
                }
                if (tool.canDrop) continue;
                player.sendMessage(ChatColor.RED + "You cannot drop this tool.");
                event.setCancelled(true);
            }
        }
    }
}

