/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.config;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.ToolBehavior;
import de.diddiz.LogBlock.ToolMode;
import de.diddiz.LogBlock.config.EntityLogging;
import de.diddiz.LogBlock.config.LoggingEnabledMapping;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.ComparableVersion;
import de.diddiz.util.Utils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.DataFormatException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.permissions.PermissionDefault;

public class Config {
    private static LoggingEnabledMapping superWorldConfig;
    private static Map<String, WorldConfig> worldConfigs;
    public static String url;
    public static String user;
    public static String password;
    public static int delayBetweenRuns;
    public static int forceToProcessAtLeast;
    public static int timePerRun;
    public static boolean fireCustomEvents;
    public static boolean useBukkitScheduler;
    public static int queueWarningSize;
    public static boolean enableAutoClearLog;
    public static List<String> autoClearLog;
    public static int autoClearLogDelay;
    public static boolean dumpDeletedLog;
    public static boolean logBedExplosionsAsPlayerWhoTriggeredThese;
    public static boolean logCreeperExplosionsAsPlayerWhoTriggeredThese;
    public static boolean logPlayerInfo;
    public static boolean logFireSpreadAsPlayerWhoCreatedIt;
    public static boolean logFluidFlowAsPlayerWhoTriggeredIt;
    public static LogKillsLevel logKillsLevel;
    public static Set<Material> dontRollback;
    public static Set<Material> replaceAnyway;
    public static int rollbackMaxTime;
    public static int rollbackMaxArea;
    public static Map<String, Tool> toolsByName;
    public static Map<Material, Tool> toolsByType;
    public static int defaultDist;
    public static int defaultTime;
    public static int linesPerPage;
    public static int linesLimit;
    public static int hardLinesLimit;
    public static boolean askRollbacks;
    public static boolean askRedos;
    public static boolean askClearLogs;
    public static boolean askClearLogAfterRollback;
    public static boolean askRollbackAfterBan;
    public static String banPermission;
    public static Set<Material> hiddenBlocks;
    public static Set<String> hiddenPlayers;
    public static List<String> ignoredChat;
    public static SimpleDateFormat formatter;
    public static boolean safetyIdCheck;
    public static boolean debug;
    public static boolean logEnvironmentalKills;
    public static boolean mb4;

    static {
        mb4 = false;
    }

    public static void load(LogBlock logblock) throws DataFormatException, IOException {
        Material mat;
        FileConfiguration config = logblock.getConfig();
        HashMap<String, Object> def = new HashMap<String, Object>();
        def.put("version", logblock.getDescription().getVersion());
        ArrayList<String> worldNames = new ArrayList<String>();
        for (World world : Bukkit.getWorlds()) {
            worldNames.add(world.getName());
        }
        if (worldNames.isEmpty()) {
            worldNames.add("world");
            worldNames.add("world_nether");
            worldNames.add("world_the_end");
        }
        def.put("loggedWorlds", worldNames);
        def.put("mysql.host", "localhost");
        def.put("mysql.port", 3306);
        def.put("mysql.database", "minecraft");
        def.put("mysql.user", "username");
        def.put("mysql.password", "pass");
        def.put("consumer.delayBetweenRuns", 2);
        def.put("consumer.forceToProcessAtLeast", 200);
        def.put("consumer.timePerRun", 1000);
        def.put("consumer.fireCustomEvents", false);
        def.put("consumer.useBukkitScheduler", true);
        def.put("consumer.queueWarningSize", 1000);
        def.put("clearlog.dumpDeletedLog", false);
        def.put("clearlog.enableAutoClearLog", false);
        ArrayList<String> autoClearlog = new ArrayList<String>();
        for (String string : worldNames) {
            autoClearlog.add("world \"" + string + "\" before 365 days all");
            autoClearlog.add("world \"" + string + "\" player lavaflow waterflow leavesdecay before 7 days all");
            autoClearlog.add("world \"" + string + "\" entities before 365 days");
        }
        def.put("clearlog.auto", autoClearlog);
        def.put("clearlog.autoClearLogDelay", "6h");
        def.put("logging.logBedExplosionsAsPlayerWhoTriggeredThese", true);
        def.put("logging.logCreeperExplosionsAsPlayerWhoTriggeredThese", false);
        def.put("logging.logFireSpreadAsPlayerWhoCreatedIt", true);
        def.put("logging.logFluidFlowAsPlayerWhoTriggeredIt", false);
        def.put("logging.logKillsLevel", "PLAYERS");
        def.put("logging.logEnvironmentalKills", false);
        def.put("logging.logPlayerInfo", false);
        def.put("logging.hiddenPlayers", new ArrayList());
        def.put("logging.hiddenBlocks", Arrays.asList(Material.AIR.name(), Material.CAVE_AIR.name(), Material.VOID_AIR.name()));
        def.put("logging.ignoredChat", Arrays.asList("/register", "/login"));
        def.put("rollback.dontRollback", Arrays.asList(Material.LAVA.name(), Material.TNT.name(), Material.FIRE.name()));
        def.put("rollback.replaceAnyway", Arrays.asList(Material.LAVA.name(), Material.WATER.name(), Material.FIRE.name(), Material.GRASS_BLOCK.name()));
        def.put("rollback.maxTime", "2 days");
        def.put("rollback.maxArea", 50);
        def.put("lookup.defaultDist", 20);
        def.put("lookup.defaultTime", "30 minutes");
        def.put("lookup.linesPerPage", 15);
        def.put("lookup.linesLimit", 1500);
        def.put("lookup.hardLinesLimit", 100000);
        try {
            formatter = new SimpleDateFormat(config.getString("lookup.dateFormat", "MM-dd HH:mm:ss"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataFormatException("Invalid specification for  date format, please see http://docs.oracle.com/javase/1.4.2/docs/api/java/text/SimpleDateFormat.html : " + illegalArgumentException.getMessage());
        }
        def.put("lookup.dateFormat", "MM-dd HH:mm:ss");
        def.put("questioner.askRollbacks", true);
        def.put("questioner.askRedos", true);
        def.put("questioner.askClearLogs", true);
        def.put("questioner.askClearLogAfterRollback", true);
        def.put("questioner.askRollbackAfterBan", false);
        def.put("questioner.banPermission", "mcbans.ban.local");
        def.put("tools.tool.aliases", Arrays.asList("t"));
        def.put("tools.tool.leftClickBehavior", "NONE");
        def.put("tools.tool.rightClickBehavior", "TOOL");
        def.put("tools.tool.defaultEnabled", true);
        def.put("tools.tool.item", Material.WOODEN_PICKAXE.name());
        def.put("tools.tool.canDrop", true);
        def.put("tools.tool.removeOnDisable", true);
        def.put("tools.tool.dropToDisable", false);
        def.put("tools.tool.params", "area 0 all sum none limit 15 desc since 60d silent");
        def.put("tools.tool.mode", "LOOKUP");
        def.put("tools.tool.permissionDefault", "OP");
        def.put("tools.toolblock.aliases", Arrays.asList("tb"));
        def.put("tools.toolblock.leftClickBehavior", "TOOL");
        def.put("tools.toolblock.rightClickBehavior", "BLOCK");
        def.put("tools.toolblock.defaultEnabled", true);
        def.put("tools.toolblock.item", Material.BEDROCK.name());
        def.put("tools.toolblock.canDrop", false);
        def.put("tools.toolblock.removeOnDisable", true);
        def.put("tools.toolblock.dropToDisable", false);
        def.put("tools.toolblock.params", "area 0 all sum none limit 15 desc since 60d silent");
        def.put("tools.toolblock.mode", "LOOKUP");
        def.put("tools.toolblock.permissionDefault", "OP");
        def.put("safety.id.check", true);
        def.put("debug", false);
        for (Map.Entry entry : def.entrySet()) {
            if (config.contains((String)entry.getKey())) continue;
            config.set((String)entry.getKey(), entry.getValue());
        }
        logblock.saveConfig();
        ComparableVersion comparableVersion = new ComparableVersion(config.getString("version"));
        boolean oldConfig = comparableVersion.compareTo(new ComparableVersion(logblock.getDescription().getVersion().replace(" (manually compiled)", ""))) < 0;
        url = "jdbc:mysql://" + config.getString("mysql.host") + ":" + config.getInt("mysql.port") + "/" + Config.getStringIncludingInts((ConfigurationSection)config, "mysql.database");
        user = Config.getStringIncludingInts((ConfigurationSection)config, "mysql.user");
        password = Config.getStringIncludingInts((ConfigurationSection)config, "mysql.password");
        delayBetweenRuns = config.getInt("consumer.delayBetweenRuns", 2);
        forceToProcessAtLeast = config.getInt("consumer.forceToProcessAtLeast", 0);
        timePerRun = config.getInt("consumer.timePerRun", 1000);
        fireCustomEvents = config.getBoolean("consumer.fireCustomEvents", false);
        useBukkitScheduler = config.getBoolean("consumer.useBukkitScheduler", true);
        queueWarningSize = config.getInt("consumer.queueWarningSize", 1000);
        enableAutoClearLog = config.getBoolean("clearlog.enableAutoClearLog");
        autoClearLog = config.getStringList("clearlog.auto");
        dumpDeletedLog = config.getBoolean("clearlog.dumpDeletedLog", false);
        autoClearLogDelay = Utils.parseTimeSpec(config.getString("clearlog.autoClearLogDelay").split(" "));
        logBedExplosionsAsPlayerWhoTriggeredThese = config.getBoolean("logging.logBedExplosionsAsPlayerWhoTriggeredThese", true);
        logCreeperExplosionsAsPlayerWhoTriggeredThese = config.getBoolean("logging.logCreeperExplosionsAsPlayerWhoTriggeredThese", false);
        logFireSpreadAsPlayerWhoCreatedIt = config.getBoolean("logging.logFireSpreadAsPlayerWhoCreatedIt", true);
        logFluidFlowAsPlayerWhoTriggeredIt = config.getBoolean("logging.logFluidFlowAsPlayerWhoTriggeredIt", false);
        logPlayerInfo = config.getBoolean("logging.logPlayerInfo", true);
        try {
            logKillsLevel = LogKillsLevel.valueOf(config.getString("logging.logKillsLevel").toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new DataFormatException("logging.logKillsLevel doesn't appear to be a valid log level. Allowed are 'PLAYERS', 'MONSTERS' and 'ANIMALS'");
        }
        logEnvironmentalKills = config.getBoolean("logging.logEnvironmentalKills", false);
        hiddenPlayers = new HashSet<String>();
        for (String playerName : config.getStringList("logging.hiddenPlayers")) {
            hiddenPlayers.add(playerName.toLowerCase().trim());
        }
        hiddenBlocks = new HashSet<Material>();
        for (String blocktype : config.getStringList("logging.hiddenBlocks")) {
            mat = Material.matchMaterial((String)blocktype);
            if (mat != null) {
                hiddenBlocks.add(mat);
                continue;
            }
            if (oldConfig) continue;
            throw new DataFormatException("Not a valid material in hiddenBlocks: '" + blocktype + "'");
        }
        ignoredChat = new ArrayList<String>();
        for (String chatCommand : config.getStringList("logging.ignoredChat")) {
            ignoredChat.add(chatCommand.toLowerCase());
        }
        dontRollback = new HashSet<Material>();
        for (String e : config.getStringList("rollback.dontRollback")) {
            mat = Material.matchMaterial((String)e);
            if (mat != null) {
                dontRollback.add(mat);
                continue;
            }
            if (oldConfig) continue;
            throw new DataFormatException("Not a valid material in dontRollback: '" + e + "'");
        }
        replaceAnyway = new HashSet<Material>();
        for (String e : config.getStringList("rollback.replaceAnyway")) {
            mat = Material.matchMaterial((String)e);
            if (mat != null) {
                replaceAnyway.add(mat);
                continue;
            }
            if (oldConfig) continue;
            throw new DataFormatException("Not a valid material in replaceAnyway: '" + e + "'");
        }
        rollbackMaxTime = Utils.parseTimeSpec(config.getString("rollback.maxTime").split(" "));
        rollbackMaxArea = config.getInt("rollback.maxArea", 50);
        defaultDist = config.getInt("lookup.defaultDist", 20);
        defaultTime = Utils.parseTimeSpec(config.getString("lookup.defaultTime").split(" "));
        linesPerPage = config.getInt("lookup.linesPerPage", 15);
        linesLimit = config.getInt("lookup.linesLimit", 1500);
        hardLinesLimit = config.getInt("lookup.hardLinesLimit", 100000);
        askRollbacks = config.getBoolean("questioner.askRollbacks", true);
        askRedos = config.getBoolean("questioner.askRedos", true);
        askClearLogs = config.getBoolean("questioner.askClearLogs", true);
        askClearLogAfterRollback = config.getBoolean("questioner.askClearLogAfterRollback", true);
        askRollbackAfterBan = config.getBoolean("questioner.askRollbackAfterBan", false);
        safetyIdCheck = config.getBoolean("safety.id.check", true);
        debug = config.getBoolean("debug", false);
        banPermission = config.getString("questioner.banPermission");
        ArrayList<Tool> tools = new ArrayList<Tool>();
        ConfigurationSection toolsSec = config.getConfigurationSection("tools");
        for (String toolName : toolsSec.getKeys(false)) {
            try {
                ConfigurationSection tSec = toolsSec.getConfigurationSection(toolName);
                List aliases = tSec.getStringList("aliases");
                ToolBehavior leftClickBehavior = ToolBehavior.valueOf(tSec.getString("leftClickBehavior").toUpperCase());
                ToolBehavior rightClickBehavior = ToolBehavior.valueOf(tSec.getString("rightClickBehavior").toUpperCase());
                boolean defaultEnabled = tSec.getBoolean("defaultEnabled", false);
                Material item = Material.matchMaterial((String)tSec.getString("item", "OAK_LOG"));
                boolean canDrop = tSec.getBoolean("canDrop", false);
                boolean removeOnDisable = tSec.getBoolean("removeOnDisable", true);
                boolean dropToDisable = tSec.getBoolean("dropToDisable", false);
                QueryParams params = new QueryParams(logblock);
                params.prepareToolQuery = true;
                params.parseArgs((CommandSender)Bukkit.getConsoleSender(), Arrays.asList(tSec.getString("params").split(" ")), false);
                ToolMode mode = ToolMode.valueOf(tSec.getString("mode").toUpperCase());
                PermissionDefault pdef = PermissionDefault.valueOf((String)tSec.getString("permissionDefault").toUpperCase());
                tools.add(new Tool(toolName, aliases, leftClickBehavior, rightClickBehavior, defaultEnabled, item, canDrop, params, mode, pdef, removeOnDisable, dropToDisable));
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error at parsing tool '" + toolName + "': ", ex);
            }
        }
        toolsByName = new HashMap<String, Tool>();
        toolsByType = new HashMap<Material, Tool>();
        for (Tool tool : tools) {
            toolsByType.put(tool.item, tool);
            toolsByName.put(tool.name.toLowerCase(), tool);
            for (String alias : tool.aliases) {
                toolsByName.put(alias, tool);
            }
        }
        List loggedWorlds = config.getStringList("loggedWorlds");
        worldConfigs = new HashMap<String, WorldConfig>();
        if (loggedWorlds.isEmpty()) {
            throw new DataFormatException("No worlds configured");
        }
        for (String world : loggedWorlds) {
            worldConfigs.put(world, new WorldConfig(world, new File(logblock.getDataFolder(), String.valueOf(BukkitUtils.friendlyWorldname(world)) + ".yml")));
        }
        superWorldConfig = new LoggingEnabledMapping();
        for (WorldConfig wcfg : worldConfigs.values()) {
            Logging[] loggingArray = Logging.values();
            int n = loggingArray.length;
            int n2 = 0;
            while (n2 < n) {
                Logging l = loggingArray[n2];
                if (wcfg.isLogging(l)) {
                    superWorldConfig.setLogging(l, true);
                }
                ++n2;
            }
        }
    }

    private static String getStringIncludingInts(ConfigurationSection cfg, String key) {
        String str = cfg.getString(key);
        if (str == null) {
            str = String.valueOf(cfg.getInt(key));
        }
        if (str == null) {
            str = "No value set for '" + key + "'";
        }
        return str;
    }

    public static boolean isLogging(World world, Logging l) {
        WorldConfig wcfg = worldConfigs.get(world.getName());
        return wcfg != null && wcfg.isLogging(l);
    }

    public static boolean isLogging(String worldName, Logging l) {
        WorldConfig wcfg = worldConfigs.get(worldName);
        return wcfg != null && wcfg.isLogging(l);
    }

    public static boolean isLogged(World world) {
        return worldConfigs.containsKey(world.getName());
    }

    public static WorldConfig getWorldConfig(World world) {
        return worldConfigs.get(world.getName());
    }

    public static WorldConfig getWorldConfig(String world) {
        return worldConfigs.get(world);
    }

    public static boolean isLogging(Logging l) {
        return superWorldConfig.isLogging(l);
    }

    public static Collection<WorldConfig> getLoggedWorlds() {
        return worldConfigs.values();
    }

    public static boolean isLogging(World world, EntityLogging logging, Entity entity) {
        WorldConfig wcfg = worldConfigs.get(world.getName());
        return wcfg != null && wcfg.isLogging(logging, entity);
    }

    public static boolean isLoggingAnyEntities() {
        for (WorldConfig worldConfig : worldConfigs.values()) {
            if (!worldConfig.isLoggingAnyEntities()) continue;
            return true;
        }
        return false;
    }

    public static enum LogKillsLevel {
        PLAYERS,
        MONSTERS,
        ANIMALS;

    }
}

