/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSign;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.ComparableVersion;
import de.diddiz.util.UUIDFetcher;
import de.diddiz.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

class Updater {
    private final LogBlock logblock;
    final int UUID_CONVERT_BATCH_SIZE = 100;
    final int BLOCKS_CONVERT_BATCH_SIZE = 100000;
    final int OTHER_CONVERT_BATCH_SIZE = 20000;

    Updater(LogBlock logblock) {
        this.logblock = logblock;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    boolean update() {
        config = this.logblock.getConfig();
        versionString = config.getString("version");
        if (Pattern.matches("1\\.\\d{2}", versionString)) {
            versionString = "1." + versionString.charAt(2) + "." + versionString.charAt(3);
            config.set("version", (Object)versionString);
            this.logblock.saveConfig();
        }
        if ((configVersion = new ComparableVersion(versionString)).compareTo(new ComparableVersion("1.2.7")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.2.7 ...");
            if (Config.isLogging(Logging.CHAT)) {
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-chat` ADD FULLTEXT message (message)");
                    st.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            config.set("version", (Object)"1.2.7");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3")) < 0) {
            this.logblock.getLogger().info("Updating config to 1.3.0 ...");
            for (String tool : config.getConfigurationSection("tools").getKeys(false)) {
                if (config.get("tools." + tool + ".permissionDefault") != null) continue;
                config.set("tools." + tool + ".permissionDefault", (Object)"OP");
            }
            config.set("version", (Object)"1.3.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.3.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.execute("ALTER TABLE `lb-players` ADD COLUMN lastlogin DATETIME NOT NULL, ADD COLUMN onlinetime TIME NOT NULL, ADD COLUMN ip VARCHAR(255) NOT NULL");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.3.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3.2")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.3.2 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.execute("ALTER TABLE `lb-players` ADD COLUMN firstlogin DATETIME NOT NULL AFTER playername");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.3.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.4")) < 0) {
            this.logblock.getLogger().info("Updating config to 1.4.0 ...");
            config.set("clearlog.keepLogDays", null);
            config.set("version", (Object)"1.4.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.4.2")) < 0) {
            this.logblock.getLogger().info("Updating config to 1.4.2 ...");
            for (String world : config.getStringList("loggedWorlds")) {
                file = new File(this.logblock.getDataFolder(), String.valueOf(BukkitUtils.friendlyWorldname(world)) + ".yml");
                wcfg = YamlConfiguration.loadConfiguration((File)file);
                if (wcfg.contains("logBlockCreations")) {
                    wcfg.set("logging.BLOCKPLACE", (Object)wcfg.getBoolean("logBlockCreations"));
                }
                if (wcfg.contains("logBlockDestroyings")) {
                    wcfg.set("logging.BLOCKBREAK", (Object)wcfg.getBoolean("logBlockDestroyings"));
                }
                if (wcfg.contains("logSignTexts")) {
                    wcfg.set("logging.SIGNTEXT", (Object)wcfg.getBoolean("logSignTexts"));
                }
                if (wcfg.contains("logFire")) {
                    wcfg.set("logging.FIRE", (Object)wcfg.getBoolean("logFire"));
                }
                if (wcfg.contains("logLeavesDecay")) {
                    wcfg.set("logging.LEAVESDECAY", (Object)wcfg.getBoolean("logLeavesDecay"));
                }
                if (wcfg.contains("logLavaFlow")) {
                    wcfg.set("logging.LAVAFLOW", (Object)wcfg.getBoolean("logLavaFlow"));
                }
                if (wcfg.contains("logWaterFlow")) {
                    wcfg.set("logging.WATERFLOW", (Object)wcfg.getBoolean("logWaterFlow"));
                }
                if (wcfg.contains("logChestAccess")) {
                    wcfg.set("logging.CHESTACCESS", (Object)wcfg.getBoolean("logChestAccess"));
                }
                if (wcfg.contains("logButtonsAndLevers")) {
                    wcfg.set("logging.SWITCHINTERACT", (Object)wcfg.getBoolean("logButtonsAndLevers"));
                }
                if (wcfg.contains("logKills")) {
                    wcfg.set("logging.KILL", (Object)wcfg.getBoolean("logKills"));
                }
                if (wcfg.contains("logChat")) {
                    wcfg.set("logging.CHAT", (Object)wcfg.getBoolean("logChat"));
                }
                if (wcfg.contains("logSnowForm")) {
                    wcfg.set("logging.SNOWFORM", (Object)wcfg.getBoolean("logSnowForm"));
                }
                if (wcfg.contains("logSnowFade")) {
                    wcfg.set("logging.SNOWFADE", (Object)wcfg.getBoolean("logSnowFade"));
                }
                if (wcfg.contains("logDoors")) {
                    wcfg.set("logging.DOORINTERACT", (Object)wcfg.getBoolean("logDoors"));
                }
                if (wcfg.contains("logCakes")) {
                    wcfg.set("logging.CAKEEAT", (Object)wcfg.getBoolean("logCakes"));
                }
                if (wcfg.contains("logEndermen")) {
                    wcfg.set("logging.ENDERMEN", (Object)wcfg.getBoolean("logEndermen"));
                }
                if (wcfg.contains("logExplosions")) {
                    logExplosions = wcfg.getBoolean("logExplosions");
                    wcfg.set("logging.TNTEXPLOSION", (Object)logExplosions);
                    wcfg.set("logging.MISCEXPLOSION", (Object)logExplosions);
                    wcfg.set("logging.CREEPEREXPLOSION", (Object)logExplosions);
                    wcfg.set("logging.GHASTFIREBALLEXPLOSION", (Object)logExplosions);
                }
                wcfg.set("logBlockCreations", null);
                wcfg.set("logBlockDestroyings", null);
                wcfg.set("logSignTexts", null);
                wcfg.set("logExplosions", null);
                wcfg.set("logFire", null);
                wcfg.set("logLeavesDecay", null);
                wcfg.set("logLavaFlow", null);
                wcfg.set("logWaterFlow", null);
                wcfg.set("logChestAccess", null);
                wcfg.set("logButtonsAndLevers", null);
                wcfg.set("logKills", null);
                wcfg.set("logChat", null);
                wcfg.set("logSnowForm", null);
                wcfg.set("logSnowFade", null);
                wcfg.set("logDoors", null);
                wcfg.set("logCakes", null);
                wcfg.set("logEndermen", null);
                try {
                    wcfg.save(file);
                }
                catch (IOException ex) {
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                }
            }
            config.set("clearlog.keepLogDays", null);
            config.set("version", (Object)"1.4.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.5.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.5.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    if (!wcfg.isLogging(Logging.KILL)) continue;
                    st.execute("ALTER TABLE `" + wcfg.table + "-kills` ADD (x MEDIUMINT NOT NULL DEFAULT 0, y SMALLINT NOT NULL DEFAULT 0, z MEDIUMINT NOT NULL DEFAULT 0)");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.5.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.5.2")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.5.2 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                rs = st.executeQuery("SHOW COLUMNS FROM `lb-players` WHERE field = 'onlinetime'");
                if (rs.next() && rs.getString("Type").equalsIgnoreCase("time")) {
                    st.execute("ALTER TABLE `lb-players` ADD onlinetime2 INT UNSIGNED NOT NULL");
                    st.execute("UPDATE `lb-players` SET onlinetime2 = HOUR(onlinetime) * 3600 + MINUTE(onlinetime) * 60 + SECOND(onlinetime)");
                    st.execute("ALTER TABLE `lb-players` DROP onlinetime");
                    st.execute("ALTER TABLE `lb-players` CHANGE onlinetime2 onlinetime INT UNSIGNED NOT NULL");
                } else {
                    this.logblock.getLogger().info("Column lb-players was already modified, skipping it.");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.5.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.8.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.8.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    if (!wcfg.isLogging(Logging.CHESTACCESS)) continue;
                    st.execute("ALTER TABLE `" + wcfg.table + "-chest` CHANGE itemdata itemdata SMALLINT NOT NULL");
                    this.logblock.getLogger().info("Table " + wcfg.table + "-chest modified");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.8.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.9")) < 0) {
            block134: {
                this.logblock.getLogger().info("Updating tables to 1.9.0 ...");
                this.logblock.getLogger().info("Importing UUIDs for large databases may take some time");
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-players` ADD `UUID` VARCHAR(36) NOT NULL");
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 1060) break block134;
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            try {
                unimportedPrefix = "noimport_";
                conn.setAutoCommit(true);
                st = conn.createStatement();
                if (config.getBoolean("logging.logPlayerInfo")) {
                    st.execute("UPDATE `lb-players` SET UUID = CONCAT ('log_',playername) WHERE onlinetime=0 AND LENGTH(UUID) = 0");
                } else {
                    unimportedPrefix = "log_";
                }
                rs = st.executeQuery("SELECT COUNT(playername) FROM `lb-players` WHERE LENGTH(UUID)=0");
                rs.next();
                total = Integer.toString(rs.getInt(1));
                this.logblock.getLogger().info(String.valueOf(total) + " players to convert");
                done = 0;
                conn.setAutoCommit(false);
                players = new HashMap<String, Integer>();
                names = new ArrayList<String>(100);
                rs = st.executeQuery("SELECT playerid,playername FROM `lb-players` WHERE LENGTH(UUID)=0 LIMIT " + Integer.toString(100));
                while (rs.next()) {
                    do {
                        players.put(rs.getString(2), rs.getInt(1));
                        names.add(rs.getString(2));
                    } while (rs.next());
                    if (names.size() <= 0) continue;
                    response = UUIDFetcher.getUUIDs(names);
                    for (Map.Entry<K, V> entry : players.entrySet()) {
                        if (response.get(entry.getKey()) == null) {
                            theUUID = String.valueOf(unimportedPrefix) + (String)entry.getKey();
                            this.logblock.getLogger().warning(String.valueOf((String)entry.getKey()) + " not found - giving UUID of " + theUUID);
                        } else {
                            theUUID = response.get(entry.getKey()).toString();
                        }
                        thePID = ((Integer)entry.getValue()).toString();
                        st.execute("UPDATE `lb-players` SET UUID = '" + theUUID + "' WHERE playerid = " + thePID);
                        ++done;
                    }
                    conn.commit();
                    players.clear();
                    names.clear();
                    this.logblock.getLogger().info("Processed " + Integer.toString(done) + " out of " + total);
                    rs.close();
                    rs = st.executeQuery("SELECT playerid,playername FROM `lb-players` WHERE LENGTH(UUID)=0 LIMIT " + Integer.toString(100));
                }
                rs.close();
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            catch (Exception ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[UUID importer]", ex);
                return false;
            }
            config.set("version", (Object)"1.9.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.9.4")) < 0) {
            block136: {
                block135: {
                    this.logblock.getLogger().info("Updating tables to 1.9.4 ...");
                    conn = this.logblock.getConnection();
                    try {
                        conn.setAutoCommit(true);
                        st = conn.createStatement();
                        try {
                            st.execute("DROP INDEX UUID ON `lb-players`");
                        }
                        catch (SQLException ex) {
                            if (ex.getErrorCode() == 1091) break block135;
                            this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                            return false;
                        }
                    }
                    catch (SQLException ex) {
                        this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                        return false;
                    }
                }
                try {
                    st.execute("DROP INDEX playername ON `lb-players`");
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 1091) break block136;
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            st.execute("CREATE INDEX UUID ON `lb-players` (UUID);");
            st.execute("CREATE INDEX playername ON `lb-players` (playername);");
            st.close();
            conn.close();
            config.set("version", (Object)"1.9.4");
        }
        if (configVersion.compareTo(new ComparableVersion("1.10.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.10.0 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                this.checkCharset("lb-players", "name", st, false);
                if (Config.isLogging(Logging.CHAT)) {
                    this.checkCharset("lb-chat", "message", st, false);
                }
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    wcfg.isLogging(Logging.SIGNTEXT);
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.10.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.12.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.12.0 ...");
            if (Config.isLogging(Logging.CHAT)) {
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-chat` MODIFY COLUMN `message` VARCHAR(256) NOT NULL");
                    st.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            config.set("version", (Object)"1.12.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.13.0")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.13.0 ...");
            try {
                materialUpdater = new MaterialUpdater1_13(this.logblock);
                this.logblock.getLogger().info("Convertig BlockId to BlockData. This can take a while ...");
                conn = this.logblock.getConnection();
                conn.setAutoCommit(false);
                st = conn.createStatement();
                for (Object wcfg : Config.getLoggedWorlds()) {
                    this.logblock.getLogger().info("Processing world " + wcfg.world + "...");
                    this.logblock.getLogger().info("Processing block changes...");
                    hadRow = true;
                    rowsToConvert = 0L;
                    done = 0L;
                    try {
                        rs = st.executeQuery("SELECT count(*) as rowcount FROM `" + wcfg.table + "`");
                        if (rs.next()) {
                            rowsToConvert = rs.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + wcfg.table);
                        }
                        rs.close();
                        deleteStatement = conn.prepareStatement("DELETE FROM `" + wcfg.table + "` WHERE id = ?");
                        insertStatement = conn.prepareStatement("INSERT INTO `" + wcfg.table + "-blocks` (id, date, playerid, replaced, replacedData, type, typeData, x, y, z) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
                        while (hadRow) {
                            hadRow = false;
                            entries = st.executeQuery("SELECT id, date, playerid, replaced, type, data, x, y, z FROM `" + wcfg.table + "` ORDER BY id ASC LIMIT " + 100000);
                            while (entries.next()) {
                                hadRow = true;
                                id = entries.getInt("id");
                                date = entries.getTimestamp("date");
                                playerid = entries.getInt("playerid");
                                replaced = entries.getInt("replaced");
                                type = entries.getInt("type");
                                data = entries.getInt("data");
                                x = entries.getInt("x");
                                y = entries.getInt("y");
                                z = entries.getInt("z");
                                if (data == 16) {
                                    data = 0;
                                }
                                try {
                                    replacedBlockData = materialUpdater.getBlockData(replaced, data).getAsString();
                                    setBlockData = materialUpdater.getBlockData(type, data).getAsString();
                                    newReplacedId = MaterialConverter.getOrAddMaterialId(replacedBlockData);
                                    newReplacedData = MaterialConverter.getOrAddBlockStateId(replacedBlockData);
                                    newSetId = MaterialConverter.getOrAddMaterialId(setBlockData);
                                    newSetData = MaterialConverter.getOrAddBlockStateId(setBlockData);
                                    insertStatement.setInt(1, id);
                                    insertStatement.setTimestamp(2, date);
                                    insertStatement.setInt(3, playerid);
                                    insertStatement.setInt(4, newReplacedId);
                                    insertStatement.setInt(5, newReplacedData);
                                    insertStatement.setInt(6, newSetId);
                                    insertStatement.setInt(7, newSetData);
                                    insertStatement.setInt(8, x);
                                    insertStatement.setInt(9, y);
                                    insertStatement.setInt(10, z);
                                    insertStatement.addBatch();
                                }
                                catch (Exception e) {
                                    this.logblock.getLogger().info("Exception in entry " + id + " (" + replaced + ":" + data + "->" + type + ":" + data + "): " + e.getMessage());
                                }
                                deleteStatement.setInt(1, id);
                                deleteStatement.addBatch();
                                ++done;
                            }
                            entries.close();
                            failedRows = 0;
                            if (hadRow) {
                                block137: {
                                    try {
                                        insertStatement.executeBatch();
                                        break block137;
                                    }
                                    catch (BatchUpdateException e) {
                                        data = e.getUpdateCounts();
                                        type = data.length;
                                        replaced = 0;
                                        ** while (replaced < type)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        result = data[replaced];
                                        if (result == -3) {
                                            ++failedRows;
                                        }
                                        ++replaced;
                                        continue;
                                    }
                                }
                                deleteStatement.executeBatch();
                            }
                            conn.commit();
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " " + (failedRows > 0 ? "Duplicates: " + failedRows + " " : "") + "(" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                        }
                        insertStatement.close();
                        deleteStatement.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + wcfg.table + ": " + e.getMessage());
                    }
                    this.logblock.getLogger().info("Processing chests...");
                    rowsToConvert = 0L;
                    done = 0L;
                    try {
                        rs = st.executeQuery("SELECT count(*) as rowcount FROM `" + wcfg.table + "-chest`");
                        if (rs.next()) {
                            rowsToConvert = rs.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + wcfg.table + "-chest");
                        }
                        rs.close();
                        insertChestData = conn.prepareStatement("INSERT INTO `" + wcfg.table + "-chestdata` (id, item, itemremove, itemtype) VALUES (?, ?, ?, ?)");
                        deleteChest = conn.prepareStatement("DELETE FROM `" + wcfg.table + "-chest` WHERE id = ?");
                        while (true) {
                            block138: {
                                rs = st.executeQuery("SELECT id, itemtype, itemamount, itemdata FROM `" + wcfg.table + "-chest` ORDER BY id ASC LIMIT " + 20000);
                                anyRow = false;
                                while (rs.next()) {
                                    anyRow = true;
                                    id = rs.getInt("id");
                                    itemtype = rs.getInt("itemtype");
                                    itemdata = rs.getInt("itemdata");
                                    amount = rs.getInt("itemamount");
                                    weaponMaterial = materialUpdater.getMaterial(itemtype, itemdata);
                                    if (weaponMaterial == null) {
                                        weaponMaterial = Material.AIR;
                                    }
                                    stack /* !! */  = (int[])(weaponMaterial.getMaxDurability() > 0 ? new ItemStack(weaponMaterial, Math.abs(amount), (short)itemdata) : new ItemStack(weaponMaterial, Math.abs(amount)));
                                    insertChestData.setInt(1, id);
                                    insertChestData.setBytes(2, Utils.saveItemStack((ItemStack)stack /* !! */ ));
                                    insertChestData.setInt(3, amount >= 0 ? 0 : 1);
                                    insertChestData.setInt(4, MaterialConverter.getOrAddMaterialId(weaponMaterial.getKey()));
                                    insertChestData.addBatch();
                                    deleteChest.setInt(1, id);
                                    deleteChest.addBatch();
                                    ++done;
                                }
                                rs.close();
                                if (!anyRow) break;
                                failedRows = 0;
                                try {
                                    insertChestData.executeBatch();
                                    break block138;
                                }
                                catch (BatchUpdateException e) {
                                    stack /* !! */  = e.getUpdateCounts();
                                    weaponMaterial = stack /* !! */ .length;
                                    amount = 0;
                                    ** while (amount < weaponMaterial)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    result = stack /* !! */ [amount];
                                    if (result == -3) {
                                        ++failedRows;
                                    }
                                    ++amount;
                                    continue;
                                }
                            }
                            deleteChest.executeBatch();
                            conn.commit();
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " " + (failedRows > 0 ? "Duplicates: " + failedRows + " " : "") + "(" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                        }
                        insertChestData.close();
                        deleteChest.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + wcfg.table + "-chest: " + e.getMessage());
                    }
                    if (!wcfg.isLogging(Logging.KILL)) continue;
                    this.logblock.getLogger().info("Processing kills...");
                    rowsToConvert = 0L;
                    done = 0L;
                    try {
                        rs = st.executeQuery("SELECT count(*) as rowcount FROM `" + wcfg.table + "-kills`");
                        if (rs.next()) {
                            rowsToConvert = rs.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + wcfg.table + "-kills");
                        }
                        rs.close();
                        updateWeaponStatement = conn.prepareStatement("UPDATE `" + wcfg.table + "-kills` SET weapon = ? WHERE id = ?");
                        start = 0;
                        while (true) {
                            rs = st.executeQuery("SELECT id, weapon FROM `" + wcfg.table + "-kills` ORDER BY id ASC LIMIT " + start + "," + 20000);
                            anyUpdate = false;
                            anyRow = false;
                            while (rs.next()) {
                                anyRow = true;
                                id = rs.getInt("id");
                                weapon = rs.getInt("weapon");
                                weaponMaterial = materialUpdater.getMaterial(weapon, 0);
                                if (weaponMaterial == null) {
                                    weaponMaterial = Material.AIR;
                                }
                                if ((newWeapon = MaterialConverter.getOrAddMaterialId(weaponMaterial.getKey())) != weapon) {
                                    anyUpdate = true;
                                    updateWeaponStatement.setInt(1, newWeapon);
                                    updateWeaponStatement.setInt(2, id);
                                    updateWeaponStatement.addBatch();
                                }
                                ++done;
                            }
                            rs.close();
                            if (anyUpdate) {
                                updateWeaponStatement.executeBatch();
                                conn.commit();
                            }
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " (" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                            if (!anyRow) break;
                            start += 20000;
                        }
                        updateWeaponStatement.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + wcfg.table + "-kills: " + e.getMessage());
                    }
                }
                st.close();
                conn.close();
                this.logblock.getLogger().info("Updating config to 1.13.0 ...");
                config.set("logging.hiddenBlocks", materialUpdater.convertMaterials(config.getStringList("logging.hiddenBlocks")));
                config.set("rollback.dontRollback", materialUpdater.convertMaterials(config.getStringList("rollback.dontRollback")));
                config.set("rollback.replaceAnyway", materialUpdater.convertMaterials(config.getStringList("rollback.replaceAnyway")));
                toolsSec = config.getConfigurationSection("tools");
                for (String toolName : toolsSec.getKeys(false)) {
                    tSec = toolsSec.getConfigurationSection(toolName);
                    tSec.set("item", (Object)materialUpdater.convertMaterial(tSec.getString("item", "OAK_LOG")));
                }
            }
            catch (IOException | SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.13.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.13.1")) < 0) {
            this.logblock.getLogger().info("Updating tables to 1.13.1 ...");
            try {
                conn = this.logblock.getConnection();
                conn.setAutoCommit(false);
                st = conn.createStatement();
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    this.logblock.getLogger().info("Processing world " + wcfg.world + "...");
                    rsCol = st.executeQuery("SHOW COLUMNS FROM `" + wcfg.table + "-chestdata` LIKE 'itemtype'");
                    if (!rsCol.next()) {
                        st.execute("ALTER TABLE `" + wcfg.table + "-chestdata` ADD COLUMN `itemtype` SMALLINT NOT NULL DEFAULT '0'");
                    }
                    rsCol.close();
                    conn.commit();
                    if (!wcfg.isLogging(Logging.SIGNTEXT)) continue;
                    rowsToConvert = 0L;
                    done = 0L;
                    try {
                        rs = st.executeQuery("SELECT count(*) as rowcount FROM `" + wcfg.table + "-sign`");
                        if (rs.next()) {
                            rowsToConvert = rs.getLong(1);
                            this.logblock.getLogger().info("Converting " + rowsToConvert + " entries in " + wcfg.table + "-sign");
                        }
                        rs.close();
                        insertSignState = conn.prepareStatement("INSERT INTO `" + wcfg.table + "-state` (id, replacedState, typeState) VALUES (?, ?, ?)");
                        deleteSign = conn.prepareStatement("DELETE FROM `" + wcfg.table + "-sign` WHERE id = ?");
                        while (true) {
                            block139: {
                                rs = st.executeQuery("SELECT id, signtext, replaced, type FROM `" + wcfg.table + "-sign` LEFT JOIN `" + wcfg.table + "-blocks` USING (id) ORDER BY id ASC LIMIT " + 20000);
                                anyRow = false;
                                while (rs.next()) {
                                    anyRow = true;
                                    id = rs.getInt("id");
                                    signText = rs.getString("signtext");
                                    replaced = rs.getInt("replaced");
                                    nullBlock = rs.wasNull();
                                    type = rs.getInt("type");
                                    if (!nullBlock && signText != null) {
                                        lines = signText.split("\u0000", 4);
                                        bytes = Utils.serializeYamlConfiguration(BlockStateCodecSign.serialize(lines));
                                        replacedMaterial = MaterialConverter.getBlockData(replaced, -1).getMaterial();
                                        typeMaterial = MaterialConverter.getBlockData(type, -1).getMaterial();
                                        wasSign = replacedMaterial == Material.SIGN || replacedMaterial == Material.WALL_SIGN;
                                        isSign = typeMaterial == Material.SIGN || typeMaterial == Material.WALL_SIGN;
                                        insertSignState.setInt(1, id);
                                        insertSignState.setBytes(2, (byte[])(wasSign != false ? bytes : null));
                                        insertSignState.setBytes(3, (byte[])(isSign != false ? bytes : null));
                                        insertSignState.addBatch();
                                    }
                                    deleteSign.setInt(1, id);
                                    deleteSign.addBatch();
                                    ++done;
                                }
                                rs.close();
                                if (!anyRow) break;
                                failedRows = 0;
                                try {
                                    insertSignState.executeBatch();
                                    break block139;
                                }
                                catch (BatchUpdateException e) {
                                    var22_75 = e.getUpdateCounts();
                                    var21_70 = var22_75.length;
                                    var20_66 = 0;
                                    ** while (var20_66 < var21_70)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    result = var22_75[var20_66];
                                    if (result == -3) {
                                        ++failedRows;
                                    }
                                    ++var20_66;
                                    continue;
                                }
                            }
                            deleteSign.executeBatch();
                            conn.commit();
                            this.logblock.getLogger().info("Done: " + done + "/" + rowsToConvert + " " + (failedRows > 0 ? "Duplicates: " + failedRows + " " : "") + "(" + (rowsToConvert > 0L ? done * 100L / rowsToConvert : 100L) + "%)");
                        }
                        insertSignState.close();
                        deleteSign.close();
                    }
                    catch (SQLException e) {
                        this.logblock.getLogger().info("Could not convert " + wcfg.table + "-sign: " + e.getMessage());
                    }
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.13.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.13.2")) < 0) {
            config.set("version", (Object)"1.13.2");
        }
        try {
            conn = this.logblock.getConnection();
            conn.setAutoCommit(true);
            st = conn.createStatement();
            this.checkCharset("lb-players", "name", st, true);
            if (Config.isLogging(Logging.CHAT)) {
                this.checkCharset("lb-chat", "message", st, true);
            }
            this.createIndexIfDoesNotExist("lb-materials", "name", "UNIQUE KEY `name` (`name`(150))", st, true);
            this.createIndexIfDoesNotExist("lb-blockstates", "name", "UNIQUE KEY `name` (`name`(150))", st, true);
            st.close();
            conn.close();
        }
        catch (SQLException ex) {
            this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
            return false;
        }
        this.logblock.saveConfig();
        return true;
    }

    void createIndexIfDoesNotExist(String table, String indexName, String definition, Statement st, boolean silent) throws SQLException {
        ResultSet rs = st.executeQuery("SHOW INDEX FROM `" + table + "` WHERE Key_name = '" + indexName + "'");
        if (!rs.next()) {
            st.execute("ALTER TABLE `" + table + "` ADD " + definition);
            this.logblock.getLogger().info("Add index " + indexName + " to table " + table + ": Table modified");
        } else if (!silent) {
            this.logblock.getLogger().info("Add index " + indexName + " to table " + table + ": Already fine, skipping it");
        }
        rs.close();
    }

    void checkCharset(String table, String column, Statement st, boolean silent) throws SQLException {
        ResultSet rs = st.executeQuery("SHOW FULL COLUMNS FROM `" + table + "` WHERE field = '" + column + "'");
        String charset = "utf8";
        if (Config.mb4) {
            charset = "utf8mb4";
        }
        if (rs.next() && !rs.getString("Collation").substring(0, charset.length()).equalsIgnoreCase(charset)) {
            st.execute("ALTER TABLE `" + table + "` CONVERT TO CHARSET " + charset);
            this.logblock.getLogger().info("Table " + table + " modified");
        } else if (!silent) {
            this.logblock.getLogger().info("Table " + table + " already fine, skipping it");
        }
        rs.close();
    }

    void checkTables() throws SQLException {
        Connection conn;
        String charset = "utf8";
        if (Config.mb4) {
            charset = "utf8mb4";
        }
        if ((conn = this.logblock.getConnection()) == null) {
            throw new SQLException("No connection");
        }
        Statement state = conn.createStatement();
        DatabaseMetaData dbm = conn.getMetaData();
        conn.setAutoCommit(true);
        this.createTable(dbm, state, "lb-players", "(playerid INT UNSIGNED NOT NULL AUTO_INCREMENT, UUID varchar(36) NOT NULL, playername varchar(32) NOT NULL, firstlogin DATETIME NOT NULL, lastlogin DATETIME NOT NULL, onlinetime INT UNSIGNED NOT NULL, ip varchar(255) NOT NULL, PRIMARY KEY (playerid), INDEX (UUID), INDEX (playername)) DEFAULT CHARSET " + charset);
        ResultSet rs = state.executeQuery("SELECT NULL FROM `lb-players` LIMIT 1;");
        if (!rs.next()) {
            state.execute("INSERT IGNORE INTO `lb-players` (UUID,playername) VALUES ('log_dummy_record','dummy_record')");
        }
        if (Config.isLogging(Logging.CHAT)) {
            this.createTable(dbm, state, "lb-chat", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, message VARCHAR(256) NOT NULL, PRIMARY KEY (id), KEY playerid (playerid), FULLTEXT message (message)) DEFAULT CHARSET " + charset);
        }
        this.createTable(dbm, state, "lb-materials", "(id INT UNSIGNED NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY (id)) DEFAULT CHARSET " + charset);
        this.createTable(dbm, state, "lb-blockstates", "(id INT UNSIGNED NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY (id)) DEFAULT CHARSET " + charset);
        this.createTable(dbm, state, "lb-entitytypes", "(id INT UNSIGNED NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY (id)) DEFAULT CHARSET " + charset);
        for (WorldConfig wcfg : Config.getLoggedWorlds()) {
            this.createTable(dbm, state, String.valueOf(wcfg.table) + "-blocks", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, replaced SMALLINT UNSIGNED NOT NULL, replacedData SMALLINT NOT NULL, type SMALLINT UNSIGNED NOT NULL, typeData SMALLINT NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT UNSIGNED NOT NULL, z MEDIUMINT NOT NULL, PRIMARY KEY (id), KEY coords (x, z, y), KEY date (date), KEY playerid (playerid))");
            this.createTable(dbm, state, String.valueOf(wcfg.table) + "-chestdata", "(id INT UNSIGNED NOT NULL, item MEDIUMBLOB, itemremove TINYINT, itemtype SMALLINT NOT NULL DEFAULT '0', PRIMARY KEY (id))");
            this.createTable(dbm, state, String.valueOf(wcfg.table) + "-state", "(id INT UNSIGNED NOT NULL, replacedState MEDIUMBLOB NULL, typeState MEDIUMBLOB NULL, PRIMARY KEY (id))");
            if (wcfg.isLogging(Logging.KILL)) {
                this.createTable(dbm, state, String.valueOf(wcfg.table) + "-kills", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, killer INT UNSIGNED, victim INT UNSIGNED NOT NULL, weapon SMALLINT UNSIGNED NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT NOT NULL, z MEDIUMINT NOT NULL, PRIMARY KEY (id))");
            }
            this.createTable(dbm, state, String.valueOf(wcfg.table) + "-entityids", "(entityid INT UNSIGNED NOT NULL AUTO_INCREMENT, entityuuid VARCHAR(36) CHARACTER SET ascii COLLATE ascii_bin NOT NULL, PRIMARY KEY (entityid), UNIQUE KEY (entityuuid))");
            this.createTable(dbm, state, String.valueOf(wcfg.table) + "-entities", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, entityid INT UNSIGNED NOT NULL, entitytypeid INT UNSIGNED NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT NOT NULL, z MEDIUMINT NOT NULL, action TINYINT UNSIGNED NOT NULL, data MEDIUMBLOB NULL, PRIMARY KEY (id), KEY coords (x, z, y), KEY date (date), KEY playerid (playerid))");
        }
        state.close();
        conn.close();
    }

    private void createTable(DatabaseMetaData dbm, Statement state, String table, String query) throws SQLException {
        if (!dbm.getTables(null, null, table, null).next()) {
            this.logblock.getLogger().log(Level.INFO, "Creating table " + table + ".");
            state.execute("CREATE TABLE `" + table + "` " + query);
            if (!dbm.getTables(null, null, table, null).next()) {
                throw new SQLException("Table " + table + " not found and failed to create");
            }
        }
    }

    public static class MaterialUpdater1_13 {
        BlockData[][] blockDataMapping;
        Material[][] itemMapping = new Material[10][];

        public MaterialUpdater1_13(LogBlock plugin) throws IOException {
            this.blockDataMapping = new BlockData[256][16];
            Throwable throwable = null;
            Object var3_4 = null;
            try (JarFile file = new JarFile(plugin.getFile());){
                String line;
                int blockid;
                int splitter2;
                String line2;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(file.getInputStream(file.getJarEntry("blockdata.txt"))), "UTF-8"));
                while ((line2 = reader.readLine()) != null) {
                    int splitter1 = line2.indexOf(":");
                    splitter2 = line2.indexOf(",");
                    if (splitter1 < 0 || splitter2 < 0) continue;
                    blockid = Integer.parseInt(line2.substring(0, splitter1));
                    int blockdata = Integer.parseInt(line2.substring(splitter1 + 1, splitter2));
                    BlockData newBlockData = Bukkit.createBlockData((String)line2.substring(splitter2 + 1));
                    if (blockdata == 0) {
                        int i = 0;
                        while (i < 16) {
                            if (this.blockDataMapping[blockid][i] == null) {
                                this.blockDataMapping[blockid][i] = newBlockData;
                            }
                            ++i;
                        }
                        continue;
                    }
                    this.blockDataMapping[blockid][blockdata] = newBlockData;
                }
                reader.close();
                HashMap<String, Material> materialKeysToMaterial = new HashMap<String, Material>();
                Material[] blockdata = Material.values();
                blockid = blockdata.length;
                splitter2 = 0;
                while (splitter2 < blockid) {
                    Material material = blockdata[splitter2];
                    materialKeysToMaterial.put(material.getKey().toString(), material);
                    ++splitter2;
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(file.getInputStream(file.getJarEntry("itemdata.txt"))), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    Material[] itemValues;
                    int splitter1 = line.indexOf(":");
                    int splitter22 = line.indexOf(",");
                    if (splitter1 < 0 || splitter22 < 0) continue;
                    int itemid = Integer.parseInt(line.substring(0, splitter1));
                    int itemdata = Integer.parseInt(line.substring(splitter1 + 1, splitter22));
                    Material newMaterial = (Material)materialKeysToMaterial.get(line.substring(splitter22 + 1));
                    if (newMaterial == null) {
                        throw new IOException("Unknown item: " + line.substring(splitter22 + 1));
                    }
                    if (itemid >= this.itemMapping.length) {
                        this.itemMapping = (Material[][])Arrays.copyOf(this.itemMapping, Math.max(this.itemMapping.length * 3 / 2, itemid + 1));
                    }
                    if ((itemValues = this.itemMapping[itemid]) == null) {
                        itemValues = new Material[itemdata + 1];
                        this.itemMapping[itemid] = itemValues;
                    } else if (itemValues.length <= itemdata) {
                        itemValues = Arrays.copyOf(itemValues, itemdata + 1);
                        this.itemMapping[itemid] = itemValues;
                    }
                    itemValues[itemdata] = newMaterial;
                }
                reader.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public BlockData getBlockData(int id, int data) {
            return id >= 0 && id < 256 && data >= 0 && data < 16 ? this.blockDataMapping[id][data] : null;
        }

        public Material getMaterial(int id, int data) {
            Material[] materials;
            Material[] materialArray = materials = id >= 0 && id < this.itemMapping.length ? this.itemMapping[id] : null;
            if (materials != null && materials.length > 0) {
                if (materials[0] != null && materials[0].getMaxDurability() == 0 && data >= 0 && data < materials.length && materials[data] != null) {
                    return materials[data];
                }
                return materials[0];
            }
            return null;
        }

        public Material getMaterial(String id) {
            int item = 0;
            int data = 0;
            int seperator = id.indexOf(58);
            if (seperator < 0) {
                item = Integer.parseInt(id);
            } else {
                item = Integer.parseInt(id.substring(0, seperator));
                data = Integer.parseInt(id.substring(seperator + 1));
            }
            return this.getMaterial(item, data);
        }

        public String convertMaterial(String oldEntry) {
            block5: {
                if (oldEntry == null) {
                    return null;
                }
                try {
                    Material newMaterial = this.getMaterial(oldEntry);
                    if (newMaterial != null) {
                        return newMaterial.name();
                    }
                }
                catch (Exception e) {
                    Material newMaterial = Material.matchMaterial((String)oldEntry, (boolean)true);
                    if (newMaterial != null) {
                        return newMaterial.name();
                    }
                    newMaterial = Material.matchMaterial((String)oldEntry);
                    if (newMaterial == null) break block5;
                    return newMaterial.name();
                }
            }
            return null;
        }

        public List<String> convertMaterials(Collection<String> oldEntries) {
            LinkedHashSet<String> newEntries = new LinkedHashSet<String>();
            for (String oldEntry : oldEntries) {
                String newEntry = this.convertMaterial(oldEntry);
                if (newEntry == null) continue;
                newEntries.add(newEntry);
                if (!newEntry.equals(Material.AIR.name())) continue;
                newEntries.add(Material.CAVE_AIR.name());
                newEntries.add(Material.VOID_AIR.name());
            }
            return new ArrayList<String>(newEntries);
        }
    }

    public static class PlayerCountChecker
    implements Runnable {
        private LogBlock logblock;

        public PlayerCountChecker(LogBlock logblock) {
            this.logblock = logblock;
        }

        @Override
        public void run() {
            block4: {
                Connection conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    Statement st = conn.createStatement();
                    ResultSet rs = st.executeQuery("SELECT auto_increment FROM information_schema.columns AS col join information_schema.tables AS tab ON (col.table_schema=tab.table_schema AND col.table_name=tab.table_name) WHERE col.table_name = 'lb-players' AND col.column_name = 'playerid' AND col.data_type = 'smallint' AND col.table_schema = DATABASE() AND auto_increment > 65000;");
                    if (rs.next()) {
                        int i = 0;
                        while (i < 6) {
                            this.logblock.getLogger().warning("Your server reached 65000 players. You should soon update your database table schema - see FAQ: https://github.com/LogBlock/LogBlock/wiki/FAQ#logblock-your-server-reached-65000-players-");
                            ++i;
                        }
                    }
                    st.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    if (!this.logblock.isCompletelyEnabled()) break block4;
                    this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                }
            }
        }
    }
}

