/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.plugin.Plugin;

public class BlockPlaceLogging
extends LoggingListener {
    public BlockPlaceLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getBlock().getWorld());
        if (wcfg != null && wcfg.isLogging(Logging.BLOCKPLACE)) {
            Material type = event.getBlock().getType();
            final BlockState before = event.getBlockReplacedState();
            final BlockState after = event.getBlockPlaced().getState();
            final Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
            if (type.hasGravity()) {
                if (!BukkitUtils.isEmpty(before.getType())) {
                    this.consumer.queueBlockBreak(actor, before);
                }
                Location loc = event.getBlock().getLocation();
                int x = loc.getBlockX();
                int y = loc.getBlockY();
                int z = loc.getBlockZ();
                if (BukkitUtils.isEmpty(event.getBlock().getRelative(BlockFace.DOWN).getType())) {
                    while (y > 0 && BukkitUtils.canFall(loc.getWorld(), x, y - 1, z)) {
                        --y;
                    }
                }
                if (y != 0) {
                    Location finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
                    if (!BukkitUtils.getFallingEntityKillers().contains(finalLoc.getBlock().getType())) {
                        if (BukkitUtils.isEmpty(finalLoc.getBlock().getType()) || finalLoc.equals((Object)event.getBlock().getLocation())) {
                            this.consumer.queueBlockPlace(actor, finalLoc, event.getBlock().getBlockData());
                        } else {
                            this.consumer.queueBlockReplace(actor, finalLoc, finalLoc.getBlock().getBlockData(), event.getBlock().getBlockData());
                        }
                    }
                }
                return;
            }
            if (wcfg.isLogging(Logging.SIGNTEXT) && (type == Material.SIGN || type == Material.WALL_SIGN)) {
                return;
            }
            LogBlock.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)LogBlock.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (BukkitUtils.isEmpty(before.getType())) {
                        BlockPlaceLogging.this.consumer.queueBlockPlace(actor, after);
                    } else {
                        BlockPlaceLogging.this.consumer.queueBlockReplace(actor, before, after);
                    }
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (Config.isLogging(event.getPlayer().getWorld(), Logging.BLOCKPLACE)) {
            this.consumer.queueBlockPlace(Actor.actorFromEntity((Entity)event.getPlayer()), event.getBlockClicked().getRelative(event.getBlockFace()).getLocation(), Bukkit.createBlockData((Material)(event.getBucket() == Material.WATER_BUCKET ? Material.WATER : Material.LAVA)));
        }
    }
}

