/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.material.Button;
import org.bukkit.material.CocoaPlant;
import org.bukkit.material.Ladder;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;
import org.bukkit.material.RedstoneTorch;
import org.bukkit.material.Torch;
import org.bukkit.material.TrapDoor;
import org.bukkit.material.TripwireHook;

public class LoggingUtil {
    public static void smartLogFallables(Consumer consumer, Actor actor, Block origin) {
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Block checkBlock = origin.getRelative(BlockFace.UP);
        int up = 0;
        int highestBlock = checkBlock.getWorld().getHighestBlockYAt(checkBlock.getLocation());
        while (BukkitUtils.getRelativeTopFallables().contains(checkBlock.getType())) {
            int y;
            consumer.queueBlockBreak(actor, checkBlock.getState());
            Location loc = origin.getLocation();
            int x = loc.getBlockX();
            int z = loc.getBlockZ();
            for (y = loc.getBlockY(); y > 0 && BukkitUtils.canFall(loc.getWorld(), x, y - 1, z); --y) {
            }
            if (y != 0) {
                Location finalLoc = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
                if (!BukkitUtils.getFallingEntityKillers().contains(finalLoc.getBlock().getType())) {
                    finalLoc.add(0.0, (double)up, 0.0);
                    if (finalLoc.getBlock().getType() == Material.AIR || BukkitUtils.getRelativeTopFallables().contains(finalLoc.getBlock().getType())) {
                        consumer.queueBlockPlace(actor, finalLoc, checkBlock.getTypeId(), checkBlock.getData());
                    } else {
                        consumer.queueBlockReplace(actor, finalLoc, finalLoc.getBlock().getTypeId(), finalLoc.getBlock().getData(), checkBlock.getTypeId(), checkBlock.getData());
                    }
                    ++up;
                }
            }
            if (checkBlock.getY() >= highestBlock) break;
            checkBlock = checkBlock.getRelative(BlockFace.UP);
        }
    }

    public static void smartLogBlockBreak(Consumer consumer, Actor actor, Block origin) {
        List<Location> relativeBreakables;
        WorldConfig wcfg = Config.getWorldConfig(origin.getWorld());
        if (wcfg == null) {
            return;
        }
        Block checkBlock = origin.getRelative(BlockFace.UP);
        if (BukkitUtils.getRelativeTopBreakabls().contains(checkBlock.getType())) {
            if (wcfg.isLogging(Logging.SIGNTEXT) && checkBlock.getType() == Material.SIGN_POST) {
                consumer.queueSignBreak(actor, (Sign)checkBlock.getState());
            } else if (checkBlock.getType() == Material.IRON_DOOR_BLOCK || checkBlock.getType() == Material.WOODEN_DOOR) {
                Block doorBlock = checkBlock;
                if (!BukkitUtils.isTop(doorBlock.getType(), doorBlock.getData())) {
                    if ((doorBlock = doorBlock.getRelative(BlockFace.UP)).getType() == Material.IRON_DOOR_BLOCK || doorBlock.getType() == Material.WOODEN_DOOR) {
                        consumer.queueBlockBreak(actor, doorBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else if (checkBlock.getType() == Material.DOUBLE_PLANT) {
                Block plantBlock = checkBlock;
                if (!BukkitUtils.isTop(plantBlock.getType(), plantBlock.getData())) {
                    if ((plantBlock = plantBlock.getRelative(BlockFace.UP)).getType() == Material.DOUBLE_PLANT) {
                        consumer.queueBlockBreak(actor, plantBlock.getState());
                    }
                    consumer.queueBlockBreak(actor, checkBlock.getState());
                }
            } else {
                consumer.queueBlockBreak(actor, checkBlock.getState());
            }
        }
        if ((relativeBreakables = BukkitUtils.getBlocksNearby(origin, BukkitUtils.getRelativeBreakables())).size() != 0) {
            block11: for (Location location : relativeBreakables) {
                Material blockType = location.getBlock().getType();
                BlockState blockState = location.getBlock().getState();
                MaterialData data = blockState.getData();
                switch (blockType) {
                    case REDSTONE_TORCH_ON: 
                    case REDSTONE_TORCH_OFF: {
                        if (!blockState.getBlock().getRelative(((RedstoneTorch)data).getAttachedFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case TORCH: {
                        if (!blockState.getBlock().getRelative(((Torch)data).getAttachedFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case COCOA: {
                        if (!blockState.getBlock().getRelative(((CocoaPlant)data).getAttachedFace().getOppositeFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case LADDER: {
                        if (!blockState.getBlock().getRelative(((Ladder)data).getAttachedFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case LEVER: {
                        if (!blockState.getBlock().getRelative(((Lever)data).getAttachedFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case TRIPWIRE_HOOK: {
                        if (!blockState.getBlock().getRelative(((TripwireHook)data).getAttachedFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case WOOD_BUTTON: 
                    case STONE_BUTTON: {
                        if (!blockState.getBlock().getRelative(((Button)data).getAttachedFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case WALL_SIGN: {
                        if (!blockState.getBlock().getRelative(((org.bukkit.material.Sign)data).getAttachedFace()).equals(origin)) continue block11;
                        if (wcfg.isLogging(Logging.SIGNTEXT)) {
                            consumer.queueSignBreak(actor, (Sign)blockState);
                            continue block11;
                        }
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                    case TRAP_DOOR: {
                        if (!blockState.getBlock().getRelative(((TrapDoor)data).getAttachedFace()).equals(origin)) continue block11;
                        consumer.queueBlockBreak(actor, blockState);
                        continue block11;
                    }
                }
                consumer.queueBlockBreak(actor, blockState);
            }
        }
        if (origin.getType() == Material.IRON_DOOR_BLOCK || origin.getType() == Material.WOODEN_DOOR) {
            Block doorBlock = origin;
            doorBlock = !BukkitUtils.isTop(doorBlock.getType(), doorBlock.getData()) ? doorBlock.getRelative(BlockFace.UP) : doorBlock.getRelative(BlockFace.DOWN);
            if (doorBlock.getType() == Material.IRON_DOOR_BLOCK || doorBlock.getType() == Material.WOODEN_DOOR) {
                consumer.queueBlockBreak(actor, doorBlock.getState());
            }
        } else if (origin.getType() == Material.DOUBLE_PLANT) {
            Block plantBlock = origin;
            plantBlock = !BukkitUtils.isTop(origin.getType(), origin.getData()) ? plantBlock.getRelative(BlockFace.UP) : plantBlock.getRelative(BlockFace.DOWN);
            if (plantBlock.getType() == Material.DOUBLE_PLANT) {
                consumer.queueBlockBreak(actor, plantBlock.getState());
            }
        }
        consumer.queueBlockBreak(actor, origin.getState());
    }

    public static String checkText(String text) {
        if (text == null) {
            return text;
        }
        if (Config.mb4) {
            return text;
        }
        return text.replaceAll("[^\\u0000-\\uFFFF]", "?");
    }
}

