/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.paper1_21_8;

import com.google.common.base.Preconditions;
import com.mojang.serialization.DynamicOps;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.nbt.TagType;
import de.cubeside.nmsutils.paper1_21_8.ListTagImpl;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.RegistryOps;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;

public final class CompoundTagImpl
implements CompoundTag {
    final NBTTagCompound handle;

    public CompoundTagImpl(NBTTagCompound handle) {
        this.handle = handle;
    }

    @Override
    public boolean containsKey(String name) {
        return this.handle.b(name);
    }

    @Override
    public boolean containsKey(String name, TagType type) {
        NBTBase value = this.handle.a(name);
        return value != null && value.c() == NBTTagTypes.a((int)type.internalId());
    }

    @Override
    public void clear() {
        this.handle.e().clear();
    }

    @Override
    public void remove(String name) {
        this.handle.r(name);
    }

    @Override
    public Set<String> getAllKeys() {
        return Collections.unmodifiableSet(this.handle.e());
    }

    @Override
    public int size() {
        return this.handle.i();
    }

    @Override
    public void merge(CompoundTag source) {
        this.handle.a(((CompoundTagImpl)source).handle);
    }

    @Override
    public CompoundTagImpl getCompound(String name) {
        return this.getCompound(name, false);
    }

    @Override
    public CompoundTagImpl getCompound(String name, boolean createIfMissing) {
        Preconditions.checkNotNull((Object)name);
        NBTBase tag = this.handle.a(name);
        if (!(tag instanceof NBTTagCompound)) {
            if (!createIfMissing) {
                return null;
            }
            tag = new NBTTagCompound();
            this.handle.a(name, tag);
        }
        return new CompoundTagImpl((NBTTagCompound)tag);
    }

    @Override
    public ListTagImpl getList(String name) {
        return this.getList(name, false);
    }

    @Override
    public ListTagImpl getList(String name, boolean createIfMissing) {
        Preconditions.checkNotNull((Object)name);
        NBTBase tag = this.handle.a(name);
        if (!(tag instanceof NBTTagList)) {
            if (!createIfMissing) {
                return null;
            }
            tag = new NBTTagList();
            this.handle.a(name, tag);
        }
        return new ListTagImpl((NBTTagList)tag);
    }

    @Override
    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    @Override
    public byte getByte(String name, byte defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.j();
        }
        return defaultValue;
    }

    @Override
    public void setByte(String name, byte b2) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, b2);
    }

    @Override
    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    @Override
    public short getShort(String name, short defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.i();
        }
        return defaultValue;
    }

    @Override
    public void setShort(String name, short s) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, s);
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.h();
        }
        return defaultValue;
    }

    @Override
    public void setInt(String name, int v) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, v);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.g();
        }
        return defaultValue;
    }

    @Override
    public void setLong(String name, long l) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, l);
    }

    @Override
    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.l();
        }
        return defaultValue;
    }

    @Override
    public void setFloat(String name, float f2) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, f2);
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.k();
        }
        return defaultValue;
    }

    @Override
    public void setDouble(String name, double d) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, d);
    }

    @Override
    public byte[] getByteArray(String name) {
        return this.getByteArray(name, null);
    }

    @Override
    public byte[] getByteArray(String name, byte[] defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTTagByteArray) {
            NBTTagByteArray tag = (NBTTagByteArray)nBTBase;
            return tag.e();
        }
        return defaultValue;
    }

    @Override
    public void setByteArray(String name, byte[] b2) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)b2);
        this.handle.a(name, b2);
    }

    @Override
    public int[] getIntArray(String name) {
        return this.getIntArray(name, null);
    }

    @Override
    public int[] getIntArray(String name, int[] defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTTagIntArray) {
            NBTTagIntArray tag = (NBTTagIntArray)nBTBase;
            return tag.g();
        }
        return defaultValue;
    }

    @Override
    public void setIntArray(String name, int[] v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, v);
    }

    @Override
    public long[] getLongArray(String name) {
        return this.getLongArray(name, null);
    }

    @Override
    public long[] getLongArray(String name, long[] defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTTagLongArray) {
            NBTTagLongArray tag = (NBTTagLongArray)nBTBase;
            return tag.g();
        }
        return defaultValue;
    }

    @Override
    public void setLongArray(String name, long[] v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, v);
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public String getString(String name, String defaultValue) {
        NBTBase nBTBase = this.handle.a(name);
        if (nBTBase instanceof NBTTagString) {
            NBTTagString tag = (NBTTagString)nBTBase;
            return tag.k();
        }
        return defaultValue;
    }

    @Override
    public void setString(String name, String v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, v);
    }

    @Override
    public UUID getUUID(String name) {
        return this.handle.a("UUID", UUIDUtil.a).orElse(null);
    }

    @Override
    public boolean containsUUID(String name) {
        return this.handle.a("UUID", UUIDUtil.a).isPresent();
    }

    @Override
    public void setUUID(String name, UUID v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, UUIDUtil.a, (Object)v);
    }

    @Override
    public Component getTextComponent(String name) {
        Preconditions.checkNotNull((Object)name);
        NBTBase tag = this.handle.a(name);
        if (tag == null) {
            return null;
        }
        try {
            IChatBaseComponent component = (IChatBaseComponent)ComponentSerialization.a.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)tag).getOrThrow();
            return PaperAdventure.asAdventure((IChatBaseComponent)component);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setTextComponent(String name, Component value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        IChatBaseComponent component = PaperAdventure.asVanilla((Component)value);
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a);
        NBTBase result = (NBTBase)ComponentSerialization.a.encodeStart((DynamicOps)ops, (Object)component).getOrThrow();
        this.handle.a(name, result);
    }

    @Override
    public int hashCode() {
        return this.handle.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundTagImpl)) return false;
        CompoundTagImpl o = (CompoundTagImpl)obj;
        if (!this.handle.equals((Object)o.handle)) return false;
        return true;
    }

    @Override
    public CompoundTagImpl clone() {
        return new CompoundTagImpl(this.handle.l());
    }
}

