/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.paper1_21_4;

import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import de.cubeside.nmsutils.WorldUtils;
import de.cubeside.nmsutils.paper1_21_4.NMSUtilsImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.entity.Player;

public class WorldUtilsImpl
implements WorldUtils {
    private final NMSUtilsImpl nmsUtils;

    public WorldUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public void saveWorldNow(World world) {
        world.save();
        CraftWorld craftWorld = (CraftWorld)world;
        WorldServer handle = craftWorld.getHandle();
        try {
            handle.a(null, true, false);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "Exception while saving world", e);
        }
    }

    @Override
    public void forceUnloadWorldWithoutSaving(World world, Location playerTarget) {
        if (playerTarget.getWorld() == null || playerTarget.getWorld() == world) {
            throw new IllegalArgumentException("Valid target world required");
        }
        try {
            for (Player p : world.getPlayers()) {
                if (p.isDead()) {
                    p.spigot().respawn();
                }
                if (p.getWorld() != world) continue;
                p.teleport(playerTarget);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CraftWorld craftWorld = (CraftWorld)world;
        WorldServer handle = craftWorld.getHandle();
        if (!handle.z().isEmpty()) {
            for (EntityPlayer human : new ArrayList(handle.z())) {
                this.kickPlayer((Player)human.getBukkitEntity(), "Connection lost");
            }
            handle.z().clear();
        }
        if (!this.nmsUtils.getPlugin().getServer().unloadWorld(world, false)) {
            throw new IllegalStateException("Could not unload world");
        }
    }

    @Override
    public void saveChunkNow(Chunk chunk) {
        NewChunkHolder chunkHolder = ((ChunkSystemServerLevel)chunk.getWorld()).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunk.getX(), chunk.getZ());
        if (chunkHolder == null) {
            throw new IllegalStateException("ChunkHolder is null");
        }
        chunkHolder.save(false);
    }

    private void kickPlayer(Player player, String message) {
        player.kickPlayer(message);
    }
}

