/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.nbt;

import de.cubeside.nmsutils.nbt.NumericTag;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;

public final class FloatTag
extends Tag
implements NumericTag {
    private float value;

    public FloatTag(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public int getValueAsInt() {
        return (int)this.value;
    }

    @Override
    public long getValueAsLong() {
        return (long)this.value;
    }

    @Override
    public double getValueAsDouble() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.FLOAT;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof FloatTag)) return false;
        FloatTag o = (FloatTag)obj;
        if (Float.floatToIntBits(this.value) != Float.floatToIntBits(o.value)) return false;
        return true;
    }
}

