/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.config;

import de.cubeside.itemcontrol.Main;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.util.ConfigUtil;
import java.util.ArrayList;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PluginConfig {
    private GroupConfig defaultGroup;
    private ArrayList<GroupConfig> groups;
    private String unavailableMessage;
    private String tooLargeMessage;
    private boolean debug;

    public PluginConfig(Main main, YamlConfiguration yamlConfig) {
        this.debug = ConfigUtil.getOrCreate((ConfigurationSection)yamlConfig, "debug", false);
        ConfigurationSection messagesSection = yamlConfig.getConfigurationSection("messages");
        if (messagesSection != null) {
            this.unavailableMessage = messagesSection.getString("unavailable");
            this.tooLargeMessage = messagesSection.getString("tooLarge");
        }
        ConfigurationSection groupsSection = ConfigUtil.getOrCreateSection((ConfigurationSection)yamlConfig, "groups");
        ConfigurationSection defaultGroupSection = ConfigUtil.getOrCreateSection(groupsSection, "default");
        this.defaultGroup = new GroupConfig(main, "default", defaultGroupSection);
        this.groups = new ArrayList();
        for (String groupName : new ArrayList(groupsSection.getKeys(false))) {
            ConfigurationSection groupSection;
            if (groupName.equals("default") || (groupSection = groupsSection.getConfigurationSection(groupName)) == null) continue;
            this.groups.add(new GroupConfig(main, groupName, groupSection));
        }
        this.groups.sort((g1, g2) -> Integer.compare(g2.getPriority(), g1.getPriority()));
    }

    public GroupConfig getGroup(Player player) {
        for (GroupConfig group : this.groups) {
            if (!player.hasPermission(group.getPermission())) continue;
            return group;
        }
        return this.defaultGroup;
    }

    public String getUnavailableMessage() {
        return this.unavailableMessage;
    }

    public String getTooLargeMessage() {
        return this.tooLargeMessage;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

