/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.column;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;

public class BigDecimalColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public BigDecimalColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return BigDecimal.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 3;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (this.isSigned()) {
            return "DECIMAL";
        }
        return "DECIMAL UNSIGNED";
    }

    @Override
    public int getPrecision() {
        if (this.isSigned()) {
            return (int)(this.columnLength - (long)(this.decimals > 0 ? 2 : 1));
        }
        return (int)(this.columnLength - (long)(this.decimals > 0 ? 1 : 0));
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return new BigDecimal(buf.readAscii(length.get()));
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return new BigDecimal(buf.readAscii(length.get()));
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return new BigDecimal(buf.readAscii(length.get())).intValue() != 0;
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeBooleanText(buf, length);
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str = buf.readString(length.get());
        try {
            return new BigDecimal(str).setScale(0, RoundingMode.DOWN).byteValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str, this.dataType}));
        }
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeByteText(buf, length);
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result;
        String str = buf.readString(length.get());
        try {
            result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Short", str));
        }
        if ((long)((short)result) != result || result < 0L && !this.isSigned()) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeShortText(buf, length);
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result;
        String str = buf.readString(length.get());
        try {
            result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", str));
        }
        int res = (int)result;
        if ((long)res != result || result < 0L && !this.isSigned()) {
            throw new SQLDataException("integer overflow");
        }
        return res;
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeIntText(buf, length);
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str2 = buf.readAscii(length.get());
        try {
            return new BigDecimal(str2).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", str2));
        }
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str = buf.readString(length.get());
        try {
            return new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", str));
        }
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Float.parseFloat(buf.readAscii(length.get()));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return new BigDecimal(buf.readAscii(length.get())).floatValue();
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length.get()));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return new BigDecimal(buf.readAscii(length.get())).doubleValue();
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

