/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtil {
    public static final int REQUIRED_SHULKER_SLOT_ANY = -1;
    public static final int REQUIRED_SHULKER_SLOT_NONE = -2;

    public static int getAmount(ItemStack item, Inventory inventory) {
        return InventoryUtil.getAmount(item, inventory, InventoryUtil.getDefaultRequiredShulkerSlot(inventory));
    }

    public static int getAmount(ItemStack item, Inventory inventory, int requiredShulkerSlot) {
        if (inventory.getType() == null) {
            return Integer.MAX_VALUE;
        }
        if (inventory instanceof AdminInventory) {
            return Integer.MAX_VALUE;
        }
        int itemAmount = 0;
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                itemAmount += content.getAmount();
                continue;
            }
            if (requiredShulkerSlot != -1 && requiredShulkerSlot != i || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (shulkerContent == null || !item.isSimilar(shulkerContent)) continue;
                itemAmount += shulkerContent.getAmount();
            }
        }
        return itemAmount;
    }

    public static boolean isEmpty(Inventory inventory) {
        for (ItemStack stack : inventory.getContents()) {
            if (MaterialUtil.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasItems(ItemStack item, int amount, Inventory inventory) {
        return InventoryUtil.hasItems(item, amount, inventory, InventoryUtil.getDefaultRequiredShulkerSlot(inventory));
    }

    public static boolean hasItems(ItemStack item, int amount, Inventory inventory, int requiredShulkerSlot) {
        if (inventory.getType() == null) {
            return true;
        }
        if (inventory instanceof AdminInventory) {
            return true;
        }
        int missingAmount = amount;
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                if ((missingAmount -= content.getAmount()) > 0) continue;
                return true;
            }
            if (requiredShulkerSlot != -1 && requiredShulkerSlot != i || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (shulkerContent == null || !item.isSimilar(shulkerContent) || (missingAmount -= shulkerContent.getAmount()) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFreeSpace(ItemStack item, Inventory inventory) {
        return InventoryUtil.getFreeSpace(item, inventory, InventoryUtil.getDefaultRequiredShulkerSlot(inventory));
    }

    public static int getFreeSpace(ItemStack item, Inventory inventory, int requiredShulkerSlot) {
        if (inventory.getType() == null) {
            return Integer.MAX_VALUE;
        }
        if (inventory instanceof AdminInventory) {
            return Integer.MAX_VALUE;
        }
        boolean canBeStoredInShulker = BlockUtil.canBeStoredInShulkerBox(item.getType());
        if (!canBeStoredInShulker && inventory.getHolder() instanceof ShulkerBox) {
            return 0;
        }
        int freeSpace = 0;
        int maxStack = Math.max(item.getMaxStackSize(), 1);
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                freeSpace += Math.max(maxStack - content.getAmount(), 0);
                continue;
            }
            if (MaterialUtil.isEmpty(content)) {
                freeSpace += maxStack;
                continue;
            }
            if (requiredShulkerSlot != -1 && requiredShulkerSlot != i || !canBeStoredInShulker || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (shulkerContent != null && item.isSimilar(shulkerContent)) {
                    freeSpace += Math.max(maxStack - shulkerContent.getAmount(), 0);
                    continue;
                }
                if (!MaterialUtil.isEmpty(shulkerContent)) continue;
                freeSpace += maxStack;
            }
        }
        return freeSpace;
    }

    public static boolean fits(ItemStack item, int amount, Inventory inventory) {
        return InventoryUtil.fits(item, amount, inventory, InventoryUtil.getDefaultRequiredShulkerSlot(inventory));
    }

    public static boolean fits(ItemStack item, int amount, Inventory inventory, int requiredShulkerSlot) {
        if (inventory.getType() == null) {
            return true;
        }
        if (inventory instanceof AdminInventory) {
            return true;
        }
        if (inventory.getMaxStackSize() == Integer.MAX_VALUE) {
            return true;
        }
        boolean canBeStoredInShulker = BlockUtil.canBeStoredInShulkerBox(item.getType());
        int left = amount;
        if (!canBeStoredInShulker && inventory.getHolder() instanceof ShulkerBox) {
            return false;
        }
        int maxStack = Math.max(item.getMaxStackSize(), 1);
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                if ((left -= Math.max(maxStack - content.getAmount(), 0)) > 0) continue;
                return true;
            }
            if (MaterialUtil.isEmpty(content)) {
                if ((left -= maxStack) > 0) continue;
                return true;
            }
            if (requiredShulkerSlot != -1 && requiredShulkerSlot != i || !canBeStoredInShulker || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (!(shulkerContent != null && item.isSimilar(shulkerContent) ? (left -= Math.max(maxStack - shulkerContent.getAmount(), 0)) <= 0 : MaterialUtil.isEmpty(shulkerContent) && (left -= maxStack) <= 0)) continue;
                return true;
            }
        }
        return false;
    }

    public static int add(ItemStack item, int amount, Inventory inventory, boolean stackTo64) {
        return InventoryUtil.add(item, amount, inventory, stackTo64, InventoryUtil.getDefaultRequiredShulkerSlot(inventory));
    }

    public static int add(ItemStack item, int amount, Inventory inventory, boolean stackTo64, int requiredShulkerSlot) {
        ItemStack content;
        int currentSlot;
        if (amount <= 0) {
            return 0;
        }
        if (inventory.getType() == null) {
            return 0;
        }
        if (inventory instanceof AdminInventory) {
            return 0;
        }
        int maxStackSize = stackTo64 ? 64 : item.getMaxStackSize();
        int left = amount;
        ItemStack[] contents = inventory.getStorageContents();
        boolean contentChanged = false;
        int contentsLength = contents.length;
        boolean canBeStoredInShulker = BlockUtil.canBeStoredInShulkerBox(item.getType());
        if (!canBeStoredInShulker && inventory.getHolder() instanceof ShulkerBox) {
            return left;
        }
        if (canBeStoredInShulker) {
            for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
                BlockStateMeta bsm;
                BlockState blockState;
                ItemMeta meta;
                content = contents[currentSlot];
                if (requiredShulkerSlot != -1 && requiredShulkerSlot != currentSlot || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
                ShulkerBox shulkerBox = (ShulkerBox)blockState;
                ItemStack[] shulkerContents = shulkerBox.getSnapshotInventory().getStorageContents();
                int shulkerContentsLength = shulkerContents.length;
                boolean shulkerContentChanged = false;
                for (int currentShulkerSlot = 0; currentShulkerSlot < shulkerContentsLength && left > 0; ++currentShulkerSlot) {
                    ItemStack shulkerContent = shulkerContents[currentShulkerSlot];
                    int addHere = 0;
                    int oldAmount = 0;
                    if (shulkerContent != null && item.isSimilar(shulkerContent)) {
                        oldAmount = shulkerContent.getAmount();
                        addHere = Math.min(left, Math.max(maxStackSize - oldAmount, 0));
                    } else if (MaterialUtil.isEmpty(shulkerContent)) {
                        addHere = Math.min(left, maxStackSize);
                    }
                    if (addHere <= 0) continue;
                    left -= addHere;
                    shulkerContent = new ItemStack(item);
                    shulkerContent.setAmount(oldAmount + addHere);
                    shulkerContents[currentShulkerSlot] = shulkerContent;
                    shulkerContentChanged = true;
                }
                if (!shulkerContentChanged) continue;
                shulkerBox.getSnapshotInventory().setStorageContents(shulkerContents);
                bsm.setBlockState((BlockState)shulkerBox);
                content.setItemMeta(meta);
                contentChanged = true;
            }
        }
        for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
            content = contents[currentSlot];
            int addHere = 0;
            int oldAmount = 0;
            if (content != null && item.isSimilar(content)) {
                oldAmount = content.getAmount();
                addHere = Math.min(left, Math.max(maxStackSize - oldAmount, 0));
            } else if (MaterialUtil.isEmpty(content)) {
                addHere = Math.min(left, maxStackSize);
            }
            if (addHere <= 0) continue;
            left -= addHere;
            content = new ItemStack(item);
            content.setAmount(oldAmount + addHere);
            contents[currentSlot] = content;
            contentChanged = true;
        }
        if (contentChanged) {
            inventory.setStorageContents(contents);
        }
        return left;
    }

    public static int add(ItemStack item, int amount, Inventory inventory) {
        return InventoryUtil.add(item, amount, inventory, false);
    }

    public static int remove(ItemStack item, int amount, Inventory inventory) {
        return InventoryUtil.remove(item, amount, inventory, InventoryUtil.getDefaultRequiredShulkerSlot(inventory));
    }

    public static int remove(ItemStack item, int amount, Inventory inventory, int requiredShulkerSlot) {
        ItemStack content;
        int currentSlot;
        if (amount <= 0) {
            return 0;
        }
        if (inventory.getType() == null) {
            return 0;
        }
        if (inventory instanceof AdminInventory) {
            return 0;
        }
        int left = amount;
        ItemStack[] contents = inventory.getStorageContents();
        boolean contentChanged = false;
        int contentsLength = contents.length;
        if (BlockUtil.canBeStoredInShulkerBox(item.getType())) {
            for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
                BlockStateMeta bsm;
                BlockState blockState;
                ItemMeta meta;
                content = contents[currentSlot];
                if (requiredShulkerSlot != -1 && requiredShulkerSlot != currentSlot || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
                ShulkerBox shulkerBox = (ShulkerBox)blockState;
                ItemStack[] shulkerContents = shulkerBox.getSnapshotInventory().getStorageContents();
                int shulkerContentsLength = shulkerContents.length;
                boolean shulkerContentChanged = false;
                for (int currentShulkerSlot = 0; currentShulkerSlot < shulkerContentsLength && left > 0; ++currentShulkerSlot) {
                    ItemStack shulkerContent = shulkerContents[currentShulkerSlot];
                    if (shulkerContent == null || !item.isSimilar(shulkerContent)) continue;
                    int oldAmount = shulkerContent.getAmount();
                    int removeHere = Math.min(left, oldAmount);
                    left -= removeHere;
                    if (removeHere < oldAmount) {
                        shulkerContent = new ItemStack(item);
                        shulkerContent.setAmount(oldAmount - removeHere);
                        shulkerContents[currentShulkerSlot] = shulkerContent;
                    } else {
                        shulkerContents[currentShulkerSlot] = null;
                    }
                    shulkerContentChanged = true;
                }
                if (!shulkerContentChanged) continue;
                shulkerBox.getSnapshotInventory().setStorageContents(shulkerContents);
                bsm.setBlockState((BlockState)shulkerBox);
                content.setItemMeta(meta);
                contentChanged = true;
            }
        }
        for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
            content = contents[currentSlot];
            if (content == null || !item.isSimilar(content)) continue;
            int oldAmount = content.getAmount();
            int removeHere = Math.min(left, oldAmount);
            left -= removeHere;
            if (removeHere < oldAmount) {
                content = new ItemStack(item);
                content.setAmount(oldAmount - removeHere);
                contents[currentSlot] = content;
            } else {
                contents[currentSlot] = null;
            }
            contentChanged = true;
        }
        if (contentChanged) {
            inventory.setStorageContents(contents);
        }
        return left;
    }

    public static int getDefaultRequiredShulkerSlot(Inventory inventory) {
        if (!Properties.USE_SHULKERS_FOR_STORAGE) {
            return -2;
        }
        int requiredShulkerSlot = -1;
        if (!Properties.USE_SHULKERS_IN_ANY_SLOT_IN_THE_PLAYER_INVENTORY && inventory instanceof PlayerInventory) {
            PlayerInventory playerInventory = (PlayerInventory)inventory;
            requiredShulkerSlot = playerInventory.getHeldItemSlot();
        }
        return requiredShulkerSlot;
    }
}

