//[okio](../../../index.md)/[okio](../index.md)/[GzipSink](index.md)

# GzipSink

[jvm]\
class [GzipSink](index.md)(sink: [Sink](../-sink/index.md)) : [Sink](../-sink/index.md)

A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.

###  Sync flush

Aggressive flushing of this stream may result in reduced compression. Each call to [flush](flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.

This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](flush.md) when application behavior requires it.

## Constructors

| | |
|---|---|
| [GzipSink](-gzip-sink.md) | [jvm]<br>fun [GzipSink](-gzip-sink.md)(sink: [Sink](../-sink/index.md)) |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [flush](flush.md) | [jvm]<br>open override fun [flush](flush.md)() |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md) |
| [write](write.md) | [jvm]<br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |

## Properties

| Name | Summary |
|---|---|
| [deflater](deflater.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "deflater")<br>val [deflater](deflater.md): [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)<br>The deflater used to compress the body. |
