/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.util.SpongeUtil;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WorldGuardBlockListener
implements Listener {
    private WorldGuardPlugin plugin;

    public WorldGuardBlockListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    protected BukkitWorldConfiguration getWorldConfig(org.bukkit.World world) {
        return (BukkitWorldConfiguration)WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(BukkitAdapter.adapt((org.bukkit.World)world));
    }

    protected BukkitWorldConfiguration getWorldConfig(Player player) {
        return this.getWorldConfig(player.getWorld());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        ItemStack held;
        Player player = event.getPlayer();
        Block target = event.getBlock();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(player);
        if (!wcfg.itemDurability && (held = player.getItemInHand()).getType() != Material.AIR) {
            held.setDurability((short)0);
            player.setItemInHand(held);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Material targetId;
        org.bukkit.World world = event.getBlock().getWorld();
        Block blockFrom = event.getBlock();
        Block blockTo = event.getToBlock();
        boolean isWater = blockFrom.getType() == Material.WATER;
        boolean isLava = blockFrom.getType() == Material.LAVA;
        boolean isAir = blockFrom.getType() == Material.AIR;
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.simulateSponge && isWater) {
            int ox = blockTo.getX();
            int oy = blockTo.getY();
            int oz = blockTo.getZ();
            for (int cx = -wcfg.spongeRadius; cx <= wcfg.spongeRadius; ++cx) {
                for (int cy = -wcfg.spongeRadius; cy <= wcfg.spongeRadius; ++cy) {
                    for (int cz = -wcfg.spongeRadius; cz <= wcfg.spongeRadius; ++cz) {
                        Block sponge = world.getBlockAt(ox + cx, oy + cy, oz + cz);
                        if (sponge.getType() != Material.SPONGE || wcfg.redstoneSponges && sponge.isBlockIndirectlyPowered()) continue;
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
        if (wcfg.preventWaterDamage.size() > 0) {
            Material targetId2 = blockTo.getType();
            if ((isAir || isWater) && wcfg.preventWaterDamage.contains(BukkitAdapter.asBlockType((Material)targetId2).getId())) {
                event.setCancelled(true);
                return;
            }
        }
        if (wcfg.allowedLavaSpreadOver.size() > 0 && isLava && !wcfg.allowedLavaSpreadOver.contains(BukkitAdapter.asBlockType((Material)(targetId = blockTo.getRelative(0, -1, 0).getType())).getId())) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.highFreqFlags && isWater && WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)blockFrom.getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.WATER_FLOW}) == StateFlag.State.DENY) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.highFreqFlags && isLava && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)blockFrom.getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.LAVA_FLOW})})) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableObsidianGenerators && (isAir || isLava) && (blockTo.getType() == Material.REDSTONE_WIRE || blockTo.getType() == Material.TRIPWIRE)) {
            blockTo.setType(Material.AIR);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        int z;
        int y;
        int x;
        boolean isFireSpread;
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        Block block = event.getBlock();
        org.bukkit.World world = block.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(world);
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        boolean bl = isFireSpread = cause == BlockIgniteEvent.IgniteCause.SPREAD;
        if (wcfg.preventLightningFire && cause == BlockIgniteEvent.IgniteCause.LIGHTNING) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.preventLavaFire && cause == BlockIgniteEvent.IgniteCause.LAVA) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpread && isFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.blockLighter && (cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || cause == BlockIgniteEvent.IgniteCause.FIREBALL) && event.getPlayer() != null && !this.plugin.hasPermission((CommandSender)event.getPlayer(), "worldguard.override.lighter")) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.fireSpreadDisableToggle && isFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpreadBlocks.size() > 0 && isFireSpread && (wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType((Material)world.getBlockAt(x = block.getX(), (y = block.getY()) - 1, z = block.getZ()).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType((Material)world.getBlockAt(x + 1, y, z).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType((Material)world.getBlockAt(x - 1, y, z).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType((Material)world.getBlockAt(x, y, z - 1).getType()).getId()) || wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType((Material)world.getBlockAt(x, y, z + 1).getType()).getId()))) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions) {
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)block.getLocation()));
            if (wcfg.highFreqFlags && isFireSpread && !set.testState(null, new StateFlag[]{Flags.FIRE_SPREAD})) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.highFreqFlags && cause == BlockIgniteEvent.IgniteCause.LAVA && !set.testState(null, new StateFlag[]{Flags.LAVA_FIRE})) {
                event.setCancelled(true);
                return;
            }
            if (cause == BlockIgniteEvent.IgniteCause.FIREBALL && event.getPlayer() == null && !set.testState(null, new StateFlag[]{Flags.GHAST_FIREBALL})) {
                event.setCancelled(true);
                return;
            }
            if (cause == BlockIgniteEvent.IgniteCause.LIGHTNING && !set.testState(null, new StateFlag[]{Flags.LIGHTNING})) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block block;
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableFireSpread) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.fireSpreadDisableToggle) {
            Block block2 = event.getBlock();
            event.setCancelled(true);
            this.checkAndDestroyAround(block2.getWorld(), block2.getX(), block2.getY(), block2.getZ(), Material.FIRE);
            return;
        }
        if (wcfg.disableFireSpreadBlocks.size() > 0 && wcfg.disableFireSpreadBlocks.contains(BukkitAdapter.asBlockType((Material)(block = event.getBlock()).getType()).getId())) {
            event.setCancelled(true);
            this.checkAndDestroyAround(block.getWorld(), block.getX(), block.getY(), block.getZ(), Material.FIRE);
            return;
        }
        if (wcfg.isChestProtected(BukkitAdapter.adapt((Location)event.getBlock().getLocation()))) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions) {
            block = event.getBlock();
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)block.getLocation()));
            if (!set.testState(null, new StateFlag[]{Flags.FIRE_SPREAD})) {
                this.checkAndDestroyAround(block.getWorld(), x, y, z, Material.FIRE);
                event.setCancelled(true);
            }
        }
    }

    private void checkAndDestroyAround(org.bukkit.World world, int x, int y, int z, Material required) {
        this.checkAndDestroy(world, x, y, z + 1, required);
        this.checkAndDestroy(world, x, y, z - 1, required);
        this.checkAndDestroy(world, x, y + 1, z, required);
        this.checkAndDestroy(world, x, y - 1, z, required);
        this.checkAndDestroy(world, x + 1, y, z, required);
        this.checkAndDestroy(world, x - 1, y, z, required);
    }

    private void checkAndDestroy(org.bukkit.World world, int x, int y, int z, Material required) {
        if (world.getBlockAt(x, y, z).getType() == required) {
            world.getBlockAt(x, y, z).setType(Material.AIR);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material id = event.getBlock().getType();
        if (id == Material.GRAVEL && wcfg.noPhysicsGravel) {
            event.setCancelled(true);
            return;
        }
        if (id == Material.SAND && wcfg.noPhysicsSand) {
            event.setCancelled(true);
            return;
        }
        if (id == Material.NETHER_PORTAL && wcfg.allowPortalAnywhere) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.ropeLadders && event.getBlock().getType() == Material.LADDER && event.getBlock().getRelative(0, 1, 0).getType() == Material.LADDER) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block target = event.getBlock();
        org.bukkit.World world = target.getWorld();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(world);
        if (wcfg.simulateSponge && target.getType() == Material.SPONGE) {
            if (wcfg.redstoneSponges && target.isBlockIndirectlyPowered()) {
                return;
            }
            int ox = target.getX();
            int oy = target.getY();
            int oz = target.getZ();
            SpongeUtil.clearSpongeWater((World)BukkitAdapter.adapt((org.bukkit.World)world), (int)ox, (int)oy, (int)oz);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        Block blockTo = event.getBlock();
        org.bukkit.World world = blockTo.getWorld();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(world);
        if (wcfg.simulateSponge && wcfg.redstoneSponges) {
            int ox = blockTo.getX();
            int oy = blockTo.getY();
            int oz = blockTo.getZ();
            for (int cx = -1; cx <= 1; ++cx) {
                for (int cy = -1; cy <= 1; ++cy) {
                    for (int cz = -1; cz <= 1; ++cz) {
                        Block sponge = world.getBlockAt(ox + cx, oy + cy, oz + cz);
                        if (sponge.getType() == Material.SPONGE && sponge.isBlockIndirectlyPowered()) {
                            SpongeUtil.clearSpongeWater((World)BukkitAdapter.adapt((org.bukkit.World)world), (int)(ox + cx), (int)(oy + cy), (int)(oz + cz));
                            continue;
                        }
                        if (sponge.getType() != Material.SPONGE || sponge.isBlockIndirectlyPowered()) continue;
                        SpongeUtil.addSpongeWater((World)BukkitAdapter.adapt((org.bukkit.World)world), (int)(ox + cx), (int)(oy + cy), (int)(oz + cz));
                    }
                }
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.disableLeafDecay) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.LEAF_DECAY})})) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material type = event.getNewState().getType();
        if (event instanceof EntityBlockFormEvent) {
            if (((EntityBlockFormEvent)event).getEntity() instanceof Snowman && wcfg.disableSnowmanTrails) {
                event.setCancelled(true);
                return;
            }
            return;
        }
        if (Tag.ICE.isTagged((Keyed)type)) {
            if (wcfg.disableIceFormation) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.ICE_FORM})})) {
                event.setCancelled(true);
                return;
            }
        }
        if (type == Material.SNOW) {
            Material targetId;
            if (wcfg.disableSnowFormation) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.allowedSnowFallOver.size() > 0 && !wcfg.allowedSnowFallOver.contains(BukkitAdapter.asBlockType((Material)(targetId = event.getBlock().getRelative(0, -1, 0).getType())).getId())) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.SNOW_FALL})})) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        Material fromType = event.getSource().getType();
        if (Materials.isMushroom(fromType)) {
            if (wcfg.disableMushroomSpread) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.MUSHROOMS})})) {
                event.setCancelled(true);
                return;
            }
        }
        if (fromType == Material.GRASS_BLOCK) {
            if (wcfg.disableGrassGrowth) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.GRASS_SPREAD})})) {
                event.setCancelled(true);
                return;
            }
        }
        if (fromType == Material.MYCELIUM) {
            if (wcfg.disableMyceliumSpread) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.MYCELIUM_SPREAD})})) {
                event.setCancelled(true);
                return;
            }
        }
        if (fromType == Material.VINE) {
            if (wcfg.disableVineGrowth) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.VINE_GROWTH})})) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        BukkitWorldConfiguration wcfg = this.getWorldConfig(event.getBlock().getWorld());
        if (Tag.ICE.isTagged((Keyed)event.getBlock().getType())) {
            if (wcfg.disableIceMelting) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.ICE_MELT})})) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getBlock().getType() == Material.SNOW) {
            if (wcfg.disableSnowMelting) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.SNOW_MELT})})) {
                event.setCancelled(true);
                return;
            }
        } else if (event.getBlock().getType() == Material.FARMLAND) {
            if (wcfg.disableSoilDehydration) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions && !StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (RegionAssociable)null, new StateFlag[]{Flags.SOIL_DRY})})) {
                event.setCancelled(true);
                return;
            }
        }
    }
}

