/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.config.ConfigurationManager;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ToggleCommands {
    private final WorldGuardPlugin plugin;

    public ToggleCommands(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"stopfire"}, usage="[<world>]", desc="Disables all fire spread temporarily", max=1)
    @CommandPermissions(value={"worldguard.fire-toggle.stop"})
    public void stopFire(CommandContext args, CommandSender sender) throws CommandException {
        World world = args.argsLength() == 0 ? this.plugin.checkPlayer(sender).getWorld() : this.plugin.matchWorld(sender, args.getString(0));
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(BukkitAdapter.adapt((World)world));
        if (!wcfg.fireSpreadDisableToggle) {
            this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + "Fire spread has been globally disabled for '" + world.getName() + "' by " + this.plugin.toName(sender) + ".");
        } else {
            sender.sendMessage(ChatColor.YELLOW + "Fire spread was already globally disabled.");
        }
        wcfg.fireSpreadDisableToggle = true;
    }

    @Command(aliases={"allowfire"}, usage="[<world>]", desc="Allows all fire spread temporarily", max=1)
    @CommandPermissions(value={"worldguard.fire-toggle.stop"})
    public void allowFire(CommandContext args, CommandSender sender) throws CommandException {
        World world = args.argsLength() == 0 ? this.plugin.checkPlayer(sender).getWorld() : this.plugin.matchWorld(sender, args.getString(0));
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(BukkitAdapter.adapt((World)world));
        if (wcfg.fireSpreadDisableToggle) {
            this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + "Fire spread has been globally for '" + world.getName() + "' re-enabled by " + this.plugin.toName(sender) + ".");
        } else {
            sender.sendMessage(ChatColor.YELLOW + "Fire spread was already globally enabled.");
        }
        wcfg.fireSpreadDisableToggle = false;
    }

    @Command(aliases={"halt-activity", "stoplag", "haltactivity"}, desc="Attempts to cease as much activity in order to stop lag", flags="cis", max=0)
    @CommandPermissions(value={"worldguard.halt-activity"})
    public void stopLag(CommandContext args, CommandSender sender) throws CommandException {
        ConfigurationManager configManager = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        if (args.hasFlag('i')) {
            if (configManager.activityHaltToggle) {
                sender.sendMessage(ChatColor.YELLOW + "ALL intensive server activity is not allowed.");
            } else {
                sender.sendMessage(ChatColor.YELLOW + "ALL intensive server activity is allowed.");
            }
        } else {
            boolean bl = configManager.activityHaltToggle = !args.hasFlag('c');
            if (configManager.activityHaltToggle) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.YELLOW + "ALL intensive server activity halted.");
                }
                if (!args.hasFlag('s')) {
                    this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + "ALL intensive server activity halted by " + this.plugin.toName(sender) + ".");
                } else {
                    sender.sendMessage(ChatColor.YELLOW + "(Silent) ALL intensive server activity halted by " + this.plugin.toName(sender) + ".");
                }
                for (World world : this.plugin.getServer().getWorlds()) {
                    int removed = 0;
                    for (Entity entity : world.getEntities()) {
                        if (!BukkitUtil.isIntensiveEntity(entity)) continue;
                        entity.remove();
                        ++removed;
                    }
                    if (removed <= 10) continue;
                    sender.sendMessage("" + removed + " entities (>10) auto-removed from " + world.getName());
                }
            } else if (!args.hasFlag('s')) {
                this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + "ALL intensive server activity is now allowed.");
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.YELLOW + "ALL intensive server activity is now allowed.");
                }
            } else {
                sender.sendMessage(ChatColor.YELLOW + "(Silent) ALL intensive server activity is now allowed.");
            }
        }
    }
}

