/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.managers.migration.Migration;
import com.sk89q.worldguard.protection.managers.migration.MigrationException;
import com.sk89q.worldguard.protection.managers.migration.UUIDMigration;
import com.sk89q.worldguard.protection.managers.storage.RegionDriver;
import com.sk89q.worldguard.protection.regions.QueryCache;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class BukkitRegionContainer
extends RegionContainer {
    private static final Logger log = Logger.getLogger(BukkitRegionContainer.class.getCanonicalName());
    private static final int CACHE_INVALIDATION_INTERVAL = 2;
    private final WorldGuardPlugin plugin;

    public BukkitRegionContainer(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        super.initialize();
        this.loadWorlds();
        this.autoMigrate();
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onWorldLoad(WorldLoadEvent event) {
                BukkitRegionContainer.this.load(event.getWorld());
            }

            @EventHandler
            public void onWorldUnload(WorldUnloadEvent event) {
                BukkitRegionContainer.this.unload(event.getWorld());
            }

            @EventHandler
            public void onChunkLoad(ChunkLoadEvent event) {
                RegionManager manager = BukkitRegionContainer.this.get(BukkitAdapter.adapt((World)event.getWorld()));
                if (manager != null) {
                    Chunk chunk = event.getChunk();
                    manager.loadChunk(BlockVector2.at((int)chunk.getX(), (int)chunk.getZ()));
                }
            }

            @EventHandler
            public void onChunkUnload(ChunkUnloadEvent event) {
                RegionManager manager = BukkitRegionContainer.this.get(BukkitAdapter.adapt((World)event.getWorld()));
                if (manager != null) {
                    Chunk chunk = event.getChunk();
                    manager.unloadChunk(BlockVector2.at((int)chunk.getX(), (int)chunk.getZ()));
                }
            }
        }, (Plugin)this.plugin);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> ((QueryCache)this.cache).invalidateAll(), 2L, 2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unload() {
        Object object = this.lock;
        synchronized (object) {
            this.container.unloadAll();
        }
    }

    public RegionDriver getDriver() {
        return this.container.getDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWorlds() {
        Object object = this.lock;
        synchronized (object) {
            for (World world : Bukkit.getServer().getWorlds()) {
                this.load(world);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            this.unload();
            this.loadWorlds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RegionManager load(World world) {
        RegionManager manager;
        Preconditions.checkNotNull((Object)world);
        BukkitWorldConfiguration config = (BukkitWorldConfiguration)WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(BukkitAdapter.adapt((World)world));
        if (!config.useRegions) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            manager = this.container.load(world.getName());
            if (manager != null) {
                ArrayList<BlockVector2> positions = new ArrayList<BlockVector2>();
                for (Chunk chunk : world.getLoadedChunks()) {
                    positions.add(BlockVector2.at((int)chunk.getX(), (int)chunk.getZ()));
                }
                manager.loadChunks(positions);
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unload(World world) {
        Preconditions.checkNotNull((Object)world);
        Object object = this.lock;
        synchronized (object) {
            this.container.unload(world.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Migration migration) throws MigrationException {
        Preconditions.checkNotNull((Object)migration);
        Object object = this.lock;
        synchronized (object) {
            try {
                log.info("Unloading and saving region data that is currently loaded...");
                this.unload();
                migration.migrate();
            }
            finally {
                log.info("Loading region data for loaded worlds...");
                this.loadWorlds();
            }
        }
    }

    private void autoMigrate() {
        ConfigurationManager config = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        if (config.migrateRegionsToUuid) {
            RegionDriver driver = this.getDriver();
            UUIDMigration migrator = new UUIDMigration(driver, WorldGuard.getInstance().getProfileService(), WorldGuard.getInstance().getFlagRegistry());
            migrator.setKeepUnresolvedNames(config.keepUnresolvedNames);
            try {
                this.migrate((Migration)migrator);
                log.info("Regions saved after UUID migration! This won't happen again unless you change the relevant configuration option in WorldGuard's config.");
                config.disableUuidMigration();
            }
            catch (MigrationException e) {
                log.log(Level.WARNING, "Failed to execute the migration", e);
            }
        }
    }
}

