/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.commands.FutureProgressListener;
import com.sk89q.worldguard.bukkit.commands.MessageFutureCallback;
import com.sk89q.worldguard.util.task.FutureForwardingTask;
import com.sk89q.worldguard.util.task.Task;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class AsyncCommandHelper {
    private final ListenableFuture<?> future;
    private final WorldGuardPlugin plugin;
    private final CommandSender sender;
    @Nullable
    private Object[] formatArgs;

    private AsyncCommandHelper(ListenableFuture<?> future, WorldGuardPlugin plugin, CommandSender sender) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)sender);
        this.future = future;
        this.plugin = plugin;
        this.sender = sender;
    }

    public AsyncCommandHelper formatUsing(Object ... args) {
        this.formatArgs = args;
        return this;
    }

    private String format(String message) {
        if (this.formatArgs != null) {
            return String.format(message, this.formatArgs);
        }
        return message;
    }

    public AsyncCommandHelper registerWithSupervisor(String description) {
        WorldGuard.getInstance().getSupervisor().monitor((Task)FutureForwardingTask.create(this.future, (String)this.format(description), (Object)this.sender));
        return this;
    }

    public AsyncCommandHelper sendMessageAfterDelay(String message) {
        FutureProgressListener.addProgressListener(this.future, this.sender, this.format(message));
        return this;
    }

    public AsyncCommandHelper thenRespondWith(String success, String failure) {
        Futures.addCallback(this.future, new MessageFutureCallback.Builder(this.plugin, this.sender).onSuccess(this.format(success)).onFailure(this.format(failure)).build());
        return this;
    }

    public AsyncCommandHelper thenTellErrorsOnly(String failure) {
        Futures.addCallback(this.future, new MessageFutureCallback.Builder(this.plugin, this.sender).onFailure(this.format(failure)).build());
        return this;
    }

    public AsyncCommandHelper forRegionDataLoad(World world, boolean silent) {
        Preconditions.checkNotNull((Object)world);
        this.formatUsing(world.getName());
        this.registerWithSupervisor("Loading region data for '%s'");
        if (silent) {
            this.thenTellErrorsOnly("Failed to load regions '%s'");
        } else {
            this.sendMessageAfterDelay("(Please wait... loading the region data for '%s')");
            this.thenRespondWith("Loaded region data for '%s'", "Failed to load regions '%s'");
        }
        return this;
    }

    public AsyncCommandHelper forRegionDataSave(World world, boolean silent) {
        Preconditions.checkNotNull((Object)world);
        this.formatUsing(world.getName());
        this.registerWithSupervisor("Saving region data for '%s'");
        if (silent) {
            this.thenTellErrorsOnly("Failed to save regions '%s'");
        } else {
            this.sendMessageAfterDelay("(Please wait... saving the region data for '%s')");
            this.thenRespondWith("Saved region data for '%s'", "Failed to load regions '%s'");
        }
        return this;
    }

    public static AsyncCommandHelper wrap(ListenableFuture<?> future, WorldGuardPlugin plugin, CommandSender sender) {
        return new AsyncCommandHelper(future, plugin, sender);
    }
}

