/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.player.ProcessPlayerEvent;
import com.sk89q.worldguard.bukkit.util.Events;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.GameModeFlag;
import com.sk89q.worldguard.util.command.CommandFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TravelAgent;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldGuardPlayerListener
implements Listener {
    private static final Logger log = Logger.getLogger(WorldGuardPlayerListener.class.getCanonicalName());
    private static final Pattern opPattern = Pattern.compile("^/(?:bukkit:)?op(?:\\s.*)?$", 2);
    private WorldGuardPlugin plugin;

    public WorldGuardPlayerListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        GameModeFlag handler;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(localPlayer.getWorld());
        Session session = WorldGuard.getInstance().getPlatform().getSessionManager().getIfPresent(localPlayer);
        if (session != null && (handler = (GameModeFlag)session.getHandler(GameModeFlag.class)) != null && wcfg.useRegions && !WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld())) {
            GameMode expected = handler.getSetGameMode();
            if (handler.getOriginalGameMode() != null && expected != null && expected != BukkitAdapter.adapt((org.bukkit.GameMode)event.getNewGameMode())) {
                log.info("Game mode change on " + player.getName() + " has been blocked due to the region GAMEMODE flag");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        org.bukkit.World world = player.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(localPlayer.getWorld());
        if (cfg.activityHaltToggle) {
            player.sendMessage(ChatColor.YELLOW + "Intensive server activity has been HALTED.");
            int removed = 0;
            for (Entity entity : world.getEntities()) {
                if (!BukkitUtil.isIntensiveEntity(entity)) continue;
                entity.remove();
                ++removed;
            }
            if (removed > 10) {
                log.info("Halt-Act: " + removed + " entities (>10) auto-removed from " + player.getWorld().toString());
            }
        }
        if (wcfg.fireSpreadDisableToggle) {
            player.sendMessage(ChatColor.YELLOW + "Fire spread is currently globally disabled for this world.");
        }
        Events.fire(new ProcessPlayerEvent(player));
        WorldGuard.getInstance().getPlatform().getSessionManager().get(localPlayer);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(localPlayer.getWorld());
        if (wcfg.useRegions) {
            if (!StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(localPlayer.getLocation(), localPlayer, new StateFlag[]{Flags.SEND_CHAT})})) {
                player.sendMessage(ChatColor.RED + "You don't have permission to chat in this region!");
                event.setCancelled(true);
                return;
            }
            Iterator i = event.getRecipients().iterator();
            while (i.hasNext()) {
                Player rPlayer = (Player)i.next();
                LocalPlayer rLocal = this.plugin.wrapPlayer(rPlayer);
                if (StateFlag.test((StateFlag.State[])new StateFlag.State[]{WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().queryState(rLocal.getLocation(), rLocal, new StateFlag[]{Flags.RECEIVE_CHAT})})) continue;
                i.remove();
            }
            if (event.getRecipients().size() == 0) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        String hostKey = (String)cfg.hostKeys.get(player.getUniqueId().toString());
        if (hostKey == null) {
            hostKey = (String)cfg.hostKeys.get(player.getName().toLowerCase());
        }
        if (hostKey != null) {
            String hostname = event.getHostname();
            int colonIndex = hostname.indexOf(58);
            if (colonIndex != -1) {
                hostname = hostname.substring(0, colonIndex);
            }
            if (!(hostname.equals(hostKey) || cfg.hostKeysAllowFMLClients && hostname.equals(hostKey + "\u0000FML\u0000"))) {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "You did not join with the valid host key!");
                log.warning("WorldGuard host key check: " + player.getName() + " joined with '" + hostname + "' but '" + hostKey + "' was expected. Kicked!");
                return;
            }
        }
        if (cfg.deopOnJoin) {
            player.setOp(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        org.bukkit.World world = player.getWorld();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            this.handleBlockRightClick(event);
        } else if (event.getAction() == Action.PHYSICAL) {
            this.handlePhysicalInteract(event);
        }
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(BukkitAdapter.adapt((org.bukkit.World)world));
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            int slot = player.getInventory().getHeldItemSlot();
            ItemStack heldItem = player.getInventory().getItem(slot);
            if (heldItem != null && heldItem.getAmount() < 0) {
                player.getInventory().setItem(slot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack removed.");
            }
        }
    }

    private void handleBlockRightClick(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getClickedBlock();
        org.bukkit.World world = block.getWorld();
        Material type = block.getType();
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(BukkitAdapter.adapt((org.bukkit.World)world));
        if ((type == Material.CHEST || type == Material.JUKEBOX || type == Material.DISPENSER || type == Material.FURNACE || type == Material.DROPPER || type == Material.BREWING_STAND || type == Material.TRAPPED_CHEST || type == Material.ENCHANTING_TABLE) && wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            for (int slot = 0; slot < 40; ++slot) {
                ItemStack heldItem = player.getInventory().getItem(slot);
                if (heldItem == null || heldItem.getAmount() >= 0) continue;
                player.getInventory().setItem(slot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack in slot #" + slot + " removed.");
            }
        }
        if (wcfg.useRegions) {
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)block.getLocation()));
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (item != null && item.getType().getKey().toString().equals(wcfg.regionWand) && this.plugin.hasPermission((CommandSender)player, "worldguard.region.wand")) {
                if (set.size() > 0) {
                    player.sendMessage(ChatColor.YELLOW + "Can you build? " + (set.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.BUILD}) ? "Yes" : "No"));
                    StringBuilder str = new StringBuilder();
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        str.append(((ProtectedRegion)it.next()).getId());
                        if (!it.hasNext()) continue;
                        str.append(", ");
                    }
                    localPlayer.print("Applicable regions: " + str.toString());
                } else {
                    localPlayer.print("WorldGuard: No defined regions here!");
                }
                event.setCancelled(true);
            }
        }
    }

    private void handlePhysicalInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        org.bukkit.World world = player.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(BukkitAdapter.adapt((org.bukkit.World)world));
        if (block.getType() == Material.FARMLAND && wcfg.disablePlayerCropTrampling) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        ApplicableRegionSet set;
        com.sk89q.worldedit.util.Location spawn;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(localPlayer.getWorld());
        if (wcfg.useRegions && (spawn = (com.sk89q.worldedit.util.Location)(set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(localPlayer.getLocation())).queryValue((RegionAssociable)localPlayer, (Flag)Flags.SPAWN_LOC)) != null) {
            event.setRespawnLocation(BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)spawn));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(BukkitAdapter.adapt((org.bukkit.World)player.getWorld()));
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            int newSlot = event.getNewSlot();
            ItemStack heldItem = player.getInventory().getItem(newSlot);
            if (heldItem != null && heldItem.getAmount() < 0) {
                player.getInventory().setItem(newSlot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack removed.");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        org.bukkit.World world = event.getFrom().getWorld();
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(localPlayer.getWorld());
        if (wcfg.useRegions) {
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)event.getTo()));
            ApplicableRegionSet setFrom = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)event.getFrom()));
            if (cfg.usePlayerTeleports && null != WorldGuard.getInstance().getPlatform().getSessionManager().get(localPlayer).testMoveTo(localPlayer, BukkitAdapter.adapt((Location)event.getTo()), MoveType.TELEPORT)) {
                event.setCancelled(true);
                return;
            }
            if (!(event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL || WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld()) || set.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.ENDERPEARL}) && setFrom.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.ENDERPEARL}))) {
                player.sendMessage(ChatColor.DARK_RED + "You're not allowed to go there.");
                event.setCancelled(true);
                return;
            }
            try {
                if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT && !WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld())) {
                    boolean allowFrom = setFrom.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.CHORUS_TELEPORT});
                    boolean allowTo = set.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.CHORUS_TELEPORT});
                    if (!allowFrom || !allowTo) {
                        player.sendMessage(ChatColor.DARK_RED + "You're not allowed to teleport " + (!allowFrom ? "from here." : "there."));
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerPortal(PlayerPortalEvent event) {
        if (event.getTo() == null) {
            return;
        }
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(event.getPlayer());
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(BukkitAdapter.adapt((org.bukkit.World)event.getTo().getWorld()));
        if (!wcfg.regionNetherPortalProtection) {
            return;
        }
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            return;
        }
        if (!event.useTravelAgent()) {
            return;
        }
        TravelAgent pta = event.getPortalTravelAgent();
        if (pta == null) {
            return;
        }
        if (pta.findPortal(event.getTo()) != null) {
            return;
        }
        int radius = pta.getCreationRadius();
        Location min = event.getTo().clone().subtract((double)radius, (double)radius, (double)radius);
        Location max = event.getTo().clone().add((double)radius, (double)radius, (double)radius);
        World world = BukkitAdapter.adapt((org.bukkit.World)event.getTo().getWorld());
        ProtectedCuboidRegion check = new ProtectedCuboidRegion("__portalcheck__", BukkitAdapter.adapt((Location)min.getBlock().getLocation()).toVector().toBlockVector(), BukkitAdapter.adapt((Location)max.getBlock().getLocation()).toVector().toBlockVector());
        if (wcfg.useRegions && !WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, world)) {
            RegionManager mgr = WorldGuard.getInstance().getPlatform().getRegionContainer().get(world);
            if (mgr == null) {
                return;
            }
            ApplicableRegionSet set = mgr.getApplicableRegions((ProtectedRegion)check);
            if (!set.testState((RegionAssociable)this.plugin.wrapPlayer(event.getPlayer()), new StateFlag[]{Flags.BUILD})) {
                event.getPlayer().sendMessage(ChatColor.RED + "Destination is in a protected area.");
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Set blockedCommands;
        ApplicableRegionSet set;
        Set allowedCommands;
        CommandFilter test;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(localPlayer.getWorld());
        if (wcfg.useRegions && !WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld()) && !(test = new CommandFilter((Collection)(allowedCommands = (Set)(set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(localPlayer.getLocation())).queryValue((RegionAssociable)localPlayer, (Flag)Flags.ALLOWED_CMDS)), (Collection)(blockedCommands = (Set)set.queryValue((RegionAssociable)localPlayer, (Flag)Flags.BLOCKED_CMDS)))).apply(event.getMessage())) {
            player.sendMessage(ChatColor.RED + event.getMessage() + " is not allowed in this area.");
            event.setCancelled(true);
            return;
        }
        if (cfg.blockInGameOp && opPattern.matcher(event.getMessage()).matches()) {
            player.sendMessage(ChatColor.RED + "/op can only be used in console (as set by a WG setting).");
            event.setCancelled(true);
            return;
        }
    }
}

