/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sk89q.bukkit.util.CommandsManagerRegistration;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.CommandUsageException;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.minecraft.util.commands.Injector;
import com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import com.sk89q.minecraft.util.commands.SimpleInjector;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitOfflinePlayer;
import com.sk89q.worldguard.bukkit.BukkitPlayer;
import com.sk89q.worldguard.bukkit.BukkitWorldGuardPlatform;
import com.sk89q.worldguard.bukkit.ProtectionQuery;
import com.sk89q.worldguard.bukkit.commands.GeneralCommands;
import com.sk89q.worldguard.bukkit.commands.ProtectionCommands;
import com.sk89q.worldguard.bukkit.commands.ToggleCommands;
import com.sk89q.worldguard.bukkit.event.player.ProcessPlayerEvent;
import com.sk89q.worldguard.bukkit.listener.BlacklistListener;
import com.sk89q.worldguard.bukkit.listener.BlockedPotionsListener;
import com.sk89q.worldguard.bukkit.listener.BuildPermissionListener;
import com.sk89q.worldguard.bukkit.listener.ChestProtectionListener;
import com.sk89q.worldguard.bukkit.listener.DebuggingListener;
import com.sk89q.worldguard.bukkit.listener.EventAbstractionListener;
import com.sk89q.worldguard.bukkit.listener.InvincibilityListener;
import com.sk89q.worldguard.bukkit.listener.PlayerModesListener;
import com.sk89q.worldguard.bukkit.listener.PlayerMoveListener;
import com.sk89q.worldguard.bukkit.listener.RegionFlagsListener;
import com.sk89q.worldguard.bukkit.listener.RegionProtectionListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardBlockListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardCommandBookListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardEntityListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardHangingListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardPlayerListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardServerListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardVehicleListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardWeatherListener;
import com.sk89q.worldguard.bukkit.listener.WorldGuardWorldListener;
import com.sk89q.worldguard.bukkit.listener.WorldRulesListener;
import com.sk89q.worldguard.bukkit.session.BukkitSessionManager;
import com.sk89q.worldguard.bukkit.util.Events;
import com.sk89q.worldguard.bukkit.util.logging.ClassSourceValidator;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.registry.SimpleFlagRegistry;
import com.sk89q.worldguard.protection.managers.storage.StorageException;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.util.UnresolvedNamesException;
import com.sk89q.worldguard.util.logging.RecordMessagePrefixer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class WorldGuardPlugin
extends JavaPlugin {
    private static WorldGuardPlugin inst;
    private static BukkitWorldGuardPlatform platform;
    private final CommandsManager<CommandSender> commands;
    private PlayerMoveListener playerMoveListener;

    public WorldGuardPlugin() {
        final WorldGuardPlugin plugin = inst = this;
        this.commands = new CommandsManager<CommandSender>(){

            public boolean hasPermission(CommandSender player, String perm) {
                return plugin.hasPermission(player, perm);
            }
        };
    }

    public static WorldGuardPlugin inst() {
        return inst;
    }

    public void onEnable() {
        this.configureLogger();
        this.getDataFolder().mkdirs();
        PermissionsResolverManager.initialize((Plugin)this);
        platform = new BukkitWorldGuardPlatform();
        WorldGuard.getInstance().setPlatform((WorldGuardPlatform)platform);
        WorldGuard.getInstance().setup();
        BukkitSessionManager sessionManager = (BukkitSessionManager)platform.getSessionManager();
        this.commands.setInjector((Injector)new SimpleInjector(new Object[]{this}));
        ClassSourceValidator verifier = new ClassSourceValidator((Plugin)this);
        verifier.reportMismatches((List<Class<?>>)ImmutableList.of(ProtectedRegion.class, ProtectedCuboidRegion.class, Flag.class));
        CommandsManagerRegistration reg = new CommandsManagerRegistration((Plugin)this, this.commands);
        reg.register(ToggleCommands.class);
        reg.register(ProtectionCommands.class);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            if (!platform.getGlobalStateManager().hasCommandBookGodMode()) {
                reg.register(GeneralCommands.class);
            }
        }, 0L);
        WorldGuard.logger.info("Loading region data...");
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)sessionManager, 20L, 20L);
        this.getServer().getPluginManager().registerEvents((Listener)sessionManager, (Plugin)this);
        new WorldGuardPlayerListener(this).registerEvents();
        new WorldGuardBlockListener(this).registerEvents();
        new WorldGuardEntityListener(this).registerEvents();
        new WorldGuardWeatherListener(this).registerEvents();
        new WorldGuardVehicleListener(this).registerEvents();
        new WorldGuardServerListener(this).registerEvents();
        new WorldGuardHangingListener(this).registerEvents();
        this.playerMoveListener = new PlayerMoveListener(this);
        this.playerMoveListener.registerEvents();
        new BlacklistListener(this).registerEvents();
        new ChestProtectionListener(this).registerEvents();
        new RegionProtectionListener(this).registerEvents();
        new RegionFlagsListener(this).registerEvents();
        new WorldRulesListener(this).registerEvents();
        new BlockedPotionsListener(this).registerEvents();
        new EventAbstractionListener(this).registerEvents();
        new PlayerModesListener(this).registerEvents();
        new BuildPermissionListener(this).registerEvents();
        new InvincibilityListener(this).registerEvents();
        if ("true".equalsIgnoreCase(System.getProperty("worldguard.debug.listener"))) {
            new DebuggingListener(this, WorldGuard.logger).registerEvents();
        }
        platform.getGlobalStateManager().updateCommandBookGodMode();
        if (this.getServer().getPluginManager().isPluginEnabled("CommandBook")) {
            this.getServer().getPluginManager().registerEvents((Listener)new WorldGuardCommandBookListener(this), (Plugin)this);
        }
        WorldGuardWorldListener worldListener = new WorldGuardWorldListener(this);
        for (World world : this.getServer().getWorlds()) {
            worldListener.initWorld(world);
        }
        worldListener.registerEvents();
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                ProcessPlayerEvent event = new ProcessPlayerEvent(player);
                Events.fire(event);
            }
        });
        ((SimpleFlagRegistry)WorldGuard.getInstance().getFlagRegistry()).setInitialized(true);
    }

    public void onDisable() {
        WorldGuard.getInstance().disable();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        try {
            this.commands.execute(cmd.getName(), args, (Object)sender, new Object[]{sender});
        }
        catch (CommandPermissionsException e) {
            sender.sendMessage(ChatColor.RED + "You don't have permission.");
        }
        catch (MissingNestedCommandException e) {
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (CommandUsageException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (WrappedCommandException e) {
            sender.sendMessage(ChatColor.RED + this.convertThrowable(e.getCause()));
        }
        catch (CommandException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
        }
        return true;
    }

    public String convertThrowable(@Nullable Throwable throwable) {
        if (throwable instanceof NumberFormatException) {
            return "Number expected, string received instead.";
        }
        if (throwable instanceof StorageException) {
            WorldGuard.logger.log(Level.WARNING, "Error loading/saving regions", throwable);
            return "Region data could not be loaded/saved: " + throwable.getMessage();
        }
        if (throwable instanceof RejectedExecutionException) {
            return "There are currently too many tasks queued to add yours. Use /wg running to list queued and running tasks.";
        }
        if (throwable instanceof CancellationException) {
            return "WorldGuard: Task was cancelled";
        }
        if (throwable instanceof InterruptedException) {
            return "WorldGuard: Task was interrupted";
        }
        if (throwable instanceof UnresolvedNamesException) {
            return throwable.getMessage();
        }
        if (throwable instanceof CommandException) {
            return throwable.getMessage();
        }
        WorldGuard.logger.log(Level.WARNING, "WorldGuard encountered an unexpected error", throwable);
        return "WorldGuard: An unexpected error occurred! Please see the server console.";
    }

    public boolean inGroup(Player player, String group) {
        try {
            return PermissionsResolverManager.getInstance().inGroup((OfflinePlayer)player, group);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public String[] getGroups(Player player) {
        try {
            return PermissionsResolverManager.getInstance().getGroups((OfflinePlayer)player);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new String[0];
        }
    }

    public String toUniqueName(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return "*Console*";
        }
        return sender.getName();
    }

    public String toName(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return "*Console*";
        }
        if (sender instanceof Player) {
            return ((Player)sender).getDisplayName();
        }
        return sender.getName();
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        if (sender.isOp()) {
            if (sender instanceof Player) {
                if (WorldGuardPlugin.platform.getGlobalStateManager().get((com.sk89q.worldedit.world.World)BukkitAdapter.adapt((World)((Player)sender).getWorld())).opPermissions) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return PermissionsResolverManager.getInstance().hasPermission(player.getWorld().getName(), (OfflinePlayer)player, perm);
        }
        return false;
    }

    public void checkPermission(CommandSender sender, String perm) throws CommandPermissionsException {
        if (!this.hasPermission(sender, perm)) {
            throw new CommandPermissionsException();
        }
    }

    public Player checkPlayer(CommandSender sender) throws CommandException {
        if (sender instanceof Player) {
            return (Player)sender;
        }
        throw new CommandException("A player is expected.");
    }

    public List<Player> matchPlayerNames(String filter) {
        Collection players = Bukkit.getServer().getOnlinePlayers();
        if ((filter = filter.toLowerCase()).charAt(0) == '@' && filter.length() >= 2) {
            filter = filter.substring(1);
            for (Player player : players) {
                if (!player.getName().equalsIgnoreCase(filter)) continue;
                ArrayList<Player> list = new ArrayList<Player>();
                list.add(player);
                return list;
            }
            return new ArrayList<Player>();
        }
        if (filter.charAt(0) == '*' && filter.length() >= 2) {
            filter = filter.substring(1);
            ArrayList<Player> list = new ArrayList<Player>();
            for (Player player : players) {
                if (!player.getName().toLowerCase().contains(filter)) continue;
                list.add(player);
            }
            return list;
        }
        ArrayList<Player> list = new ArrayList<Player>();
        for (Player player : players) {
            if (!player.getName().toLowerCase().startsWith(filter)) continue;
            list.add(player);
        }
        return list;
    }

    protected Iterable<? extends Player> checkPlayerMatch(List<? extends Player> players) throws CommandException {
        if (players.size() == 0) {
            throw new CommandException("No players matched query.");
        }
        return players;
    }

    public Iterable<? extends Player> matchPlayers(CommandSender source, String filter) throws CommandException {
        if (Bukkit.getServer().getOnlinePlayers().isEmpty()) {
            throw new CommandException("No players matched query.");
        }
        if (filter.equals("*")) {
            return this.checkPlayerMatch(Lists.newArrayList((Iterable)Bukkit.getServer().getOnlinePlayers()));
        }
        if (filter.charAt(0) == '#') {
            if (filter.equalsIgnoreCase("#world")) {
                ArrayList<Player> players = new ArrayList<Player>();
                Player sourcePlayer = this.checkPlayer(source);
                World sourceWorld = sourcePlayer.getWorld();
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    if (!player.getWorld().equals(sourceWorld)) continue;
                    players.add(player);
                }
                return this.checkPlayerMatch(players);
            }
            if (filter.equalsIgnoreCase("#near")) {
                ArrayList<Player> players = new ArrayList<Player>();
                Player sourcePlayer = this.checkPlayer(source);
                World sourceWorld = sourcePlayer.getWorld();
                Vector sourceVector = sourcePlayer.getLocation().toVector();
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    if (!player.getWorld().equals(sourceWorld) || !(player.getLocation().toVector().distanceSquared(sourceVector) < 900.0)) continue;
                    players.add(player);
                }
                return this.checkPlayerMatch(players);
            }
            throw new CommandException("Invalid group '" + filter + "'.");
        }
        List<Player> players = this.matchPlayerNames(filter);
        return this.checkPlayerMatch(players);
    }

    public Player matchSinglePlayer(CommandSender sender, String filter) throws CommandException {
        Iterator<? extends Player> players = this.matchPlayers(sender, filter).iterator();
        Player match = players.next();
        if (players.hasNext()) {
            throw new CommandException("More than one player found! Use @<name> for exact matching.");
        }
        return match;
    }

    public CommandSender matchPlayerOrConsole(CommandSender sender, String filter) throws CommandException {
        if (filter.equalsIgnoreCase("#console") || filter.equalsIgnoreCase("*console*") || filter.equalsIgnoreCase("!")) {
            return this.getServer().getConsoleSender();
        }
        return this.matchSinglePlayer(sender, filter);
    }

    public Iterable<Player> matchPlayers(Player player) {
        return Arrays.asList(player);
    }

    public World matchWorld(CommandSender sender, String filter) throws CommandException {
        List worlds = this.getServer().getWorlds();
        if (filter.charAt(0) == '#') {
            if (filter.equalsIgnoreCase("#main")) {
                return (World)worlds.get(0);
            }
            if (filter.equalsIgnoreCase("#normal")) {
                for (World world : worlds) {
                    if (world.getEnvironment() != World.Environment.NORMAL) continue;
                    return world;
                }
                throw new CommandException("No normal world found.");
            }
            if (filter.equalsIgnoreCase("#nether")) {
                for (World world : worlds) {
                    if (world.getEnvironment() != World.Environment.NETHER) continue;
                    return world;
                }
                throw new CommandException("No nether world found.");
            }
            if (filter.matches("^#player$")) {
                String[] parts = filter.split(":", 2);
                if (parts.length == 1) {
                    throw new CommandException("Argument expected for #player.");
                }
                return this.matchPlayers(sender, parts[1]).iterator().next().getWorld();
            }
            throw new CommandException("Invalid identifier '" + filter + "'.");
        }
        for (World world : worlds) {
            if (!world.getName().equals(filter)) continue;
            return world;
        }
        throw new CommandException("No world by that exact name found.");
    }

    public WorldEditPlugin getWorldEdit() throws CommandException {
        Plugin worldEdit = this.getServer().getPluginManager().getPlugin("WorldEdit");
        if (worldEdit == null) {
            throw new CommandException("WorldEdit does not appear to be installed.");
        }
        if (worldEdit instanceof WorldEditPlugin) {
            return (WorldEditPlugin)worldEdit;
        }
        throw new CommandException("WorldEdit detection failed (report error).");
    }

    public LocalPlayer wrapPlayer(Player player) {
        return new BukkitPlayer(this, player);
    }

    public LocalPlayer wrapPlayer(Player player, boolean silenced) {
        return new BukkitPlayer(this, player, silenced);
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof Player) {
            return this.wrapPlayer((Player)sender);
        }
        try {
            return new BukkitCommandSender(this.getWorldEdit(), sender);
        }
        catch (CommandException e) {
            e.printStackTrace();
            return null;
        }
    }

    public LocalPlayer wrapOfflinePlayer(OfflinePlayer player) {
        return new BukkitOfflinePlayer(player);
    }

    public ProtectionQuery createProtectionQuery() {
        return new ProtectionQuery();
    }

    private void configureLogger() {
        RecordMessagePrefixer.register((Logger)Logger.getLogger("com.sk89q.worldguard"), (String)"[WorldGuard] ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultConfiguration(File actual, String defaultName) {
        File parent = actual.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (actual.exists()) {
            return;
        }
        InputStream input = null;
        try {
            JarFile file = new JarFile(this.getFile());
            ZipEntry copy = file.getEntry("defaults/" + defaultName);
            if (copy == null) {
                throw new FileNotFoundException();
            }
            input = file.getInputStream(copy);
        }
        catch (IOException e) {
            WorldGuard.logger.severe("Unable to read default configuration: " + defaultName);
        }
        if (input != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(actual);
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = input.read(buf)) > 0) {
                    output.write(buf, 0, length);
                }
                WorldGuard.logger.info("Default configuration file written: " + actual.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public PlayerMoveListener getPlayerMoveListener() {
        return this.playerMoveListener;
    }
}

