/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.entity.SpawnEntityEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import com.sk89q.worldguard.config.WorldConfiguration;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class WorldRulesListener
extends AbstractListener {
    public WorldRulesListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSpawnEntity(SpawnEntityEvent event) {
        if (event.getEffectiveType() == EntityType.EXPERIENCE_ORB) {
            WorldConfiguration config = WorldRulesListener.getWorldConfig(BukkitAdapter.adapt((World)event.getWorld()));
            if (config.disableExpDrops) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPotionEffect(EntityPotionEffectEvent event) {
        if (event.getCause() == EntityPotionEffectEvent.Cause.CONDUIT) {
            WorldConfiguration config = WorldRulesListener.getWorldConfig(BukkitAdapter.adapt((World)event.getEntity().getWorld()));
            if (config.disableConduitEffects) {
                event.setCancelled(true);
            }
        }
    }
}

