/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.DataConverters_1_14_R3;
import com.sk89q.worldedit.bukkit.adapter.impl.FakePlayer_v1_14_R3;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.v1_14_R1.BaseBlockPosition;
import net.minecraft.server.v1_14_R1.Block;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.BlockStateBoolean;
import net.minecraft.server.v1_14_R1.BlockStateDirection;
import net.minecraft.server.v1_14_R1.BlockStateEnum;
import net.minecraft.server.v1_14_R1.BlockStateInteger;
import net.minecraft.server.v1_14_R1.BlockStateList;
import net.minecraft.server.v1_14_R1.Chunk;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumDirection;
import net.minecraft.server.v1_14_R1.EnumHand;
import net.minecraft.server.v1_14_R1.EnumInteractionResult;
import net.minecraft.server.v1_14_R1.IBlockData;
import net.minecraft.server.v1_14_R1.IBlockState;
import net.minecraft.server.v1_14_R1.IMaterial;
import net.minecraft.server.v1_14_R1.INamable;
import net.minecraft.server.v1_14_R1.IRegistry;
import net.minecraft.server.v1_14_R1.ItemActionContext;
import net.minecraft.server.v1_14_R1.MinecraftKey;
import net.minecraft.server.v1_14_R1.MovingObjectPositionBlock;
import net.minecraft.server.v1_14_R1.NBTBase;
import net.minecraft.server.v1_14_R1.NBTTagByte;
import net.minecraft.server.v1_14_R1.NBTTagByteArray;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NBTTagDouble;
import net.minecraft.server.v1_14_R1.NBTTagEnd;
import net.minecraft.server.v1_14_R1.NBTTagFloat;
import net.minecraft.server.v1_14_R1.NBTTagInt;
import net.minecraft.server.v1_14_R1.NBTTagIntArray;
import net.minecraft.server.v1_14_R1.NBTTagList;
import net.minecraft.server.v1_14_R1.NBTTagLong;
import net.minecraft.server.v1_14_R1.NBTTagLongArray;
import net.minecraft.server.v1_14_R1.NBTTagShort;
import net.minecraft.server.v1_14_R1.NBTTagString;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityStatus;
import net.minecraft.server.v1_14_R1.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_14_R1.TileEntity;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_14_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public final class Spigot_v1_14_R3
implements BukkitImplAdapter {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field nbtListTagListField;
    private final Method nbtCreateTagMethod;
    private LoadingCache<WorldServer, FakePlayer_v1_14_R3> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(FakePlayer_v1_14_R3::new));

    public Spigot_v1_14_R3() throws NoSuchFieldException, NoSuchMethodException {
        CraftServer.class.cast(Bukkit.getServer());
        if (this.getDataVersion() < 1962) {
            throw new UnsupportedClassVersionError("Not 1.14.2!");
        }
        this.nbtListTagListField = NBTTagList.class.getDeclaredField("list");
        this.nbtListTagListField.setAccessible(true);
        this.nbtCreateTagMethod = NBTBase.class.getDeclaredMethod("createTag", Byte.TYPE);
        this.nbtCreateTagMethod.setAccessible(true);
        new DataConverters_1_14_R3(this.getDataVersion(), this).build(ForkJoinPool.commonPool());
    }

    @Override
    public int getDataVersion() {
        return CraftMagicNumbers.INSTANCE.getDataVersion();
    }

    @Override
    public DataFixer getDataFixer() {
        return DataConverters_1_14_R3.INSTANCE;
    }

    private static void readTagIntoTileEntity(NBTTagCompound tag, TileEntity tileEntity) {
        tileEntity.load(tag);
    }

    private static void readTileEntityIntoTag(TileEntity tileEntity, NBTTagCompound tag) {
        tileEntity.save(tag);
    }

    @Nullable
    private static String getEntityId(net.minecraft.server.v1_14_R1.Entity entity) {
        MinecraftKey minecraftkey = EntityTypes.getName((EntityTypes)entity.getEntityType());
        return minecraftkey == null ? null : minecraftkey.toString();
    }

    @Nullable
    private static net.minecraft.server.v1_14_R1.Entity createEntityFromId(String id, World world) {
        return EntityTypes.a((String)id).map(t -> t.a(world)).orElse(null);
    }

    private static void readTagIntoEntity(NBTTagCompound tag, net.minecraft.server.v1_14_R1.Entity entity) {
        entity.f(tag);
    }

    private static void readEntityIntoTag(net.minecraft.server.v1_14_R1.Entity entity, NBTTagCompound tag) {
        entity.save(tag);
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        Block mcBlock = (Block)IRegistry.BLOCK.get(MinecraftKey.a((String)state.getBlockType().getId()));
        IBlockData newState = mcBlock.getBlockData();
        Map states = state.getStates();
        newState = this.applyProperties((BlockStateList<Block, IBlockData>)mcBlock.getStates(), newState, states);
        int combinedId = Block.getCombinedId((IBlockData)newState);
        return combinedId == 0 && state.getBlockType() != BlockTypes.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public BaseBlock getBlock(Location location) {
        TileEntity te;
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WorldServer handle = craftWorld.getHandle();
        Chunk chunk = handle.getChunkAt(x >> 4, z >> 4);
        BlockPosition blockPos = new BlockPosition(x, y, z);
        IBlockData blockData = chunk.getType(blockPos);
        int internalId = Block.getCombinedId((IBlockData)blockData);
        BlockState state = BlockStateIdAccess.getBlockStateById((int)internalId);
        if (state == null) {
            org.bukkit.block.Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        if ((te = chunk.a(blockPos, Chunk.EnumTileEntityState.CHECK)) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_14_R3.readTileEntityIntoTag(te, tag);
            return state.toBaseBlock((CompoundTag)this.toNative((NBTBase)tag));
        }
        return state.toBaseBlock();
    }

    public boolean setBlock(Location location, BlockStateHolder state, boolean notifyAndLight) {
        TileEntity tileEntity;
        CompoundTag nativeTag;
        boolean successful;
        IBlockData newState;
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        Chunk chunk = craftWorld.getHandle().getChunkAt(x >> 4, z >> 4);
        BlockPosition blockPos = new BlockPosition(x, y, z);
        IBlockData old = chunk.getType(blockPos);
        OptionalInt blockStateId = BlockStateIdAccess.getBlockStateId((BlockState)state.toImmutableState());
        if (blockStateId.isPresent()) {
            newState = Block.getByCombinedId((int)blockStateId.getAsInt());
        } else {
            Block mcBlock = (Block)IRegistry.BLOCK.get(MinecraftKey.a((String)state.getBlockType().getId()));
            newState = mcBlock.getBlockData();
            Map states = state.getStates();
            newState = this.applyProperties((BlockStateList<Block, IBlockData>)mcBlock.getStates(), newState, states);
        }
        IBlockData successState = chunk.setType(blockPos, newState, false);
        boolean bl = successful = successState != null;
        if ((successful || old == newState) && state instanceof BaseBlock && (nativeTag = ((BaseBlock)state).getNbtData()) != null && (tileEntity = craftWorld.getHandle().getTileEntity(blockPos)) != null) {
            NBTTagCompound tag = (NBTTagCompound)this.fromNative((Tag)nativeTag);
            tag.set("x", (NBTBase)new NBTTagInt(x));
            tag.set("y", (NBTBase)new NBTTagInt(y));
            tag.set("z", (NBTBase)new NBTTagInt(z));
            Spigot_v1_14_R3.readTagIntoTileEntity(tag, tileEntity);
            successful = true;
        }
        if (successful && notifyAndLight) {
            craftWorld.getHandle().getChunkProvider().getLightEngine().a(blockPos);
            craftWorld.getHandle().notifyAndUpdatePhysics(blockPos, chunk, old, newState, newState, 3);
        }
        return successful;
    }

    private static EnumDirection adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return EnumDirection.NORTH;
            }
            case SOUTH: {
                return EnumDirection.SOUTH;
            }
            case WEST: {
                return EnumDirection.WEST;
            }
            case EAST: {
                return EnumDirection.EAST;
            }
            case DOWN: {
                return EnumDirection.DOWN;
            }
        }
        return EnumDirection.UP;
    }

    private IBlockData applyProperties(BlockStateList<Block, IBlockData> stateContainer, IBlockData newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            IBlockState property = stateContainer.a(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof BlockStateDirection) {
                Direction dir = (Direction)value;
                value = Spigot_v1_14_R3.adapt(dir);
            } else if (property instanceof BlockStateEnum) {
                String enumName = (String)((Object)value);
                value = (Comparable)((Object)((BlockStateEnum)property).b((String)((Object)value)).orElseGet(() -> {
                    throw new IllegalStateException("Enum property " + property.a() + " does not contain " + enumName);
                }));
            }
            newState = (IBlockData)newState.set(property, value);
        }
        return newState;
    }

    @Override
    public void notifyAndLightBlock(Location position, BlockState previousType) {
        CraftWorld craftWorld = (CraftWorld)position.getWorld();
        BlockPosition blockPosition = new BlockPosition(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        IBlockData oldData = ((CraftBlockData)BukkitAdapter.adapt(previousType)).getState();
        IBlockData newData = craftWorld.getHandle().getType(blockPosition);
        craftWorld.getHandle().notifyAndUpdatePhysics(blockPosition, null, oldData, newData, newData, 3);
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.server.v1_14_R1.Entity mcEntity = craftEntity.getHandle();
        String id = Spigot_v1_14_R3.getEntityId(mcEntity);
        if (id != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_14_R3.readEntityIntoTag(mcEntity, tag);
            return new BaseEntity(com.sk89q.worldedit.world.entity.EntityTypes.get((String)id), (CompoundTag)this.toNative((NBTBase)tag));
        }
        return null;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity state) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        net.minecraft.server.v1_14_R1.Entity createdEntity = Spigot_v1_14_R3.createEntityFromId(state.getType().getId(), (World)craftWorld.getHandle());
        if (createdEntity != null) {
            CompoundTag nativeTag = state.getNbtData();
            if (nativeTag != null) {
                NBTTagCompound tag = (NBTTagCompound)this.fromNative((Tag)nativeTag);
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.remove(name);
                }
                Spigot_v1_14_R3.readTagIntoEntity(tag, createdEntity);
            }
            createdEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            worldServer.addEntity(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        TreeMap properties = Maps.newTreeMap(String::compareTo);
        Block block = (Block)IRegistry.BLOCK.get(MinecraftKey.a((String)blockType.getId()));
        if (block == null) {
            this.logger.warning("Failed to find properties for " + blockType.getId());
            return properties;
        }
        BlockStateList blockStateList = block.getStates();
        for (IBlockState state : blockStateList.d()) {
            BooleanProperty property;
            if (state instanceof BlockStateBoolean) {
                property = new BooleanProperty(state.a(), (List)ImmutableList.copyOf((Collection)state.d()));
            } else if (state instanceof BlockStateDirection) {
                property = new DirectionalProperty(state.a(), state.d().stream().map(e -> Direction.valueOf((String)((INamable)e).getName().toUpperCase())).collect(Collectors.toList()));
            } else if (state instanceof BlockStateEnum) {
                property = new EnumProperty(state.a(), state.d().stream().map(e -> ((INamable)e).getName()).collect(Collectors.toList()));
            } else if (state instanceof BlockStateInteger) {
                property = new IntegerProperty(state.a(), (List)ImmutableList.copyOf((Collection)state.d()));
            } else {
                throw new IllegalArgumentException("WorldEdit needs an update to support " + state.getClass().getSimpleName());
            }
            properties.put(property.getName(), property);
        }
        return properties;
    }

    @Override
    public void sendFakeNBT(Player player, BlockVector3 pos, CompoundTag nbtData) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutTileEntityData(new BlockPosition(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, (NBTTagCompound)this.fromNative((Tag)nbtData)));
    }

    @Override
    public void sendFakeOP(Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityStatus((net.minecraft.server.v1_14_R1.Entity)((CraftPlayer)player).getHandle(), 28));
    }

    @Override
    public ItemStack adapt(BaseItemStack item) {
        net.minecraft.server.v1_14_R1.ItemStack stack = new net.minecraft.server.v1_14_R1.ItemStack((IMaterial)IRegistry.ITEM.get(MinecraftKey.a((String)item.getType().getId())), item.getAmount());
        stack.setTag((NBTTagCompound)this.fromNative((Tag)item.getNbtData()));
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_14_R1.ItemStack)stack);
    }

    @Override
    public BaseItemStack adapt(ItemStack itemStack) {
        net.minecraft.server.v1_14_R1.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        BaseItemStack weStack = new BaseItemStack(BukkitAdapter.asItemType(itemStack.getType()), itemStack.getAmount());
        weStack.setNbtData((CompoundTag)this.toNative((NBTBase)nmsStack.getTag()));
        return weStack;
    }

    @Override
    public boolean simulateItemUse(org.bukkit.World world, BlockVector3 position, BaseItem item, Direction face) {
        FakePlayer_v1_14_R3 fakePlayer;
        CraftWorld craftWorld = (CraftWorld)world;
        WorldServer worldServer = craftWorld.getHandle();
        net.minecraft.server.v1_14_R1.ItemStack stack = CraftItemStack.asNMSCopy((ItemStack)BukkitAdapter.adapt(item instanceof BaseItemStack ? (BaseItemStack)item : new BaseItemStack(item.getType(), item.getNbtData(), 1)));
        stack.setTag((NBTTagCompound)this.fromNative((Tag)item.getNbtData()));
        try {
            fakePlayer = (FakePlayer_v1_14_R3)((Object)this.fakePlayers.get((Object)worldServer));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.a(EnumHand.MAIN_HAND, stack);
        fakePlayer.setLocation(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPosition blockPos = new BlockPosition(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        Vec3D blockVec = new Vec3D((BaseBlockPosition)blockPos);
        EnumDirection enumFacing = Spigot_v1_14_R3.adapt(face);
        MovingObjectPositionBlock rayTrace = new MovingObjectPositionBlock(blockVec, enumFacing, blockPos, false);
        ItemActionContext context = new ItemActionContext((EntityHuman)fakePlayer, EnumHand.MAIN_HAND, rayTrace);
        EnumInteractionResult result = stack.placeItem(context, EnumHand.MAIN_HAND);
        if (result != EnumInteractionResult.SUCCESS) {
            result = worldServer.i(blockPos).interact((World)worldServer, (EntityHuman)fakePlayer, EnumHand.MAIN_HAND, rayTrace) ? EnumInteractionResult.SUCCESS : stack.getItem().a((World)worldServer, (EntityHuman)fakePlayer, EnumHand.MAIN_HAND).a();
        }
        return result == EnumInteractionResult.SUCCESS;
    }

    Tag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Set foreignKeys = ((NBTTagCompound)foreign).getKeys();
            for (String str : foreignKeys) {
                NBTBase base = ((NBTTagCompound)foreign).get(str);
                values.put(str, this.toNative(base));
            }
            return new CompoundTag(values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(((NBTTagByte)foreign).asByte());
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(((NBTTagByteArray)foreign).getBytes());
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(((NBTTagDouble)foreign).asDouble());
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(((NBTTagFloat)foreign).asFloat());
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(((NBTTagInt)foreign).asInt());
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(((NBTTagIntArray)foreign).getInts());
        }
        if (foreign instanceof NBTTagLongArray) {
            return new LongArrayTag(((NBTTagLongArray)foreign).getLongs());
        }
        if (foreign instanceof NBTTagList) {
            try {
                return this.toNativeList((NBTTagList)foreign);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert NBTTagList", e);
                return new ListTag(ByteTag.class, new ArrayList());
            }
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(((NBTTagLong)foreign).asLong());
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(((NBTTagShort)foreign).asShort());
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(foreign.asString());
        }
        if (foreign instanceof NBTTagEnd) {
            return new EndTag();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private ListTag toNativeList(NBTTagList foreign) throws SecurityException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Tag> values = new ArrayList<Tag>();
        int type = foreign.a_();
        List foreignList = (List)this.nbtListTagListField.get(foreign);
        for (int i = 0; i < foreign.size(); ++i) {
            NBTBase element = (NBTBase)foreignList.get(i);
            values.add(this.toNative(element));
        }
        Class cls = NBTConstants.getClassFromType((int)type);
        return new ListTag(cls, values);
    }

    NBTBase fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), this.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return new NBTTagByte(((ByteTag)foreign).getValue().byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return new NBTTagDouble(((DoubleTag)foreign).getValue().doubleValue());
        }
        if (foreign instanceof FloatTag) {
            return new NBTTagFloat(((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return new NBTTagInt(((IntTag)foreign).getValue().intValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof LongArrayTag) {
            return new NBTTagLongArray(((LongArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList();
            ListTag foreignList = (ListTag)foreign;
            for (Tag t : foreignList.getValue()) {
                tag.add((Object)this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return new NBTTagLong(((LongTag)foreign).getValue().longValue());
        }
        if (foreign instanceof ShortTag) {
            return new NBTTagShort(((ShortTag)foreign).getValue().shortValue());
        }
        if (foreign instanceof StringTag) {
            return new NBTTagString(((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            try {
                return (NBTBase)this.nbtCreateTagMethod.invoke(null, (byte)0);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }
}

