/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditListener;
import com.sk89q.worldedit.bukkit.adapter.AdapterLoadException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplLoader;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldEditPlugin
extends JavaPlugin
implements TabCompleter {
    private static final Logger log = LoggerFactory.getLogger(WorldEditPlugin.class);
    public static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private static WorldEditPlugin INSTANCE;
    private BukkitImplAdapter bukkitAdapter;
    private BukkitServerInterface server;
    private BukkitConfiguration config;

    public void onLoad() {
        INSTANCE = this;
        this.getDataFolder().mkdirs();
        WorldEdit worldEdit = WorldEdit.getInstance();
        this.server = new BukkitServerInterface(this, this.getServer());
        worldEdit.getPlatformManager().register((Platform)this.server);
        this.loadAdapter();
        this.setupRegistries();
        worldEdit.loadMappings();
        this.loadConfig();
    }

    public void onEnable() {
        this.setupTags();
        PermissionsResolverManager.initialize((Plugin)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL, (PluginMessageListener)new CUIChannelListener(this));
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditListener(this), (Plugin)this);
        WorldEdit.getInstance().getEventBus().post((Object)new PlatformReadyEvent());
        new Metrics((Plugin)this);
    }

    public void setupRegistries() {
        for (Biome biome : Biome.values()) {
            BiomeType.REGISTRY.register("minecraft:" + biome.name().toLowerCase(), (Object)new BiomeType("minecraft:" + biome.name().toLowerCase()));
        }
        for (Biome biome : Material.values()) {
            if (biome.isBlock() && !biome.isLegacy()) {
                BlockType.REGISTRY.register(biome.getKey().toString(), (Object)new BlockType(biome.getKey().toString(), blockState -> {
                    ParserContext context = new ParserContext();
                    context.setPreferringWildcard(true);
                    context.setTryLegacy(false);
                    context.setRestricted(false);
                    try {
                        FuzzyBlockState state = (FuzzyBlockState)((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(BukkitAdapter.adapt(blockState.getBlockType()).createBlockData().getAsString(), context)).toImmutableState();
                        BlockState defaultState = (BlockState)blockState.getBlockType().getAllStates().get(0);
                        for (Map.Entry propertyObjectEntry : state.getStates().entrySet()) {
                            defaultState = defaultState.with((Property)propertyObjectEntry.getKey(), propertyObjectEntry.getValue());
                        }
                        return defaultState;
                    }
                    catch (InputParseException e) {
                        e.printStackTrace();
                        return blockState;
                    }
                }));
            }
            if (!biome.isItem() || biome.isLegacy()) continue;
            ItemType.REGISTRY.register(biome.getKey().toString(), (Object)new ItemType(biome.getKey().toString()));
        }
        for (Biome biome : EntityType.values()) {
            String mcid = biome.getName();
            if (mcid == null) continue;
            com.sk89q.worldedit.world.entity.EntityType.REGISTRY.register("minecraft:" + mcid.toLowerCase(), (Object)new com.sk89q.worldedit.world.entity.EntityType("minecraft:" + mcid.toLowerCase()));
        }
    }

    private void setupTags() {
        try {
            for (Tag blockTag : Bukkit.getTags((String)"blocks", Material.class)) {
                BlockCategory.REGISTRY.register(blockTag.getKey().toString(), (Object)new BlockCategory(blockTag.getKey().toString()));
            }
            for (Tag itemTag : Bukkit.getTags((String)"items", Material.class)) {
                ItemCategory.REGISTRY.register(itemTag.getKey().toString(), (Object)new ItemCategory(itemTag.getKey().toString()));
            }
        }
        catch (NoSuchMethodError e) {
            this.getLogger().warning("The version of Spigot/Paper you are using doesn't support Tags. The usage of tags with WorldEdit will not work until you update.");
        }
    }

    private void loadConfig() {
        this.createDefaultConfiguration("config.yml");
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true), this);
        this.config.load();
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        BukkitImplLoader adapterLoader = new BukkitImplLoader();
        try {
            adapterLoader.addFromPath(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            log.warn("Failed to search path for Bukkit adapters");
        }
        try {
            adapterLoader.addFromJar(this.getFile());
        }
        catch (IOException e) {
            log.warn("Failed to search " + this.getFile() + " for Bukkit adapters", (Throwable)e);
        }
        try {
            this.bukkitAdapter = adapterLoader.loadAdapter();
            log.info("Using " + this.bukkitAdapter.getClass().getCanonicalName() + " as the Bukkit adapter");
        }
        catch (AdapterLoadException e) {
            Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            if (platform instanceof BukkitServerInterface) {
                log.warn(e.getMessage());
            }
            log.info("WorldEdit could not find a Bukkit adapter for this MC version, but it seems that you have another implementation of WorldEdit installed (" + platform.getPlatformName() + ") that handles the world editing.");
        }
    }

    public void onDisable() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        worldEdit.getPlatformManager().unregister((Platform)this.server);
        if (this.config != null) {
            this.config.unload();
        }
        if (this.server != null) {
            this.server.unregisterCommands();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
        this.getPermissionsResolver().load();
    }

    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            try (JarFile file = new JarFile(this.getFile());){
                ZipEntry copy = file.getEntry("defaults/" + name);
                if (copy == null) {
                    throw new FileNotFoundException();
                }
                this.copyDefaultConfig(file.getInputStream(copy), actual, name);
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to read default configuration: " + name);
            }
        }
    }

    private void copyDefaultConfig(InputStream input, File actual, String name) {
        try (FileOutputStream output = new FileOutputStream(actual);){
            int length;
            byte[] buf = new byte[8192];
            while ((length = input.read(buf)) > 0) {
                output.write(buf, 0, length);
            }
            this.getLogger().info("Default configuration file written: " + name);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Failed to write default config file", e);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = "/" + cmd.getName();
        CommandEvent event = new CommandEvent(this.wrapCommandSender(sender), Joiner.on((String)" ").join(split));
        this.getWorldEdit().getEventBus().post((Object)event);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = "/" + cmd.getName();
        CommandSuggestionEvent event = new CommandSuggestionEvent(this.wrapCommandSender(sender), Joiner.on((String)" ").join(split));
        this.getWorldEdit().getEventBus().post((Object)event);
        return event.getSuggestions();
    }

    public LocalSession getSession(org.bukkit.entity.Player player) {
        return WorldEdit.getInstance().getSessionManager().get((SessionOwner)this.wrapPlayer(player));
    }

    public EditSession createEditSession(org.bukkit.entity.Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        BlockBag blockBag = session.getBlockBag((Player)wePlayer);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(wePlayer.getWorld(), session.getBlockChangeLimit(), blockBag, (Player)wePlayer);
        editSession.enableStandardMode();
        return editSession;
    }

    public void remember(org.bukkit.entity.Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        session.remember(editSession);
        editSession.flushSession();
        WorldEdit.getInstance().flushBlockBag((Actor)wePlayer, editSession);
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return PermissionsResolverManager.getInstance();
    }

    public BukkitPlayer wrapPlayer(org.bukkit.entity.Player player) {
        return new BukkitPlayer(this, player);
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof org.bukkit.entity.Player) {
            return this.wrapPlayer((org.bukkit.entity.Player)sender);
        }
        return new BukkitCommandSender(this, sender);
    }

    BukkitServerInterface getInternalPlatform() {
        return this.server;
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    static WorldEditPlugin getInstance() {
        return (WorldEditPlugin)((Object)Preconditions.checkNotNull((Object)((Object)INSTANCE)));
    }

    @Nullable
    BukkitImplAdapter getBukkitImplAdapter() {
        return this.bukkitAdapter;
    }
}

