/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditListener;
import com.sk89q.worldedit.bukkit.adapter.AdapterLoadException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplLoader;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.session.SessionOwner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bstats.bukkit.Metrics;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class WorldEditPlugin
extends JavaPlugin
implements TabCompleter {
    private static final Logger log = Logger.getLogger(WorldEditPlugin.class.getCanonicalName());
    public static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private static WorldEditPlugin INSTANCE;
    private BukkitImplAdapter bukkitAdapter;
    private BukkitServerInterface server;
    private BukkitConfiguration config;

    public void onEnable() {
        INSTANCE = this;
        this.getDataFolder().mkdirs();
        WorldEdit worldEdit = WorldEdit.getInstance();
        this.server = new BukkitServerInterface(this, this.getServer());
        worldEdit.getPlatformManager().register((Platform)this.server);
        this.loadAdapter();
        worldEdit.loadMappings();
        this.loadConfig();
        PermissionsResolverManager.initialize((Plugin)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL, (PluginMessageListener)new CUIChannelListener(this));
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditListener(this), (Plugin)this);
        WorldEdit.getInstance().getEventBus().post((Object)new PlatformReadyEvent());
        new Metrics((Plugin)this);
    }

    private void loadConfig() {
        this.createDefaultConfiguration("config.yml");
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true), this);
        this.config.load();
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        BukkitImplLoader adapterLoader = new BukkitImplLoader();
        try {
            adapterLoader.addFromPath(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to search path for Bukkit adapters");
        }
        try {
            adapterLoader.addFromJar(this.getFile());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to search " + this.getFile() + " for Bukkit adapters", e);
        }
        try {
            this.bukkitAdapter = adapterLoader.loadAdapter();
            log.log(Level.INFO, "Using " + this.bukkitAdapter.getClass().getCanonicalName() + " as the Bukkit adapter");
        }
        catch (AdapterLoadException e) {
            Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            if (platform instanceof BukkitServerInterface) {
                log.log(Level.WARNING, e.getMessage());
            }
            log.log(Level.INFO, "WorldEdit could not find a Bukkit adapter for this MC version, but it seems that you have another implementation of WorldEdit installed (" + platform.getPlatformName() + ") that handles the world editing.");
        }
    }

    public void onDisable() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        worldEdit.getPlatformManager().unregister((Platform)this.server);
        if (this.config != null) {
            this.config.unload();
        }
        if (this.server != null) {
            this.server.unregisterCommands();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
        this.getPermissionsResolver().load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            InputStream input = null;
            try {
                JarFile file = new JarFile(this.getFile());
                ZipEntry copy = file.getEntry("defaults/" + name);
                if (copy == null) {
                    throw new FileNotFoundException();
                }
                input = file.getInputStream(copy);
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to read default configuration: " + name);
            }
            if (input != null) {
                FileOutputStream output = null;
                try {
                    int length;
                    output = new FileOutputStream(actual);
                    byte[] buf = new byte[8192];
                    while ((length = input.read(buf)) > 0) {
                        output.write(buf, 0, length);
                    }
                    this.getLogger().info("Default configuration file written: " + name);
                }
                catch (IOException e) {
                    this.getLogger().log(Level.WARNING, "Failed to write default config file", e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = cmd.getName();
        CommandEvent event = new CommandEvent(this.wrapCommandSender(sender), Joiner.on((String)" ").join(split));
        this.getWorldEdit().getEventBus().post((Object)event);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = cmd.getName();
        CommandSuggestionEvent event = new CommandSuggestionEvent(this.wrapCommandSender(sender), Joiner.on((String)" ").join(split));
        this.getWorldEdit().getEventBus().post((Object)event);
        return event.getSuggestions();
    }

    public LocalSession getSession(org.bukkit.entity.Player player) {
        return WorldEdit.getInstance().getSessionManager().get((SessionOwner)this.wrapPlayer(player));
    }

    public EditSession createEditSession(org.bukkit.entity.Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        BlockBag blockBag = session.getBlockBag((Player)wePlayer);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(wePlayer.getWorld(), session.getBlockChangeLimit(), blockBag, (Player)wePlayer);
        editSession.enableStandardMode();
        return editSession;
    }

    public void remember(org.bukkit.entity.Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        session.remember(editSession);
        editSession.flushSession();
        WorldEdit.getInstance().flushBlockBag((Actor)wePlayer, editSession);
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return PermissionsResolverManager.getInstance();
    }

    public BukkitPlayer wrapPlayer(org.bukkit.entity.Player player) {
        return new BukkitPlayer(this, player);
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof org.bukkit.entity.Player) {
            return this.wrapPlayer((org.bukkit.entity.Player)sender);
        }
        return new BukkitCommandSender(this, sender);
    }

    BukkitServerInterface getInternalPlatform() {
        return this.server;
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    static WorldEditPlugin getInstance() {
        return (WorldEditPlugin)((Object)Preconditions.checkNotNull((Object)((Object)INSTANCE)));
    }

    @Nullable
    BukkitImplAdapter getBukkitImplAdapter() {
        return this.bukkitAdapter;
    }
}

