/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.placeholders;

import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.placeholders.PlotSpecificPlaceholder;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlotFlagPlaceholder
extends PlotSpecificPlaceholder {
    private final PlotFlag<?, ?> flag;
    private final boolean local;

    public PlotFlagPlaceholder(@NonNull PlotFlag<?, ?> flag, boolean local) {
        super(String.format("currentplot_%sflag_%s", local ? "local" : "", flag.getName()));
        this.flag = flag;
        this.local = local;
    }

    @Override
    public @NonNull String getValue(@NonNull PlotPlayer<?> player, @NonNull Plot plot) {
        return this.getFlagValue(plot, this.flag.getName(), !this.local);
    }

    private @NonNull String getFlagValue(@NonNull Plot plot, @NonNull String flagName, boolean inherit) {
        if (flagName.isEmpty()) {
            return "";
        }
        PlotFlag<?, ?> flag = GlobalFlagContainer.getInstance().getFlagFromString(flagName);
        if (flag == null) {
            return "";
        }
        if (inherit) {
            return plot.getFlag(flag).toString();
        }
        Object plotFlag = plot.getFlagContainer().queryLocal(flag.getClass());
        return plotFlag != null ? ((PlotFlag)plotFlag).getValue().toString() : "";
    }
}

