/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue.subscriber;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultProgressSubscriber
implements ProgressSubscriber {
    private final @NonNull AtomicDouble progress = new AtomicDouble(0.0);
    private final @NonNull AtomicBoolean started = new AtomicBoolean(false);
    private final @NonNull AtomicBoolean cancelled = new AtomicBoolean(false);
    private final @NonNull TaskTime interval;
    private final @NonNull TaskTime wait;
    private final @NonNull PlotPlayer<?> actor;
    private final @NonNull Caption caption;
    private PlotSquaredTask task;

    @AssistedInject
    public DefaultProgressSubscriber() {
        throw new UnsupportedOperationException("DefaultProgressSubscriber cannot be used without an actor.");
    }

    @AssistedInject
    public DefaultProgressSubscriber(@Nullable @Assisted(value="subscriber") PlotPlayer<?> actor) {
        Preconditions.checkNotNull(actor, (Object)"Actor cannot be null when using DefaultProgressSubscriber! Make sure if attempting to use custom Subscribers it is correctly parsed to the queue!");
        this.actor = actor;
        this.interval = TaskTime.ms(Settings.QUEUE.NOTIFY_INTERVAL);
        this.wait = TaskTime.ms(Settings.QUEUE.NOTIFY_WAIT);
        this.caption = TranslatableCaption.of("working.progress");
    }

    @AssistedInject
    public DefaultProgressSubscriber(@Nullable @Assisted(value="subscriber") PlotPlayer<?> actor, @Assisted(value="progressInterval") long interval, @Assisted(value="waitBeforeStarting") long wait, @Nullable @Assisted(value="caption") Caption caption) {
        Preconditions.checkNotNull(actor, (Object)"Actor cannot be null when using DefaultProgressSubscriber! Make sure if attempting to use custom Subscribers it is correctly parsed to the queue!");
        this.actor = actor;
        this.interval = TaskTime.ms(interval);
        this.wait = TaskTime.ms(wait);
        this.caption = caption == null ? TranslatableCaption.of("working.progress") : caption;
    }

    @Override
    public void notifyProgress(@NonNull ChunkCoordinator coordinator, double progress) {
        this.progress.set(progress);
        if (this.started.compareAndSet(false, true)) {
            TaskManager.getPlatformImplementation().taskLater(() -> {
                this.task = TaskManager.getPlatformImplementation().taskRepeat(() -> {
                    if (!this.started.get()) {
                        return;
                    }
                    if (this.cancelled.get()) {
                        this.task.cancel();
                        return;
                    }
                    this.actor.sendMessage(this.caption, Template.of((String)"progress", (String)String.format("%.2f", this.progress.doubleValue() * 100.0)));
                }, this.interval);
            }, this.wait);
        }
    }

    @Override
    public void notifyEnd() {
        this.cancel();
    }

    public void cancel() {
        this.cancelled.set(true);
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

