/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChunkQueueCoordinator
extends ScopedQueueCoordinator {
    public final BiomeType[][][] biomeResult;
    public final BlockState[][][] result;
    private final int width;
    private final int length;
    private final BlockVector3 bot;
    private final BlockVector3 top;
    private final World weWorld;

    public ChunkQueueCoordinator(@NonNull World weWorld, @NonNull BlockVector3 bot, @NonNull BlockVector3 top, boolean biomes) {
        super(null, Location.at("", 0, 0, 0), Location.at("", 15, 255, 15));
        this.weWorld = weWorld;
        this.width = top.getX() - bot.getX() + 1;
        this.length = top.getZ() - bot.getZ() + 1;
        this.result = new BlockState[256][this.width][this.length];
        this.biomeResult = biomes ? new BiomeType[256][this.width][this.length] : null;
        this.bot = bot;
        this.top = top;
    }

    public @NonNull BlockState[][][] getBlocks() {
        return this.result;
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biomeType) {
        if (this.biomeResult != null) {
            for (int y = 0; y < 256; ++y) {
                this.storeCacheBiome(x, y, z, biomeType);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, @NonNull BiomeType biomeType) {
        if (this.biomeResult != null) {
            this.storeCacheBiome(x, y, z, biomeType);
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        this.storeCache(x, y, z, id);
        return true;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        this.storeCache(x, y, z, pattern.applyBlock(BlockVector3.at((int)x, (int)y, (int)z)).toImmutableState());
        return true;
    }

    private void storeCache(int x, int y, int z, @NonNull BlockState id) {
        BlockState[] resultYZ;
        BlockState[][] resultY = this.result[y];
        if (resultY == null) {
            resultY = new BlockState[this.length][];
            this.result[y] = resultY;
        }
        if ((resultYZ = resultY[z]) == null) {
            resultYZ = new BlockState[this.width];
            resultY[z] = resultYZ;
        }
        resultYZ[x] = id;
    }

    private void storeCacheBiome(int x, int y, int z, @NonNull BiomeType id) {
        BiomeType[] resultYZ;
        BiomeType[][] resultY = this.biomeResult[y];
        if (resultY == null) {
            resultY = new BiomeType[this.length][];
            this.biomeResult[y] = resultY;
        }
        if ((resultYZ = resultY[z]) == null) {
            resultYZ = new BiomeType[this.width];
            resultY[z] = resultYZ;
        }
        resultYZ[x] = id;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        this.storeCache(x, y, z, id.toImmutableState());
        return true;
    }

    @Override
    public @Nullable BlockState getBlock(int x, int y, int z) {
        BlockState[] blocksYZ;
        BlockState[][] blocksY = this.result[y];
        if (blocksY != null && (blocksYZ = blocksY[z]) != null) {
            return blocksYZ[x];
        }
        return null;
    }

    @Override
    public @Nullable World getWorld() {
        return this.weWorld;
    }

    @Override
    public @NonNull Location getMax() {
        return Location.at(this.getWorld().getName(), this.top.getX(), this.top.getY(), this.top.getZ());
    }

    @Override
    public @NonNull Location getMin() {
        return Location.at(this.getWorld().getName(), this.bot.getX(), this.bot.getY(), this.bot.getZ());
    }
}

