/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.inject.factory.ChunkCoordinatorFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChunkCoordinatorBuilder {
    private final List<BlockVector2> requestedChunks = new LinkedList<BlockVector2>();
    private final List<ProgressSubscriber> progressSubscribers = new ArrayList<ProgressSubscriber>();
    private final ChunkCoordinatorFactory chunkCoordinatorFactory;
    private Consumer<Throwable> throwableConsumer = Throwable::printStackTrace;
    private World world;
    private Consumer<BlockVector2> chunkConsumer;
    private Runnable whenDone = () -> {};
    private long maxIterationTime = Settings.QUEUE.MAX_ITERATION_TIME;
    private int initialBatchSize = Settings.QUEUE.INITIAL_BATCH_SIZE;
    private boolean unloadAfter = true;

    @Inject
    public ChunkCoordinatorBuilder(@NonNull ChunkCoordinatorFactory chunkCoordinatorFactory) {
        this.chunkCoordinatorFactory = chunkCoordinatorFactory;
    }

    public @NonNull ChunkCoordinatorBuilder inWorld(@NonNull World world) {
        this.world = (World)Preconditions.checkNotNull((Object)world, (Object)"World may not be null");
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withChunk(@NonNull BlockVector2 chunkLocation) {
        this.requestedChunks.add((BlockVector2)Preconditions.checkNotNull((Object)chunkLocation, (Object)"Chunk location may not be null"));
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withChunks(@NonNull Collection<BlockVector2> chunkLocations) {
        chunkLocations.forEach(this::withChunk);
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withRegion(@NonNull Location pos1, @NonNull Location pos2) {
        int p1x = pos1.getX();
        int p1z = pos1.getZ();
        int p2x = pos2.getX();
        int p2z = pos2.getZ();
        int bcx = p1x >> 4;
        int bcz = p1z >> 4;
        int tcx = p2x >> 4;
        int tcz = p2z >> 4;
        ArrayList<BlockVector2> chunks = new ArrayList<BlockVector2>();
        for (int x = bcx; x <= tcx; ++x) {
            for (int z = bcz; z <= tcz; ++z) {
                chunks.add(BlockVector2.at((int)x, (int)z));
            }
        }
        chunks.forEach(this::withChunk);
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withConsumer(@NonNull Consumer<BlockVector2> chunkConsumer) {
        this.chunkConsumer = (Consumer)Preconditions.checkNotNull(chunkConsumer, (Object)"Chunk consumer may not be null");
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withFinalAction(@Nullable Runnable whenDone) {
        if (whenDone == null) {
            return this;
        }
        this.whenDone = whenDone;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withMaxIterationTime(long maxIterationTime) {
        Preconditions.checkArgument((maxIterationTime > 0L ? 1 : 0) != 0, (Object)"Max iteration time must be positive");
        this.maxIterationTime = maxIterationTime;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withInitialBatchSize(int initialBatchSize) {
        Preconditions.checkArgument((initialBatchSize > 0 ? 1 : 0) != 0, (Object)"Initial batch size must be positive");
        this.initialBatchSize = initialBatchSize;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withThrowableConsumer(@NonNull Consumer<Throwable> throwableConsumer) {
        this.throwableConsumer = (Consumer)Preconditions.checkNotNull(throwableConsumer, (Object)"Throwable consumer may not be null");
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder unloadAfter(boolean unloadAfter) {
        this.unloadAfter = unloadAfter;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withProgressSubscriber(ProgressSubscriber progressSubscriber) {
        this.progressSubscribers.add(progressSubscriber);
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withProgressSubscribers(Collection<ProgressSubscriber> progressSubscribers) {
        this.progressSubscribers.addAll(progressSubscribers);
        return this;
    }

    public @NonNull ChunkCoordinator build() {
        Preconditions.checkNotNull((Object)this.world, (Object)"No world was supplied");
        Preconditions.checkNotNull(this.chunkConsumer, (Object)"No chunk consumer was supplied");
        Preconditions.checkNotNull((Object)this.whenDone, (Object)"No final action was supplied");
        Preconditions.checkNotNull(this.throwableConsumer, (Object)"No throwable consumer was supplied");
        return this.chunkCoordinatorFactory.create(this.maxIterationTime, this.initialBatchSize, this.chunkConsumer, this.world, this.requestedChunks, this.whenDone, this.throwableConsumer, this.unloadAfter, this.progressSubscribers);
    }
}

