/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.entity.EntityCategories;
import com.plotsquared.core.util.entity.EntityCategory;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.uuid.UUIDMapping;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.entity.EntityType;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debug", category=CommandCategory.DEBUG, usage="/plot debug", permission="plots.admin")
public class Debug
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public Debug(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        if (args.length == 0) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot debug <loadedchunks | player | debug-players | entitytypes | msg>"));
        }
        if (args.length > 0 && "player".equalsIgnoreCase(args[0])) {
            for (Map.Entry<String, Object> meta : player.getMeta().entrySet()) {
                player.sendMessage(StaticCaption.of("Key: " + meta.getKey() + " Value: " + meta.getValue().toString() + " , "), new Template[0]);
            }
            return true;
        }
        if (args.length > 0 && "loadedchunks".equalsIgnoreCase(args[0])) {
            long start = System.currentTimeMillis();
            player.sendMessage(TranslatableCaption.of("debug.fetching_loaded_chunks"), new Template[0]);
            TaskManager.runTaskAsync(() -> player.sendMessage(StaticCaption.of("Loaded chunks: " + this.worldUtil.getChunkChunks(player.getLocation().getWorldName()).size() + " (" + (System.currentTimeMillis() - start) + "ms) using thread: " + Thread.currentThread().getName()), new Template[0]));
            return true;
        }
        if (args.length > 0 && "uuids".equalsIgnoreCase(args[0])) {
            Collection<UUIDMapping> mappings = PlotSquared.get().getImpromptuUUIDPipeline().getAllImmediately();
            player.sendMessage(TranslatableCaption.of("debug.cached_uuids"), Template.of((String)"value", (String)String.valueOf(mappings.size())));
            return true;
        }
        if (args.length > 0 && "debug-players".equalsIgnoreCase(args[0])) {
            player.sendMessage(TranslatableCaption.of("debug.player_in_debugmode"), new Template[0]);
            for (PlotPlayer<?> pp : PlotPlayer.getDebugModePlayers()) {
                player.sendMessage(TranslatableCaption.of("debug.player_in_debugmode_list"), Template.of((String)"value", (String)pp.getName()));
            }
            return true;
        }
        if (args.length > 0 && "entitytypes".equalsIgnoreCase(args[0])) {
            EntityCategories.init();
            player.sendMessage(TranslatableCaption.of("debug.entity_categories"), new Template[0]);
            EntityCategory.REGISTRY.forEach(category -> {
                StringBuilder builder = new StringBuilder("\u00a77- \u00a76").append(category.getId()).append("\u00a77: \u00a76");
                for (EntityType entityType : category.getAll()) {
                    builder.append(entityType.getId()).append(" ");
                }
                player.sendMessage(StaticCaption.of("<prefix>" + builder), new Template[0]);
            });
            EntityType.REGISTRY.values().stream().sorted(Comparator.comparing(EntityType::getId)).forEach(entityType -> {
                long categoryCount = EntityCategory.REGISTRY.values().stream().filter(category -> category.contains((Keyed)entityType)).count();
                if (categoryCount > 0L) {
                    return;
                }
                player.sendMessage(StaticCaption.of("<prefix>" + entityType.getName() + " is in " + categoryCount + " categories"), new Template[0]);
            });
            return true;
        }
        Set<TranslatableCaption> captions = PlotSquared.get().getCaptionMap("plotsquared").getCaptions();
        TextComponent.Builder information = Component.text();
        Component header = MINI_MESSAGE.parse(TranslatableCaption.of("debug.debug_header").getComponent(player) + "\n");
        String line = TranslatableCaption.of("debug.debug_line").getComponent(player) + "\n";
        String section = TranslatableCaption.of("debug.debug_section").getComponent(player) + "\n";
        information.append(header);
        information.append(MINI_MESSAGE.parse(section, new Template[]{Template.of((String)"val", (String)"PlotArea")}));
        information.append(MINI_MESSAGE.parse(line, new Template[]{Template.of((String)"var", (String)"Plot Worlds"), Template.of((String)"val", (String)StringMan.join(this.plotAreaManager.getAllPlotAreas(), ", "))}));
        information.append(MINI_MESSAGE.parse(line, new Template[]{Template.of((String)"var", (String)"Owned Plots"), Template.of((String)"val", (String)String.valueOf(PlotQuery.newQuery().allPlots().count()))}));
        information.append(MINI_MESSAGE.parse(section, new Template[]{Template.of((String)"val", (String)"Messages")}));
        information.append(MINI_MESSAGE.parse(line, new Template[]{Template.of((String)"var", (String)"Total Messages"), Template.of((String)"val", (String)String.valueOf(captions.size()))}));
        player.sendMessage(StaticCaption.of((String)MINI_MESSAGE.serialize((Component)information.build())), new Template[0]);
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return Stream.of("loadedchunks", "debug-players", "entitytypes").filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "plots.admin", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

